/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Date;

public class DateDeserializer
extends StdDeserializer<Date> {
    public DateDeserializer() {
        super(Date.class);
    }

    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken token = jp.getCurrentToken();
        if (token == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object date = jp.getEmbeddedObject();
            if (date instanceof Date) {
                return (Date)date;
            }
            throw ctxt.mappingException(Date.class);
        }
        return this._parseDate(jp, ctxt);
    }
}

