/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.beanio.BeanIOConfigurationException;
import org.beanio.internal.compiler.ParserFactory;
import org.beanio.internal.config.BeanIOConfig;
import org.beanio.internal.config.ConfigurationLoader;
import org.beanio.internal.config.StreamConfig;
import org.beanio.internal.config.TypeHandlerConfig;
import org.beanio.internal.config.xml.XmlConfigurationLoader;
import org.beanio.internal.parser.Stream;
import org.beanio.internal.util.BeanUtil;
import org.beanio.internal.util.Settings;
import org.beanio.internal.util.TypeHandlerFactory;
import org.beanio.types.TypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamCompiler {
    private ClassLoader classLoader;
    private ConfigurationLoader configurationLoader;
    private ConfigurationLoader defaultConfigurationLoader;

    public StreamCompiler(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.defaultConfigurationLoader = new XmlConfigurationLoader(classLoader);
    }

    public Stream build(StreamConfig config) throws BeanIOConfigurationException {
        TypeHandlerFactory typeHandlerFactory = this.createTypeHandlerFactory(TypeHandlerFactory.getDefault(), config.getHandlerList());
        ParserFactory factory = this.createParserFactory(config.getFormat());
        factory.setClassLoader(this.classLoader);
        factory.setTypeHandlerFactory(typeHandlerFactory);
        return factory.createStream(config);
    }

    public Collection<Stream> loadMapping(InputStream in, Properties properties) throws IOException, BeanIOConfigurationException {
        Collection<BeanIOConfig> configList;
        ConfigurationLoader loader = this.configurationLoader;
        if (loader == null) {
            loader = this.getDefaultConfigurationLoader();
        }
        if ((configList = loader.loadConfiguration(in, properties)).isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> set = new HashSet<String>();
        for (BeanIOConfig config : configList) {
            for (StreamConfig streamConfig : config.getStreamList()) {
                if (set.add(streamConfig.getName())) continue;
                throw new BeanIOConfigurationException("Duplicate stream name '" + streamConfig.getName() + "'");
            }
        }
        set = null;
        if (configList.size() == 1) {
            return this.createStreamDefinitions(configList.iterator().next());
        }
        ArrayList<Stream> list = new ArrayList<Stream>();
        for (BeanIOConfig config : configList) {
            list.addAll(this.createStreamDefinitions(config));
        }
        return list;
    }

    protected ConfigurationLoader getDefaultConfigurationLoader() {
        return this.defaultConfigurationLoader;
    }

    protected Collection<Stream> createStreamDefinitions(BeanIOConfig config) throws BeanIOConfigurationException {
        if (config == null) {
            throw new BeanIOConfigurationException("null configuration");
        }
        TypeHandlerFactory parent = this.createTypeHandlerFactory(TypeHandlerFactory.getDefault(), config.getTypeHandlerList());
        List<StreamConfig> streamConfigList = config.getStreamList();
        ArrayList<Stream> streamDefinitionList = new ArrayList<Stream>(streamConfigList.size());
        for (StreamConfig streamConfig : streamConfigList) {
            TypeHandlerFactory typeHandlerFactory = this.createTypeHandlerFactory(parent, streamConfig.getHandlerList());
            ParserFactory factory = this.createParserFactory(streamConfig.getFormat());
            factory.setClassLoader(this.classLoader);
            factory.setTypeHandlerFactory(typeHandlerFactory);
            try {
                streamDefinitionList.add(factory.createStream(streamConfig));
            }
            catch (BeanIOConfigurationException ex) {
                if (config.getSource() != null) {
                    throw new BeanIOConfigurationException("Invalid mapping file '" + config.getSource() + "': " + ex.getMessage());
                }
                throw ex;
            }
        }
        return streamDefinitionList;
    }

    protected ParserFactory createParserFactory(String format) {
        String clazz = Settings.getInstance().getProperty("org.beanio." + format + ".streamDefinitionFactory");
        if (clazz == null) {
            throw new BeanIOConfigurationException("A stream definition factory  is not configured for format '" + format + "'");
        }
        Object factory = BeanUtil.createBean(this.classLoader, clazz);
        if (!ParserFactory.class.isAssignableFrom(factory.getClass())) {
            throw new BeanIOConfigurationException("Configured stream definition factory '" + clazz + "' does not implement '" + ParserFactory.class.getName() + "'");
        }
        return (ParserFactory)factory;
    }

    private TypeHandlerFactory createTypeHandlerFactory(TypeHandlerFactory parent, List<TypeHandlerConfig> configList) {
        if (configList == null || configList.isEmpty()) {
            return parent;
        }
        TypeHandlerFactory factory = new TypeHandlerFactory(this.classLoader, parent);
        for (TypeHandlerConfig hc : configList) {
            if (hc.getName() == null && hc.getType() == null) {
                throw new BeanIOConfigurationException("Type handler must specify either 'type' or 'name'");
            }
            TypeHandler h = (TypeHandler)hc.getInstance();
            if (h == null) {
                Object bean;
                try {
                    bean = BeanUtil.createBean(this.classLoader, hc.getClassName(), hc.getProperties());
                }
                catch (BeanIOConfigurationException ex) {
                    if (hc.getName() != null) {
                        throw new BeanIOConfigurationException("Failed to create type handler named '" + hc.getName() + "'", ex);
                    }
                    throw new BeanIOConfigurationException("Failed to create type handler for type '" + hc.getType() + "'", ex);
                }
                if (!TypeHandler.class.isAssignableFrom(bean.getClass())) {
                    throw new BeanIOConfigurationException("Type handler class '" + hc.getClassName() + "' does not implement TypeHandler interface");
                }
                h = (TypeHandler)bean;
            }
            if (hc.getName() != null) {
                factory.registerHandler(hc.getName(), h);
            }
            if (hc.getType() == null) continue;
            try {
                factory.registerHandlerFor(hc.getType(), h, hc.getFormat());
            }
            catch (IllegalArgumentException ex) {
                throw new BeanIOConfigurationException("Invalid type handler configuration", ex);
            }
        }
        return factory;
    }

    public ConfigurationLoader getConfigurationLoader() {
        return this.configurationLoader;
    }

    public void setConfigurationLoader(ConfigurationLoader configurationLoader) {
        this.configurationLoader = configurationLoader;
    }
}

