/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.beanio.BeanReader;
import org.beanio.BeanWriter;
import org.beanio.Marshaller;
import org.beanio.Unmarshaller;
import org.beanio.internal.parser.BeanReaderImpl;
import org.beanio.internal.parser.BeanWriterImpl;
import org.beanio.internal.parser.Component;
import org.beanio.internal.parser.MarshallerImpl;
import org.beanio.internal.parser.MarshallingContext;
import org.beanio.internal.parser.MessageFactory;
import org.beanio.internal.parser.ParserLocal;
import org.beanio.internal.parser.ParsingContext;
import org.beanio.internal.parser.Selector;
import org.beanio.internal.parser.StreamFormat;
import org.beanio.internal.parser.UnmarshallerImpl;
import org.beanio.internal.parser.UnmarshallingContext;
import org.beanio.stream.RecordMarshaller;
import org.beanio.stream.RecordUnmarshaller;

public class Stream {
    public static final int READ_WRITE_MODE = 0;
    public static final int READ_ONLY_MODE = 1;
    public static final int WRITE_ONLY_MODE = 2;
    private int mode;
    private StreamFormat format;
    private Selector layout;
    private MessageFactory messageFactory;
    private boolean ignoreUnidentifiedRecords;
    private Set<ParserLocal<?>> locals;

    public Stream(StreamFormat format) {
        if (format == null) {
            throw new NullPointerException("null format");
        }
        this.format = format;
    }

    public void init() {
        this.locals = new HashSet();
        Component parser = (Component)((Object)this.layout);
        parser.registerLocals(this.locals);
    }

    public String getName() {
        return this.format.getName();
    }

    public BeanReader createBeanReader(Reader in, Locale locale) {
        if (in == null) {
            throw new NullPointerException("null reader");
        }
        UnmarshallingContext context = this.format.createUnmarshallingContext();
        this.initContext(context);
        context.setMessageFactory(this.messageFactory);
        context.setLocale(locale);
        context.setRecordReader(this.format.createRecordReader(in));
        BeanReaderImpl reader = new BeanReaderImpl(context, this.layout);
        reader.setIgnoreUnidentifiedRecords(this.ignoreUnidentifiedRecords);
        return reader;
    }

    public Unmarshaller createUnmarshaller(Locale locale) {
        RecordUnmarshaller recordUnmarshaller = this.format.createRecordUnmarshaller();
        if (recordUnmarshaller == null) {
            throw new IllegalArgumentException("Unmarshaller not supported for stream format");
        }
        UnmarshallingContext context = this.format.createUnmarshallingContext();
        this.initContext(context);
        context.setMessageFactory(this.messageFactory);
        context.setLocale(locale);
        return new UnmarshallerImpl(context, this.layout, recordUnmarshaller);
    }

    public BeanWriter createBeanWriter(Writer out) {
        if (out == null) {
            throw new NullPointerException("null writer");
        }
        MarshallingContext context = this.format.createMarshallingContext(true);
        this.initContext(context);
        context.setRecordWriter(this.format.createRecordWriter(out));
        BeanWriterImpl writer = new BeanWriterImpl(context, this.layout);
        return writer;
    }

    public Marshaller createMarshaller() {
        RecordMarshaller recordMarshaller = this.format.createRecordMarshaller();
        if (recordMarshaller == null) {
            throw new IllegalArgumentException("Marshaller not supported for stream format");
        }
        MarshallingContext context = this.format.createMarshallingContext(false);
        this.initContext(context);
        return new MarshallerImpl(context, this.layout, recordMarshaller);
    }

    private void initContext(ParsingContext context) {
        context.createHeap(this.locals.size());
        int i = 0;
        for (ParserLocal<?> local : this.locals) {
            local.init(i++, context);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public Selector getLayout() {
        return this.layout;
    }

    public void setLayout(Selector layout) {
        this.layout = layout;
    }

    public StreamFormat getFormat() {
        return this.format;
    }

    public void setFormat(StreamFormat format) {
        this.format = format;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public boolean isIgnoreUnidentifiedRecords() {
        return this.ignoreUnidentifiedRecords;
    }

    public void setIgnoreUnidentifiedRecords(boolean ignoreUnidentifiedRecords) {
        this.ignoreUnidentifiedRecords = ignoreUnidentifiedRecords;
    }
}

