/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.beanio.stream.json.JsonParserConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JsonWriterSupport {
    private static final String DEFAULT_LINE_SEP = System.getProperty("line.separator");
    private Writer out;
    private boolean pretty = true;
    private int indent = 2;
    private String lineSeparator = DEFAULT_LINE_SEP;
    private transient boolean indentEnabled = true;
    private transient int level = 0;

    JsonWriterSupport() {
    }

    protected void init(Writer out, JsonParserConfiguration config) {
        this.out = out;
        this.pretty = config.isPretty();
        this.indent = config.getIndentation();
        this.indentEnabled = config.isPretty();
        if (config.getLineSeparator() != null) {
            this.lineSeparator = config.getLineSeparator();
        }
    }

    protected void write(Map<String, Object> map) throws IOException {
        ++this.level;
        this.out.write(123);
        boolean comma = false;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (comma) {
                this.out.write(44);
                if (this.indentEnabled) {
                    this.newLine();
                } else if (this.pretty) {
                    this.out.write(32);
                }
            } else {
                this.checkLine();
            }
            this.writeString(entry.getKey());
            if (this.pretty) {
                this.out.write(": ");
            } else {
                this.out.write(58);
            }
            this.writeValue(entry.getValue());
            comma = true;
        }
        --this.level;
        this.checkLine();
        this.out.write(125);
    }

    protected void writeValue(Object value) throws IOException {
        if (value == null) {
            this.out.write("null");
        } else if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof Boolean || value instanceof Number) {
            this.out.write(value.toString());
        } else if (value instanceof Map) {
            this.write((Map)value);
        } else if (value instanceof Iterable) {
            this.writeArray((Iterable)value);
        } else {
            this.writeString(value.toString());
        }
    }

    protected void writeString(String text) throws IOException {
        this.out.write(34);
        block8: for (char c : text.toCharArray()) {
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    this.out.write(92);
                    this.out.write(c);
                    continue block8;
                }
                case '\t': {
                    this.out.write("\\t");
                    continue block8;
                }
                case '\n': {
                    this.out.write("\\n");
                    continue block8;
                }
                case '\r': {
                    this.out.write("\\r");
                    continue block8;
                }
                case '\f': {
                    this.out.write("\\f");
                    continue block8;
                }
                case '\b': {
                    this.out.write("\\b");
                    continue block8;
                }
                default: {
                    this.out.write(c);
                }
            }
        }
        this.out.write(34);
    }

    protected void writeArray(Iterable<Object> iterable) throws IOException {
        Iterator<Object> iter = iterable.iterator();
        if (!iter.hasNext()) {
            this.out.write("[]");
            return;
        }
        this.out.write(91);
        Object value = iter.next();
        if (this.pretty) {
            boolean updated = this.indentEnabled;
            this.indentEnabled = false;
            if (value instanceof Map) {
                ++this.level;
                this.newLine();
                this.writeValue(value);
                while (iter.hasNext()) {
                    this.out.write(44);
                    this.newLine();
                    this.writeValue(iter.next());
                }
                --this.level;
                this.newLine();
            } else {
                this.writeValue(value);
                while (iter.hasNext()) {
                    this.out.write(", ");
                    this.writeValue(iter.next());
                }
            }
            if (updated) {
                this.indentEnabled = true;
            }
        } else {
            this.writeValue(value);
            while (iter.hasNext()) {
                this.out.write(44);
                this.writeValue(iter.next());
            }
        }
        this.out.write(93);
    }

    private void checkLine() throws IOException {
        if (this.indentEnabled) {
            this.newLine();
        }
    }

    private void newLine() throws IOException {
        this.out.write(this.lineSeparator);
        int j = this.level * this.indent;
        for (int i = 0; i < j; ++i) {
            this.out.write(32);
        }
    }

    protected boolean isPretty() {
        return this.pretty;
    }

    protected int getIndent() {
        return this.indent;
    }

    protected String getLineSeparator() {
        return this.lineSeparator;
    }
}

