/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.stream.xml;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementStack {
    private ElementStack parent;
    private String dns;
    private String ns;
    private String prefix;
    private String name;
    private Map<String, String> nsMap;

    public ElementStack(ElementStack parent, String ns, String prefix, String name) {
        this.parent = parent;
        this.ns = ns;
        this.prefix = prefix;
        this.name = name;
        if (prefix == null) {
            this.dns = ns;
        } else {
            this.dns = parent == null ? null : parent.dns;
            this.addNamespace(prefix, ns);
        }
    }

    public ElementStack getParent() {
        return this.parent;
    }

    public String getDefaultNamespace() {
        return this.dns;
    }

    public boolean isDefaultNamespace() {
        if (this.ns == null) {
            return true;
        }
        if (this.parent == null) {
            return this.ns.length() == 0;
        }
        return this.ns.equals(this.dns);
    }

    public boolean isDefaultNamespace(String namespace) {
        return this.dns != null && this.dns.equals(namespace);
    }

    public String getNamespace() {
        return this.ns;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public void addNamespace(String prefix, String namespace) {
        if (this.nsMap == null) {
            this.nsMap = new HashMap<String, String>();
        }
        this.nsMap.put(namespace, prefix);
    }

    public Map<String, String> getNamespaces() {
        return this.nsMap;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.nsMap = namespaces;
    }

    public String findPrefix(String namespace) {
        String prefix = null;
        if (this.nsMap != null && (prefix = this.nsMap.get(namespace)) != null) {
            return prefix;
        }
        if (this.parent != null) {
            return this.parent.findPrefix(namespace);
        }
        return null;
    }

    public String toToken() {
        StringBuilder s = new StringBuilder();
        if (this.ns != null) {
            s.append("{").append(this.ns).append("}");
        }
        if (this.prefix != null) {
            s.append(this.prefix).append(':');
        }
        s.append(this.name);
        return s.toString();
    }

    public static ElementStack fromToken(ElementStack parent, String token) {
        int pos;
        if (token == null || "".equals(token.trim())) {
            throw new IllegalArgumentException("Missing ElementStack token");
        }
        String namespace = null;
        String prefix = null;
        String name = null;
        int start = 0;
        if (token.startsWith("{")) {
            pos = token.indexOf(125);
            namespace = token.substring(1, pos);
            start = pos + 1;
        }
        if ((pos = token.indexOf(58, start)) > 0) {
            prefix = token.substring(start, pos);
            start = pos + 1;
        }
        name = token.substring(start);
        return new ElementStack(parent, namespace, prefix, name);
    }

    public String toString() {
        return this.toToken();
    }
}

