/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.types;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Properties;
import org.beanio.types.ConfigurableTypeHandler;
import org.beanio.types.LocaleSupport;
import org.beanio.types.TypeConversionException;
import org.beanio.types.TypeHandler;

public abstract class NumberTypeHandler
extends LocaleSupport
implements ConfigurableTypeHandler,
Cloneable {
    private String pattern;
    private transient DecimalFormat format;

    public final Number parse(String text) throws TypeConversionException {
        if (text == null || "".equals(text)) {
            return null;
        }
        if (this.pattern == null) {
            try {
                return this.createNumber(text);
            }
            catch (NumberFormatException ex) {
                throw new TypeConversionException("Invalid " + this.getType().getSimpleName() + " value '" + text + "'", ex);
            }
        }
        DecimalFormat df = this.format;
        if (df == null) {
            df = this.createDecimalFormat();
            df.setParseBigDecimal(true);
        }
        ParsePosition pp = new ParsePosition(0);
        Number number = df.parse(text, pp);
        if (pp.getErrorIndex() >= 0 || pp.getIndex() != text.length() || !(number instanceof BigDecimal)) {
            throw new TypeConversionException("Number value '" + text + "' does not match pattern '" + this.pattern + "'");
        }
        try {
            return this.createNumber((BigDecimal)number);
        }
        catch (ArithmeticException ex) {
            throw new TypeConversionException("Invalid " + this.getType().getSimpleName() + " value '" + text + "'");
        }
    }

    protected abstract Number createNumber(String var1) throws NumberFormatException;

    protected abstract Number createNumber(BigDecimal var1) throws ArithmeticException;

    public TypeHandler newInstance(Properties properties) throws IllegalArgumentException {
        String pattern = properties.getProperty("format");
        if (pattern == null || "".equals(pattern)) {
            return this;
        }
        try {
            NumberTypeHandler handler = (NumberTypeHandler)this.clone();
            handler.setPattern(pattern);
            handler.format = handler.createDecimalFormat();
            handler.format.setParseBigDecimal(true);
            return handler;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected DecimalFormat createDecimalFormat() {
        return new DecimalFormat(this.pattern, DecimalFormatSymbols.getInstance(this.locale));
    }

    public String format(Object value) {
        if (value == null) {
            return null;
        }
        if (this.pattern == null) {
            return ((Number)value).toString();
        }
        if (this.format != null) {
            return this.format.format(value);
        }
        return this.createDecimalFormat().format(value);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        try {
            if (pattern != null) {
                new DecimalFormat(pattern);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid decimal format '" + pattern + "': " + ex.getMessage());
        }
        this.pattern = pattern;
    }
}

