/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.DocumentHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.WriteOperation;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.codecs.BsonDocumentCodec;

public class CreateCollectionOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final String databaseName;
    private final String collectionName;
    private boolean capped = false;
    private long sizeInBytes = 0L;
    private boolean autoIndex = true;
    private long maxDocuments = 0L;
    private Boolean usePowerOf2Sizes = null;
    private BsonDocument storageEngineOptions;

    public CreateCollectionOperation(String databaseName, String collectionName) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.collectionName = Assertions.notNull("collectionName", collectionName);
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean isAutoIndex() {
        return this.autoIndex;
    }

    public CreateCollectionOperation autoIndex(boolean autoIndex) {
        this.autoIndex = autoIndex;
        return this;
    }

    public long getMaxDocuments() {
        return this.maxDocuments;
    }

    public CreateCollectionOperation maxDocuments(long maxDocuments) {
        this.maxDocuments = maxDocuments;
        return this;
    }

    public boolean isCapped() {
        return this.capped;
    }

    public CreateCollectionOperation capped(boolean capped) {
        this.capped = capped;
        return this;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public CreateCollectionOperation sizeInBytes(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    public Boolean isUsePowerOf2Sizes() {
        return this.usePowerOf2Sizes;
    }

    public CreateCollectionOperation usePowerOf2Sizes(Boolean usePowerOf2Sizes) {
        this.usePowerOf2Sizes = usePowerOf2Sizes;
        return this;
    }

    public BsonDocument getStorageEngineOptions() {
        return this.storageEngineOptions;
    }

    public CreateCollectionOperation storageEngineOptions(BsonDocument storageEngineOptions) {
        this.storageEngineOptions = storageEngineOptions;
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        CommandOperationHelper.executeWrappedCommandProtocol(this.databaseName, this.asDocument(), new BsonDocumentCodec(), binding);
        return null;
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(this.databaseName, this.asDocument(), new BsonDocumentCodec(), binding, new OperationHelper.VoidTransformer(), callback);
    }

    private BsonDocument asDocument() {
        BsonDocument document = new BsonDocument("create", new BsonString(this.collectionName));
        document.put("capped", BsonBoolean.valueOf(this.capped));
        if (this.capped) {
            DocumentHelper.putIfNotZero(document, "size", this.sizeInBytes);
            document.put("autoIndexId", BsonBoolean.valueOf(this.autoIndex));
            DocumentHelper.putIfNotZero(document, "max", this.maxDocuments);
        }
        if (this.usePowerOf2Sizes != null) {
            document.put("usePowerOfTwoSizes", BsonBoolean.valueOf(this.usePowerOf2Sizes));
        }
        if (this.storageEngineOptions != null) {
            document.put("storageEngine", this.storageEngineOptions);
        }
        return document;
    }
}

