/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.List;
import org.mongojack.JacksonDBCollection;
import org.mongojack.internal.stream.JacksonDBObject;

public class WriteResult<T, K> {
    private final JacksonDBCollection<T, K> jacksonDBCollection;
    private final DBObject[] dbObjects;
    private final com.mongodb.WriteResult writeResult;
    private List<T> objects;

    protected WriteResult(JacksonDBCollection<T, K> jacksonDBCollection, com.mongodb.WriteResult writeResult, DBObject ... dbObjects) {
        this.jacksonDBCollection = jacksonDBCollection;
        this.writeResult = writeResult;
        this.dbObjects = dbObjects;
    }

    public T getSavedObject() {
        if (this.dbObjects.length == 0) {
            throw new MongoException("No objects to return");
        }
        return this.getSavedObjects().get(0);
    }

    public List<T> getSavedObjects() {
        if (this.objects == null) {
            if (this.dbObjects.length > 0 && this.dbObjects[0] instanceof JacksonDBObject) {
                throw new UnsupportedOperationException("Saved object retrieval not supported when using stream serialization");
            }
            this.objects = this.jacksonDBCollection.convertFromDbObjects(this.dbObjects);
        }
        return this.objects;
    }

    public K getSavedId() {
        if (this.dbObjects.length == 0) {
            throw new MongoException("No objects to return");
        }
        if (this.dbObjects[0] instanceof JacksonDBObject) {
            throw new UnsupportedOperationException("Generated _id retrieval not supported when using stream serialization");
        }
        return this.jacksonDBCollection.convertFromDbId(this.dbObjects[0].get("_id"));
    }

    public List<K> getSavedIds() {
        if (this.dbObjects.length > 0 && this.dbObjects[0] instanceof JacksonDBObject) {
            throw new UnsupportedOperationException("Generated _id retrieval not supported when using stream serialization");
        }
        ArrayList<K> ids = new ArrayList<K>();
        for (DBObject dbObject : this.dbObjects) {
            ids.add(this.jacksonDBCollection.convertFromDbId(dbObject.get("_id")));
        }
        return ids;
    }

    public DBObject getDbObject() {
        if (this.dbObjects.length == 0) {
            throw new MongoException("No objects to return");
        }
        return this.dbObjects[0];
    }

    public DBObject[] getDbObjects() {
        return this.dbObjects;
    }

    public com.mongodb.WriteResult getWriteResult() {
        return this.writeResult;
    }

    @Deprecated
    public CommandResult getCachedLastError() {
        return this.writeResult.getCachedLastError();
    }

    @Deprecated
    public WriteConcern getLastConcern() {
        return this.writeResult.getLastConcern();
    }

    @Deprecated
    public synchronized CommandResult getLastError() {
        return this.writeResult.getLastError();
    }

    @Deprecated
    public synchronized CommandResult getLastError(WriteConcern concern) {
        return this.writeResult.getLastError(concern);
    }

    @Deprecated
    public String getError() {
        return this.writeResult.getError();
    }

    public int getN() {
        return this.writeResult.getN();
    }

    public Object getUpsertedId() {
        return this.writeResult.getUpsertedId();
    }

    public boolean isUpdateOfExisting() {
        return this.writeResult.isUpdateOfExisting();
    }

    @Deprecated
    public Object getField(String name) {
        return this.writeResult.getField(name);
    }

    @Deprecated
    public boolean isLazy() {
        return this.writeResult.isLazy();
    }

    public String toString() {
        return this.writeResult.toString();
    }
}

