/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.compiler.flat;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.beanio.BeanIOConfigurationException;
import org.beanio.internal.compiler.Preprocessor;
import org.beanio.internal.config.ComponentConfig;
import org.beanio.internal.config.FieldConfig;
import org.beanio.internal.config.PropertyConfig;
import org.beanio.internal.config.RecordConfig;
import org.beanio.internal.config.SegmentConfig;
import org.beanio.internal.config.SimplePropertyConfig;
import org.beanio.internal.config.StreamConfig;

public class FlatPreprocessor
extends Preprocessor {
    private int defaultPosition = 0;
    private Boolean positionRequired;
    private PropertyConfig unboundedComponent = null;
    private PropertyConfig unboundedComponentFollower = null;
    private List<PropertyConfig> endComponents = new ArrayList<PropertyConfig>();
    private LinkedList<SegmentConfig> segmentStack = new LinkedList();
    private List<FieldConfig> fieldComponents = new ArrayList<FieldConfig>();

    public FlatPreprocessor(StreamConfig stream) {
        super(stream);
    }

    protected void initializeRecord(RecordConfig record) {
        super.initializeRecord(record);
        this.defaultPosition = 0;
        this.positionRequired = null;
        this.unboundedComponent = null;
        this.unboundedComponentFollower = null;
        this.endComponents.clear();
        this.fieldComponents.clear();
    }

    protected void finalizeRecord(RecordConfig record) {
        boolean minSet;
        super.finalizeRecord(record);
        boolean bl = minSet = record.getMinLength() != null;
        if (this.stream.isStrict()) {
            if (record.getMinLength() == null) {
                record.setMinLength(record.getMinSize());
            }
            if (record.getMaxLength() == null) {
                record.setMaxLength(record.getMaxSize());
            }
        } else {
            if (record.getMinLength() == null) {
                record.setMinLength(0);
            }
            if (record.getMaxLength() == null) {
                record.setMaxLength(Integer.MAX_VALUE);
            }
        }
        if (record.getMaxLength() < record.getMinLength()) {
            if (minSet) {
                throw new BeanIOConfigurationException("Maximum record length cannot be less than minimum record length");
            }
            throw new BeanIOConfigurationException("Maximum record length must be at least " + record.getMinLength());
        }
        if (this.unboundedComponent != null && this.unboundedComponentFollower != null) {
            this.setEndPosition(this.unboundedComponent, this.unboundedComponentFollower.getPosition());
        }
    }

    private void setEndPosition(ComponentConfig config, int end) {
        switch (config.getComponentType()) {
            case 'S': {
                for (ComponentConfig child : ((SegmentConfig)config).getChildren()) {
                    this.setEndPosition(child, end);
                }
                break;
            }
            case 'F': {
                ((FieldConfig)config).setUntil(end);
            }
        }
    }

    protected void initializeSegment(SegmentConfig segment) throws BeanIOConfigurationException {
        if (segment.getComponentType() == 'S') {
            this.segmentStack.push(segment);
        }
        super.initializeSegment(segment);
        if (segment.getOccursRef() != null) {
            if (!segment.isCollection()) {
                throw new BeanIOConfigurationException("Collection required when 'occursRef' is set");
            }
            segment.setMinOccursRef(segment.getMinOccurs());
            segment.setMaxOccursRef(segment.getMaxOccurs());
            segment.setMinOccurs(1);
            segment.setMaxOccurs(1);
        }
    }

    protected void finalizeSegment(SegmentConfig segment) {
        int n;
        boolean isVariableSized;
        super.finalizeSegment(segment);
        PropertyConfig first = null;
        PropertyConfig last = null;
        int position = 0;
        int minSize = 0;
        int maxSize = -1;
        segment.setConstant(false);
        boolean isRecord = segment.getComponentType() == 'R';
        boolean bl = isVariableSized = segment.getMaxOccurs().equals(Integer.MAX_VALUE) || segment.isRepeating() && !segment.getMinOccurs().equals(segment.getMaxOccurs());
        if (isVariableSized && !isRecord && this.defaultPosition == Integer.MAX_VALUE) {
            throw new BeanIOConfigurationException("A segment of indeterminate size may not follow another component of indeterminate size");
        }
        for (PropertyConfig config : segment.getPropertyList()) {
            if (config.getComponentType() == 'C' || config.getComponentType() == 'S' && ((SegmentConfig)config).isConstant()) continue;
            if (!isRecord && segment.isRepeating() && config.getMinOccurs().equals(0)) {
                throw new BeanIOConfigurationException("A repeating segment may not contain components where minOccurs=0");
            }
            if (config.getMaxSize() == Integer.MAX_VALUE) {
                maxSize = Integer.MAX_VALUE;
            }
            n = config.getPosition();
            if (first == null || this.comparePosition(n, first.getPosition()) < 0) {
                first = config;
            }
            if (last != null && this.comparePosition(n, last.getPosition()) <= 0) continue;
            last = config;
        }
        if (last == null) {
            if (segment.getComponentType() == 'R') {
                maxSize = Integer.MAX_VALUE;
            } else {
                segment.setConstant(true);
                maxSize = 0;
            }
        } else if (maxSize < 0) {
            position = first.getPosition();
            if (last.getPosition() < 0 && first.getPosition() >= 0) {
                if (!isRecord && segment.isRepeating()) {
                    throw new BeanIOConfigurationException("A repeating segment may not contain components of indeterminate size");
                }
                maxSize = Integer.MAX_VALUE;
                isVariableSized = true;
            } else {
                maxSize = last.getMaxOccurs() == Integer.MAX_VALUE ? Integer.MAX_VALUE : Math.abs(last.getPosition() - first.getPosition()) + last.getMaxSize() * last.getMaxOccurs();
            }
        }
        if (last != null) {
            first = null;
            last = null;
            for (PropertyConfig config : segment.getPropertyList()) {
                if (config.getComponentType() == 'C') continue;
                minSize += config.getMinSize() * config.getMinOccurs();
                n = config.getPosition();
                if (first == null || this.comparePosition(n, first.getPosition()) < 0) {
                    first = config;
                }
                if (config.getMinOccurs() <= 0 || last != null && this.comparePosition(n, last.getPosition()) <= 0) continue;
                last = config;
            }
            if (last == null) {
                last = first;
            }
            if (first.getPosition() < 0 || last.getPosition() >= 0) {
                minSize = Math.abs(last.getPosition() - first.getPosition()) + last.getMaxSize() * last.getMinOccurs();
            }
        }
        segment.setPosition(position);
        segment.setMaxSize(maxSize);
        segment.setMinSize(minSize);
        if (!isRecord && Boolean.FALSE.equals(this.positionRequired)) {
            if (this.defaultPosition == Integer.MAX_VALUE) {
                if (!segment.isDescendant(this.unboundedComponent)) {
                    int offset = 0 - maxSize * (segment.getMaxOccurs() - 1);
                    for (PropertyConfig c : this.endComponents) {
                        c.setPosition(c.getPosition() + offset);
                    }
                    segment.setPosition(offset + segment.getPosition());
                    this.endComponents.add(segment);
                    if (this.unboundedComponentFollower == null) {
                        this.unboundedComponentFollower = segment;
                    }
                }
            } else if (segment.isRepeating() && !segment.getMinOccurs().equals(segment.getMaxOccurs()) || segment.getMaxOccurs().equals(Integer.MAX_VALUE) || segment.getMaxSize() == Integer.MAX_VALUE) {
                if (this.unboundedComponent == null) {
                    this.unboundedComponent = segment;
                }
                this.defaultPosition = Integer.MAX_VALUE;
            } else {
                this.defaultPosition = segment.getPosition() + segment.getMaxSize() * segment.getMaxOccurs();
            }
        }
        boolean defaultExistence = true;
        for (PropertyConfig child : segment.getPropertyList()) {
            if (child.getComponentType() == 'C' || child.getComponentType() == 'S' && ((SegmentConfig)child).getDefaultExistence()) continue;
            defaultExistence = false;
        }
        segment.setDefaultExistence(defaultExistence);
        if (segment.getDefaultExistence() && !segment.getMinOccurs().equals(segment.getMaxOccurs())) {
            throw new BeanIOConfigurationException("Repeating segments without any child field component must have minOccurs=maxOccurs");
        }
        this.handleOccursRef(segment);
        if (segment.getComponentType() == 'S') {
            this.segmentStack.pop();
        }
    }

    private int comparePosition(Integer p1, Integer p2) {
        if (p1 > 0 && p2 < 0) {
            return -1;
        }
        if (p1 < 0 && p2 >= 0) {
            return 1;
        }
        return p1.compareTo(p2);
    }

    protected void handleField(FieldConfig field) {
        int size;
        super.handleField(field);
        if (field.getOccursRef() != null) {
            if (!field.isCollection()) {
                throw new BeanIOConfigurationException("Collection required when 'occursRef' is set");
            }
            field.setMinOccursRef(field.getMinOccurs());
            field.setMaxOccursRef(field.getMaxOccurs());
            field.setMinOccurs(1);
            field.setMaxOccurs(1);
        }
        if (this.isFixedLength()) {
            if (field.getLiteral() != null) {
                if (field.getLength() == null) {
                    field.setLength(field.getLiteral().length());
                } else if (field.getLiteral().length() > field.getLength()) {
                    throw new BeanIOConfigurationException("literal size exceeds the field length");
                }
            } else if (field.getLength() == null) {
                throw new BeanIOConfigurationException("length required for fixed length fields");
            }
        } else if (new Integer(-1).equals(field.getLength())) {
            field.setLength(null);
        }
        if (field.getLength() != null && field.getPadding() == null) {
            field.setPadding(Character.valueOf(' '));
        }
        if ((size = this.getSize(field)) == -1) {
            field.setMinSize(0);
            field.setMaxSize(Integer.MAX_VALUE);
        } else {
            field.setMaxSize(size);
            field.setMinSize(size);
        }
        if (this.positionRequired == null) {
            this.positionRequired = field.getPosition() != null;
        } else if (this.positionRequired ^ field.getPosition() != null) {
            throw new BeanIOConfigurationException("position must be declared for all the fields in a record, or for none of them (in which case, all fields must be configured in the order they will appear in the stream)");
        }
        if (field.getPosition() != null) {
            field.setPosition(field.getPosition() + this.getSegmentOffset());
        }
        if (field.getPosition() == null) {
            this.calculateDefaultPosition(field);
        } else if (field.getUntil() != null) {
            if (!this.isVariableSized(field)) {
                throw new BeanIOConfigurationException("until should not be specified for fields of determinate occurences and length");
            }
            if (field.getUntil() >= 0) {
                throw new BeanIOConfigurationException("until must be less than 0 (i.e. a position relative to the end of the record)");
            }
        }
        this.handleOccursRef(field);
        this.fieldComponents.add(field);
    }

    private void handleOccursRef(PropertyConfig config) {
        if (config.getOccursRef() != null) {
            PropertyConfig occurs = null;
            for (int i = this.fieldComponents.size() - 1; i >= 0; --i) {
                FieldConfig fc = this.fieldComponents.get(i);
                if (!fc.getName().equals(config.getOccursRef())) continue;
                occurs = fc;
                break;
            }
            if (occurs == null) {
                throw new BeanIOConfigurationException("Referenced field '" + config.getOccursRef() + "' not found");
            }
            if (occurs.getCollection() != null) {
                throw new BeanIOConfigurationException("Referenced field '" + config.getOccursRef() + "' may not repeat");
            }
            if (occurs.getPosition() >= config.getPosition()) {
                throw new BeanIOConfigurationException("Referenced field '" + config.getOccursRef() + "' must precede this field");
            }
            if (occurs.getType() == null && ((SimplePropertyConfig)occurs).getTypeHandler() == null && ((SimplePropertyConfig)occurs).getTypeHandlerInstance() == null) {
                occurs.setType(Integer.class.getName());
            }
            if (((FieldConfig)occurs).isRef() && !occurs.isBound()) {
                throw new BeanIOConfigurationException("Unbound field '" + occurs.getName() + "' cannot be referenced more than once");
            }
            ((FieldConfig)occurs).setRef(true);
        }
    }

    private int getSegmentOffset() {
        int offset = 0;
        for (SegmentConfig s : this.segmentStack) {
            if (s.getPosition() == null) continue;
            offset += s.getPosition().intValue();
        }
        return offset;
    }

    private boolean isVariableSized(FieldConfig config) {
        return config.getMaxOccurs().equals(Integer.MAX_VALUE) || this.isFixedLength() && config.getMaxSize() == Integer.MAX_VALUE || config.isRepeating() && !config.getMinOccurs().equals(config.getMaxOccurs());
    }

    private void calculateDefaultPosition(FieldConfig config) {
        boolean isVariableSized = this.isVariableSized(config);
        if (this.defaultPosition == Integer.MAX_VALUE) {
            if (isVariableSized) {
                String error = "Cannot determine field position, field is preceded by another component with indeterminate occurrences";
                if (this.isFixedLength()) {
                    error = error + "or unbounded length";
                }
                throw new BeanIOConfigurationException(error);
            }
            int offset = 0 - config.getMaxSize() * config.getMaxOccurs();
            for (PropertyConfig c : this.endComponents) {
                c.setPosition(c.getPosition() + offset);
            }
            config.setPosition(offset);
            this.endComponents.add(config);
            if (this.unboundedComponentFollower == null) {
                this.unboundedComponentFollower = config;
            }
        } else {
            config.setPosition(this.defaultPosition);
            if (isVariableSized) {
                this.defaultPosition = Integer.MAX_VALUE;
                this.unboundedComponent = config;
            } else {
                this.defaultPosition = config.getPosition() + config.getMaxSize() * config.getMaxOccurs();
            }
        }
    }

    protected int getSize(FieldConfig field) {
        return this.isFixedLength() ? field.getLength() : 1;
    }

    protected boolean isFixedLength() {
        return false;
    }
}

