/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.SendAcknowledgementHandler;
import org.hornetq.api.core.client.ServerLocator;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.ItemReaderWriterBase;

@Deprecated
public abstract class HornetQItemReaderWriterBase
extends ItemReaderWriterBase {
    @Inject
    protected Instance<ServerLocator> serverLocatorInstance;
    @Inject
    protected Instance<ClientSessionFactory> sessionFactoryInstance;
    @Inject
    @BatchProperty
    protected Map connectorFactoryParams;
    @Inject
    @BatchProperty
    protected Map serverLocatorParams;
    @Inject
    @BatchProperty
    protected Map queueParams;
    @Inject
    @BatchProperty
    protected Class sendAcknowledgementHandler;
    protected SimpleString queueAddress;
    protected SimpleString queueName;
    protected ServerLocator serverLocator;
    protected ClientSessionFactory sessionFactory;
    protected ClientSession session;
    private boolean toCloseServerLocator;
    private boolean toCloseSessionFactory;

    public void open(Serializable checkpoint) throws Exception {
        if (this.queueParams == null) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, null, "queueParams");
        }
        this.queueAddress = SimpleString.toSimpleString((String)((String)this.queueParams.get("address")));
        this.queueName = SimpleString.toSimpleString((String)((String)this.queueParams.get("name")));
        if (this.queueName == null) {
            this.queueName = this.queueAddress;
        }
        if (this.connectorFactoryParams != null) {
            String connectorFactoryName = (String)this.connectorFactoryParams.get("name");
            if (connectorFactoryName == null) {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.connectorFactoryParams.toString(), "connectorFactoryParams");
            }
            this.connectorFactoryParams.remove("name");
            boolean withHA = false;
            if (this.serverLocatorParams != null && this.serverLocatorParams.containsKey("HA")) {
                withHA = Boolean.parseBoolean((String)this.serverLocatorParams.get("HA"));
                if (this.serverLocatorParams.size() == 1) {
                    this.serverLocatorParams = null;
                } else {
                    this.serverLocatorParams.remove("HA");
                }
            }
            this.serverLocator = withHA ? (this.connectorFactoryParams == null ? HornetQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(connectorFactoryName)}) : HornetQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(connectorFactoryName, this.connectorFactoryParams)})) : (this.connectorFactoryParams == null ? HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(connectorFactoryName)}) : HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(connectorFactoryName, this.connectorFactoryParams)}));
            this.toCloseServerLocator = true;
        } else if (this.sessionFactoryInstance.isUnsatisfied()) {
            this.serverLocator = (ServerLocator)this.serverLocatorInstance.get();
        } else {
            this.sessionFactory = (ClientSessionFactory)this.sessionFactoryInstance.get();
        }
        if (this.serverLocatorParams != null && this.serverLocator != null) {
            this.configureServerLocator();
            this.sessionFactory = this.serverLocator.createSessionFactory();
            this.toCloseSessionFactory = true;
        }
        this.session = this.sessionFactory.createSession();
        if (this.sendAcknowledgementHandler != null) {
            this.session.setSendAcknowledgementHandler((SendAcknowledgementHandler)this.sendAcknowledgementHandler.newInstance());
        }
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }

    protected void configureServerLocator() throws Exception {
        for (Object o : this.serverLocatorParams.keySet()) {
            String key = (String)o;
            String val = (String)this.serverLocatorParams.get(key);
            String setterName = "set" + Character.toUpperCase(key.charAt(0)) + key.substring(1);
            Method method = ServerLocator.class.getMethod(setterName, new Class[0]);
            Class<?> param1 = method.getParameterTypes()[0];
            Object[] args = new Object[1];
            if (param1 == Integer.TYPE) {
                args[0] = Integer.valueOf(val);
            } else if (param1 == String.class) {
                args[0] = val;
            } else if (param1 == Boolean.TYPE) {
                args[0] = Boolean.valueOf(val);
            } else if (param1 == Long.TYPE) {
                args[0] = Long.valueOf(val);
            } else if (param1 == Double.TYPE) {
                args[0] = Double.valueOf(val);
            }
            method.invoke((Object)this.serverLocator, args);
        }
    }

    protected void close() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (HornetQException e) {
                SupportLogger.LOGGER.tracef(e, "Failed to close HornetQ client core session %s%n", this.session);
            }
            this.session = null;
        }
        if (this.sessionFactory != null && this.toCloseSessionFactory) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
        if (this.serverLocator != null && this.toCloseServerLocator) {
            this.serverLocator.close();
            this.serverLocator = null;
        }
    }
}

