/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.JdbcItemReaderWriterBase;

@Named
@Dependent
public class JdbcItemWriter
extends JdbcItemReaderWriterBase
implements ItemWriter {
    @Inject
    @BatchProperty
    protected String[] parameterNames;
    @Inject
    @BatchProperty
    protected String[] parameterTypes;

    public void writeItems(List<Object> items) throws Exception {
        Connection connection = null;
        try {
            connection = this.getConnection();
            if (this.dataSource == null) {
                connection.setAutoCommit(false);
            }
            this.preparedStatement = connection.prepareStatement(this.sql);
            for (Object item : items) {
                this.mapParameters(item);
                this.preparedStatement.addBatch();
            }
            this.preparedStatement.executeBatch();
            if (this.dataSource == null) {
                connection.commit();
            }
        }
        catch (Exception e) {
            if (this.dataSource == null && connection != null) {
                connection.rollback();
            }
            throw e;
        }
        finally {
            JdbcItemReaderWriterBase.close(connection, this.preparedStatement);
        }
    }

    public void open(Serializable checkpoint) throws Exception {
        this.init();
        if (this.parameterNames == null && this.beanType != List.class) {
            this.parameterNames = JdbcItemWriter.determineParameterNames(this.sql);
        }
    }

    static String[] determineParameterNames(String sql) {
        String sqlLowerCase = sql.toLowerCase();
        int insertPos = sqlLowerCase.indexOf("insert");
        int leftParenthesisPos = sqlLowerCase.indexOf(40, insertPos + 7);
        int rightParenthesisPos = sqlLowerCase.indexOf(41, leftParenthesisPos + 1);
        String[] columns = sql.substring(leftParenthesisPos + 1, rightParenthesisPos).split(",");
        int valuesPos = sqlLowerCase.indexOf("values", rightParenthesisPos + 1);
        leftParenthesisPos = sqlLowerCase.indexOf(40, valuesPos + 1);
        rightParenthesisPos = sqlLowerCase.lastIndexOf(41);
        if (rightParenthesisPos <= leftParenthesisPos) {
            throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, sql, "sql");
        }
        String[] values = sql.substring(leftParenthesisPos + 1, rightParenthesisPos).split(",");
        if (values.length != columns.length) {
            throw SupportMessages.MESSAGES.failedToDetermineParameterNames();
        }
        ArrayList<String> parameterNamesList = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            String v = values[i].trim();
            if (!v.equals("?")) continue;
            parameterNamesList.add(columns[i].trim());
        }
        return parameterNamesList.toArray(new String[parameterNamesList.size()]);
    }

    public void close() throws Exception {
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }

    private void mapParameters(Object item) throws Exception {
        if (item instanceof List) {
            List itemAsList = (List)item;
            for (int i = 0; i < itemAsList.size(); ++i) {
                this.setParameter(i, itemAsList.get(i));
            }
        } else {
            Map itemAsMap = item instanceof Map ? (Map)item : (Map)this.objectMapper.convertValue(item, Map.class);
            for (int i = 0; i < this.parameterNames.length; ++i) {
                this.setParameter(i, itemAsMap.get(this.parameterNames[i]));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setParameter(int i, Object val) throws Exception {
        int pos = i + 1;
        if (this.parameterTypes == null) {
            this.preparedStatement.setObject(i + 1, val);
            return;
        }
        String type = this.parameterTypes[i];
        if (type.equals("String")) {
            this.preparedStatement.setString(pos, val == null ? null : val.toString());
            return;
        } else if (type.equals("Date")) {
            if (val == null) {
                this.preparedStatement.setDate(pos, null);
                return;
            } else {
                Date sqlDate = val instanceof Date ? (Date)val : (val instanceof java.util.Date ? new Date(((java.util.Date)val).getTime()) : (val instanceof Long ? new Date((Long)val) : new Date(Long.parseLong(val.toString()))));
                this.preparedStatement.setDate(pos, sqlDate);
            }
            return;
        } else if (type.equals("Timestamp")) {
            if (val == null) {
                this.preparedStatement.setTimestamp(pos, null);
                return;
            } else {
                Timestamp sqlTimestamp = val instanceof Timestamp ? (Timestamp)val : (val instanceof java.util.Date ? new Timestamp(((java.util.Date)val).getTime()) : (val instanceof Long ? new Timestamp((Long)val) : new Timestamp(Long.parseLong(val.toString()))));
                this.preparedStatement.setTimestamp(pos, sqlTimestamp);
            }
            return;
        } else if (type.equals("Time")) {
            if (val == null) {
                this.preparedStatement.setTime(pos, null);
                return;
            } else {
                Time sqlTime = val instanceof Time ? (Time)val : (val instanceof java.util.Date ? new Time(((java.util.Date)val).getTime()) : (val instanceof Long ? new Time((Long)val) : new Time(Long.parseLong(val.toString()))));
                this.preparedStatement.setTime(pos, sqlTime);
            }
            return;
        } else if (type.equals("Object") || type.equals("null")) {
            this.preparedStatement.setObject(pos, val);
            return;
        } else if (type.equals("NString")) {
            this.preparedStatement.setNString(pos, val == null ? null : val.toString());
            return;
        } else if (type.equals("Boolean")) {
            this.preparedStatement.setBoolean(pos, val instanceof Boolean ? (Boolean)val : val != null && Boolean.parseBoolean(val.toString()));
            return;
        } else if (type.equals("Int")) {
            this.preparedStatement.setInt(pos, val instanceof Integer ? (Integer)val : (val == null ? 0 : Integer.parseInt(val.toString())));
            return;
        } else if (type.equals("Long")) {
            this.preparedStatement.setLong(pos, val instanceof Long ? (Long)val : (val == null ? 0L : Long.parseLong(val.toString())));
            return;
        } else if (type.equals("Double")) {
            this.preparedStatement.setDouble(pos, val instanceof Double ? (Double)val : (val == null ? 0.0 : Double.parseDouble(val.toString())));
            return;
        } else if (type.equals("Float")) {
            this.preparedStatement.setFloat(pos, val instanceof Float ? ((Float)val).floatValue() : (val == null ? 0.0f : Float.parseFloat(val.toString())));
            return;
        } else if (type.equals("Short")) {
            this.preparedStatement.setShort(pos, val instanceof Short ? (Short)val : (val == null ? (short)0 : Short.parseShort(val.toString())));
            return;
        } else if (type.equals("Byte")) {
            this.preparedStatement.setByte(pos, val instanceof Byte ? (Byte)val : (val == null ? (byte)0 : Byte.parseByte(val.toString())));
            return;
        } else if (type.equals("Blob")) {
            if (val == null) {
                this.preparedStatement.setBlob(pos, (Blob)null);
                return;
            } else if (val instanceof Blob) {
                this.preparedStatement.setBlob(pos, (Blob)val);
                return;
            } else {
                if (!(val instanceof InputStream)) throw SupportMessages.MESSAGES.unexpectedDataType("Blob | InputStream", val.getClass().getName(), val);
                this.preparedStatement.setBlob(pos, (InputStream)val);
            }
            return;
        } else if (type.equals("Clob")) {
            if (val == null) {
                this.preparedStatement.setClob(pos, (Clob)null);
                return;
            } else if (val instanceof Clob) {
                this.preparedStatement.setClob(pos, (Clob)val);
                return;
            } else {
                if (!(val instanceof Reader)) throw SupportMessages.MESSAGES.unexpectedDataType("Clob | Reader", val.getClass().getName(), val);
                this.preparedStatement.setClob(pos, (Reader)val);
            }
            return;
        } else if (type.equals("NClob")) {
            if (val == null) {
                this.preparedStatement.setNClob(pos, (NClob)null);
                return;
            } else if (val instanceof NClob) {
                this.preparedStatement.setNClob(pos, (NClob)val);
                return;
            } else {
                if (!(val instanceof Reader)) throw SupportMessages.MESSAGES.unexpectedDataType("NClob | Reader", val.getClass().getName(), val);
                this.preparedStatement.setNClob(pos, (Reader)val);
            }
            return;
        } else if (type.equals("BigDecimal")) {
            this.preparedStatement.setBigDecimal(pos, (BigDecimal)(val instanceof BigDecimal ? (BigDecimal)val : (val == null ? null : new BigDecimal(val.toString()))));
            return;
        } else if (type.equals("URL")) {
            this.preparedStatement.setURL(pos, (URL)(val instanceof URL ? (URL)val : (val == null ? null : new URI(val.toString()).toURL())));
            return;
        } else if (type.equals("Bytes")) {
            this.preparedStatement.setBytes(pos, val instanceof byte[] ? (byte[])val : (byte[])(val == null ? null : val.toString().getBytes()));
            return;
        } else if (type.equals("BinaryStream")) {
            if (val == null) {
                this.preparedStatement.setBinaryStream(pos, null);
                return;
            } else {
                if (!(val instanceof InputStream)) throw SupportMessages.MESSAGES.unexpectedDataType("InputStream", val.getClass().getName(), val);
                this.preparedStatement.setBinaryStream(pos, (InputStream)val);
            }
            return;
        } else if (type.equals("CharacterStream")) {
            if (val == null) {
                this.preparedStatement.setCharacterStream(pos, null);
                return;
            } else {
                if (!(val instanceof Reader)) throw SupportMessages.MESSAGES.unexpectedDataType("Reader", val.getClass().getName(), val);
                this.preparedStatement.setCharacterStream(pos, (Reader)val);
            }
            return;
        } else if (type.equals("NCharacterStream")) {
            if (val == null) {
                this.preparedStatement.setNCharacterStream(pos, null);
                return;
            } else {
                if (!(val instanceof Reader)) throw SupportMessages.MESSAGES.unexpectedDataType("Reader", val.getClass().getName(), val);
                this.preparedStatement.setNCharacterStream(pos, (Reader)val);
            }
            return;
        } else if (type.equals("AsciiStream")) {
            if (val == null) {
                this.preparedStatement.setAsciiStream(pos, null);
                return;
            } else {
                if (!(val instanceof InputStream)) throw SupportMessages.MESSAGES.unexpectedDataType("InputStream", val.getClass().getName(), val);
                this.preparedStatement.setAsciiStream(pos, (InputStream)val);
            }
            return;
        } else if (type.equals("Ref")) {
            if (val == null) {
                this.preparedStatement.setRef(pos, null);
                return;
            } else {
                if (!(val instanceof Ref)) throw SupportMessages.MESSAGES.unexpectedDataType("java.sql.Ref", val.getClass().getName(), val);
                this.preparedStatement.setRef(pos, (Ref)val);
            }
            return;
        } else if (type.equals("RowId")) {
            if (val == null) {
                this.preparedStatement.setRowId(pos, null);
                return;
            } else {
                if (!(val instanceof RowId)) throw SupportMessages.MESSAGES.unexpectedDataType("java.sql.RowId", val.getClass().getName(), val);
                this.preparedStatement.setRowId(pos, (RowId)val);
            }
            return;
        } else if (type.equals("SQLXML")) {
            if (val == null) {
                this.preparedStatement.setSQLXML(pos, null);
                return;
            } else {
                if (!(val instanceof SQLXML)) throw SupportMessages.MESSAGES.unexpectedDataType("java.sql.SQLXML", val.getClass().getName(), val);
                this.preparedStatement.setSQLXML(pos, (SQLXML)val);
            }
            return;
        } else {
            if (!type.equals("Array")) return;
            if (val == null) {
                this.preparedStatement.setArray(pos, null);
                return;
            } else {
                if (!(val instanceof Array)) throw SupportMessages.MESSAGES.unexpectedDataType("java.sql.Array", val.getClass().getName(), val);
                this.preparedStatement.setArray(pos, (Array)val);
            }
        }
    }
}

