/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mongojack.DBProjection;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.internal.query.QueryCondition;

public class Aggregation<T> {
    private Class<T> resultType;
    private DBObject initialOp;
    private DBObject[] additionalOps;

    public Aggregation(Class<T> resultType, DBObject initialOp, DBObject ... additionalOps) {
        this.resultType = resultType;
        this.initialOp = initialOp;
        this.additionalOps = additionalOps;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    public DBObject getInitialOp() {
        return this.initialOp;
    }

    public DBObject[] getAdditionalOps() {
        return this.additionalOps;
    }

    public List<DBObject> getAllOps() {
        ArrayList<DBObject> allOps = new ArrayList<DBObject>();
        allOps.add(this.initialOp);
        allOps.addAll(Arrays.asList(this.additionalOps));
        return allOps;
    }

    public static Pipeline<Group.Accumulator> group(Expression<?> key, Map<String, Group.Accumulator> calculatedFields) {
        return new Pipeline<Group.Accumulator>(Group.by(key).set((Map)calculatedFields));
    }

    public static Pipeline<Group.Accumulator> group(Expression<?> key) {
        return new Pipeline<Group.Accumulator>(Group.by(key));
    }

    public static Pipeline<Group.Accumulator> group(String key) {
        return new Pipeline<Group.Accumulator>(Group.by(Expression.path(key)));
    }

    public static Pipeline<Void> limit(int n) {
        return new Pipeline<Void>(new Limit(n));
    }

    public static Pipeline<Void> match(DBQuery.Query query) {
        return new Pipeline<Void>(new Match(query));
    }

    public static Pipeline<Expression<?>> project(DBProjection.ProjectionBuilder projection) {
        return new Pipeline(new Project(projection));
    }

    public static Pipeline<Expression<?>> project(String field) {
        return new Pipeline(Project.fields(field));
    }

    public static Pipeline<Expression<?>> project(String field, Expression<?> value) {
        return new Pipeline(Project.field(field, value));
    }

    public static Pipeline<Void> skip(int n) {
        return new Pipeline<Void>(new Skip(n));
    }

    public static Pipeline<Void> sort(DBSort.SortBuilder builder) {
        return new Pipeline<Void>(new Sort(builder));
    }

    public static Pipeline<Void> unwind(String path) {
        return new Pipeline<Void>(new Unwind(new String[]{path}));
    }

    public static class OperatorExpression<T>
    extends Expression<T> {
        private final String operator;
        private final Expression<?>[] operands;

        private OperatorExpression(String operator, Expression<?> ... operands) {
            this.operator = operator;
            this.operands = operands;
        }

        public String operator() {
            return this.operator;
        }

        public Iterable<Expression<?>> operands() {
            return Arrays.asList(this.operands);
        }
    }

    public static class Literal<T>
    extends Expression<T> {
        private final T value;

        private Literal(T value) {
            this.value = value;
        }

        public T value() {
            return this.value;
        }
    }

    public static class ExpressionObject
    extends Expression<Object> {
        private final Map<String, Expression<?>> properties;

        private ExpressionObject(Map<String, Expression<?>> properties) {
            this.properties = properties;
        }

        public Set<Map.Entry<String, Expression<?>>> properties() {
            return this.properties.entrySet();
        }
    }

    public static final class FieldPath<T>
    extends Expression<T> {
        private final String[] path;

        private FieldPath(String ... path) {
            this.path = path;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("$").append(this.path[0]);
            for (int i = 1; i < this.path.length; ++i) {
                sb.append('.').append(this.path[i]);
            }
            return sb.toString();
        }
    }

    public static abstract class Expression<T> {
        public static Expression<Object> path(String ... path) {
            return new FieldPath<Object>(path);
        }

        public static Expression<Boolean> bool(String ... path) {
            return new FieldPath<Boolean>(path);
        }

        public static Expression<Date> date(String ... path) {
            return new FieldPath<Date>(path);
        }

        public static Expression<Integer> integer(String ... path) {
            return new FieldPath<Integer>(path);
        }

        public static Expression<Number> number(String ... path) {
            return new FieldPath<Number>(path);
        }

        public static Expression<String> string(String ... path) {
            return new FieldPath<String>(path);
        }

        public static <T> Expression<T> literal(T value) {
            return new Literal(value);
        }

        public static Expression<Object> object(Map<String, Expression<?>> properties) {
            return new ExpressionObject(properties);
        }

        public static Expression<Boolean> and(Expression<?> ... operands) {
            return new OperatorExpression<Boolean>("$and", (Expression[])operands);
        }

        public static Expression<Boolean> not(Expression<?> operand) {
            return new OperatorExpression<Boolean>("$not", new Expression[]{operand});
        }

        public static Expression<Boolean> or(Expression<?> ... operands) {
            return new OperatorExpression<Boolean>("$or", (Expression[])operands);
        }

        public static Expression<Boolean> allElementsTrue(Expression<List<?>> set) {
            return new OperatorExpression<Boolean>("$allElementsTrue", new Expression[]{set});
        }

        public static Expression<Boolean> anyElementTrue(Expression<List<?>> set) {
            return new OperatorExpression<Boolean>("$anyElementTrue", new Expression[]{set});
        }

        public static Expression<List<?>> setDifference(Expression<List<?>> set1, Expression<List<?>> set2) {
            return new OperatorExpression("$setDifference", new Expression[]{set1, set2});
        }

        public static Expression<Boolean> setEquals(Expression<List<?>> ... sets) {
            return new OperatorExpression<Boolean>("$setEquals", (Expression[])sets);
        }

        public static Expression<List<?>> setIntersection(Expression<List<?>> ... sets) {
            return new OperatorExpression("$setIntersection", (Expression[])sets);
        }

        public static Expression<Boolean> setIsSubset(Expression<List<?>> set1, Expression<List<?>> set2) {
            return new OperatorExpression<Boolean>("$setIsSubset", new Expression[]{set1, set2});
        }

        public static Expression<List<?>> setUnion(Expression<List<?>> ... sets) {
            return new OperatorExpression("$setUnion", (Expression[])sets);
        }

        public static Expression<Integer> compareTo(Expression<?> value1, Expression<?> value2) {
            return new OperatorExpression<Integer>("$cmp", new Expression[]{value1, value2});
        }

        public static Expression<Boolean> equals(Expression<?> value1, Expression<?> value2) {
            return new OperatorExpression<Boolean>("$eq", new Expression[]{value1, value2});
        }

        public static Expression<Boolean> greaterThan(Expression<?> value1, Expression<?> value2) {
            return new OperatorExpression<Boolean>("$gt", new Expression[]{value1, value2});
        }

        public static Expression<Boolean> greaterThanOrEquals(Expression<?> value1, Expression<?> value2) {
            return new OperatorExpression<Boolean>("$gte", new Expression[]{value1, value2});
        }

        public static Expression<Boolean> lessThan(Expression<?> value1, Expression<?> value2) {
            return new OperatorExpression<Boolean>("$lt", new Expression[]{value1, value2});
        }

        public static Expression<Boolean> lessThanOrEquals(Expression<?> value1, Expression<?> value2) {
            return new OperatorExpression<Boolean>("$lte", new Expression[]{value1, value2});
        }

        public static Expression<Boolean> notEquals(Expression<?> value1, Expression<?> value2) {
            return new OperatorExpression<Boolean>("$ne", new Expression[]{value1, value2});
        }

        public static Expression<Number> add(Expression<Number> ... numbers) {
            return new OperatorExpression<Number>("$add", (Expression[])numbers);
        }

        public static Expression<Number> divide(Expression<Number> number1, Expression<Number> number2) {
            return new OperatorExpression<Number>("$divide", new Expression[]{number1, number2});
        }

        public static Expression<Number> mod(Expression<Number> number1, Expression<Number> number2) {
            return new OperatorExpression<Number>("$mod", new Expression[]{number1, number2});
        }

        public static Expression<Number> multiply(Expression<Number> ... numbers) {
            return new OperatorExpression<Number>("$multiply", (Expression[])numbers);
        }

        public static Expression<Number> subtract(Expression<Number> number1, Expression<Number> number2) {
            return new OperatorExpression<Number>("$subtract", new Expression[]{number1, number2});
        }

        public static Expression<String> concat(Expression<String> ... strings) {
            return new OperatorExpression<String>("$concat", (Expression[])strings);
        }

        public static Expression<Integer> compareToIgnoreCase(Expression<String> string1, Expression<String> string2) {
            return new OperatorExpression<Integer>("$strcasecmp", new Expression[]{string1, string2});
        }

        public static Expression<String> substring(Expression<String> string, Expression<Integer> start, Expression<Integer> length) {
            return new OperatorExpression<String>("$substr", new Expression[]{string, start, length});
        }

        public static Expression<String> toLowerCase(Expression<String> string) {
            return new OperatorExpression<String>("$toLower", new Expression[]{string});
        }

        public static Expression<String> toUpperCase(Expression<String> string) {
            return new OperatorExpression<String>("$toUpper", new Expression[]{string});
        }

        public static Expression<Integer> size(Expression<List<?>> array) {
            return new OperatorExpression<Integer>("$size", new Expression[]{array});
        }

        public static Expression<Integer> dayOfMonth(Expression<Date> date) {
            return new OperatorExpression<Integer>("$dayOfMonth", new Expression[]{date});
        }

        public static Expression<Integer> dayOfWeek(Expression<Date> date) {
            return new OperatorExpression<Integer>("$dayOfWeek", new Expression[]{date});
        }

        public static Expression<Integer> hour(Expression<Date> date) {
            return new OperatorExpression<Integer>("$hour", new Expression[]{date});
        }

        public static Expression<Integer> millisecond(Expression<Date> date) {
            return new OperatorExpression<Integer>("$millisecond", new Expression[]{date});
        }

        public static Expression<Integer> minute(Expression<Date> date) {
            return new OperatorExpression<Integer>("$minute", new Expression[]{date});
        }

        public static Expression<Integer> month(Expression<Date> date) {
            return new OperatorExpression<Integer>("$month", new Expression[]{date});
        }

        public static Expression<Integer> second(Expression<Date> date) {
            return new OperatorExpression<Integer>("$second", new Expression[]{date});
        }

        public static Expression<Integer> week(Expression<Date> date) {
            return new OperatorExpression<Integer>("$week", new Expression[]{date});
        }

        public static Expression<Integer> year(Expression<Date> date) {
            return new OperatorExpression<Integer>("$year", new Expression[]{date});
        }

        public static <T> Expression<T> cond(Expression<Boolean> condition, Expression<? extends T> consequent, Expression<? extends T> alternative) {
            return new OperatorExpression("$cond", new Expression[]{condition, consequent, alternative});
        }

        public static <T> Expression<T> ifNull(Expression<? extends T> expression, Expression<? extends T> replacement) {
            return new OperatorExpression("$ifNull", new Expression[]{expression, replacement});
        }
    }

    public static class Pipeline<S> {
        private Stage<S> latestStage;
        private final List<Stage<?>> precedingStages;

        private Pipeline(Stage<S> latestStage, List<Stage<?>> precedingStages) {
            this.latestStage = latestStage;
            this.precedingStages = precedingStages;
        }

        public Pipeline(Stage<S> stage) {
            this(stage, new ArrayList());
        }

        public <X> Pipeline<X> then(Stage<X> stage) {
            Pipeline result = this;
            result.precedingStages.add(this.latestStage);
            result.latestStage = stage;
            return result;
        }

        public Pipeline<Group.Accumulator> group(Expression<?> key, Map<String, Group.Accumulator> calculatedFields) {
            return this.then(Group.by(key).set((Map)calculatedFields));
        }

        public Pipeline<Group.Accumulator> group(Expression<?> key) {
            return this.then(Group.by(key));
        }

        public Pipeline<Group.Accumulator> group(String ... key) {
            return this.then(Group.by(Expression.path(key)));
        }

        public Pipeline<S> set(String field, S value) {
            this.latestStage.set(field, value);
            return this;
        }

        public Pipeline<Void> limit(int n) {
            return this.then(new Limit(n));
        }

        public Pipeline<Void> match(DBQuery.Query query) {
            return this.then(new Match(query));
        }

        public Pipeline<Expression<?>> project(DBProjection.ProjectionBuilder projection) {
            return this.then(new Project(projection));
        }

        public Pipeline<Expression<?>> project(String field) {
            return this.then(Project.field(field, new String[0]));
        }

        public Pipeline<Expression<?>> project(String field, Expression<?> value) {
            return this.then(new Project(field, value));
        }

        public Pipeline<Expression<?>> project(Collection<String> fields) {
            return this.then(Project.fields(fields));
        }

        public Pipeline<Expression<?>> projectFields(String ... fields) {
            return this.then(Project.fields(fields));
        }

        public Pipeline<Expression<?>> projectField(String field, String ... value) {
            return this.then(Project.field(field, value));
        }

        public Pipeline<Void> skip(int n) {
            return this.then(new Skip(n));
        }

        public Pipeline<Void> sort(DBSort.SortBuilder builder) {
            return this.then(new Sort(builder));
        }

        public Pipeline<Void> unwind(String ... path) {
            return this.then(new Unwind(path));
        }

        public Iterable<Stage<?>> stages() {
            ArrayList stages = new ArrayList(this.precedingStages.size() + 1);
            stages.addAll(this.precedingStages);
            stages.add(this.latestStage);
            return stages;
        }

        public static interface Stage<S> {
            public Stage<S> set(String var1, S var2);

            public Stage<S> set(Map<String, S> var1);
        }
    }

    public static class Unwind
    extends SimpleStage
    implements Pipeline.Stage<Void> {
        private final String[] path;

        private Unwind(String ... path) {
            this.path = path;
        }

        public FieldPath<Object> path() {
            return new FieldPath<Object>(this.path);
        }
    }

    public static class Sort
    extends SimpleStage
    implements Pipeline.Stage<Void> {
        private final DBSort.SortBuilder builder;

        private Sort(DBSort.SortBuilder builder) {
            this.builder = builder;
        }

        public Sort asc(String field) {
            this.builder.asc(field);
            return this;
        }

        public Sort desc(String field) {
            this.builder.desc(field);
            return this;
        }

        public DBSort.SortBuilder builder() {
            return this.builder;
        }
    }

    public static class Skip
    extends SimpleStage
    implements Pipeline.Stage<Void> {
        private final int n;

        private Skip(int n) {
            this.n = n;
        }

        public int skip() {
            return this.n;
        }
    }

    public static class Project
    implements Pipeline.Stage<Expression<?>> {
        private final DBProjection.ProjectionBuilder builder;

        private Project(DBProjection.ProjectionBuilder builder) {
            this.builder = builder;
        }

        private Project(String field, Expression<?> value) {
            this.builder = DBProjection.include(new String[0]);
            this.set(field, value);
        }

        public static Project fields(String ... fields) {
            return new Project(DBProjection.include(fields));
        }

        public static Project fields(Collection<String> fields) {
            return new Project(DBProjection.include(fields.toArray(new String[fields.size()])));
        }

        public static Project field(String field, Expression<?> value) {
            return new Project(field, value);
        }

        public static Project field(String field, String ... path) {
            return new Project(field, Expression.path(path));
        }

        public Project excludeId() {
            this.builder.exclude("_id");
            return this;
        }

        public Project set(String field, Expression<?> value) {
            this.builder.append(field, value);
            return this;
        }

        public Project set(Map<String, Expression<?>> fields) {
            this.builder.putAll(fields);
            return this;
        }

        public DBProjection.ProjectionBuilder builder() {
            return this.builder;
        }
    }

    public static class Match
    extends DBQuery.AbstractBuilder<Match>
    implements Pipeline.Stage<Void> {
        private final DBQuery.Query query;

        private Match() {
            this(DBQuery.empty());
        }

        private Match(DBQuery.Query query) {
            this.query = query;
        }

        @Override
        protected Match put(String op, QueryCondition value) {
            this.query.put(op, value);
            return this;
        }

        @Override
        protected Match put(String field, String op, QueryCondition value) {
            this.query.put(field, op, value);
            return this;
        }

        @Override
        protected Match putGroup(String op, DBQuery.Query ... expressions) {
            this.query.putGroup(op, expressions);
            return this;
        }

        @Override
        public Pipeline.Stage<Void> set(String field, Void value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Pipeline.Stage<Void> set(Map<String, Void> fields) {
            throw new UnsupportedOperationException();
        }

        public DBQuery.Query query() {
            return this.query;
        }
    }

    public static class Limit
    extends SimpleStage
    implements Pipeline.Stage<Void> {
        private final int n;

        private Limit(int n) {
            this.n = n;
        }

        public int limit() {
            return this.n;
        }
    }

    public static class Group
    implements Pipeline.Stage<Accumulator> {
        private static final Accumulator COUNT = Group.sum(Expression.literal(1));
        private final Expression<?> key;
        private final Map<String, Accumulator> calculatedFields = new LinkedHashMap<String, Accumulator>();

        private Group(Expression<?> key) {
            this.key = key;
        }

        public static Group by(Expression<?> key) {
            return new Group(key);
        }

        public static Group by(String key) {
            return new Group(Expression.path(key));
        }

        public static Accumulator distinct(Expression<?> expression) {
            return new Accumulator(Op.$addToSet, expression);
        }

        public static Accumulator distinct(String ... path) {
            return new Accumulator(Op.$addToSet, Expression.path(path));
        }

        public static Accumulator average(Expression<?> expression) {
            return new Accumulator(Op.$avg, expression);
        }

        public static Accumulator average(String ... path) {
            return new Accumulator(Op.$avg, Expression.path(path));
        }

        public static Accumulator first(Expression<?> expression) {
            return new Accumulator(Op.$first, expression);
        }

        public static Accumulator first(String ... path) {
            return new Accumulator(Op.$first, Expression.path(path));
        }

        public static Accumulator last(Expression<?> expression) {
            return new Accumulator(Op.$last, expression);
        }

        public static Accumulator last(String ... path) {
            return new Accumulator(Op.$last, Expression.path(path));
        }

        public static Accumulator max(Expression<?> expression) {
            return new Accumulator(Op.$max, expression);
        }

        public static Accumulator max(String ... path) {
            return new Accumulator(Op.$max, Expression.path(path));
        }

        public static Accumulator min(Expression<?> expression) {
            return new Accumulator(Op.$min, expression);
        }

        public static Accumulator min(String ... path) {
            return new Accumulator(Op.$min, Expression.path(path));
        }

        public static Accumulator list(Expression<?> expression) {
            return new Accumulator(Op.$push, expression);
        }

        public static Accumulator list(String ... path) {
            return new Accumulator(Op.$push, Expression.path(path));
        }

        public static Accumulator sum(Expression<?> expression) {
            return new Accumulator(Op.$sum, expression);
        }

        public static Accumulator sum(String ... path) {
            return new Accumulator(Op.$sum, Expression.path(path));
        }

        public static Accumulator count() {
            return COUNT;
        }

        public Group set(String field, Accumulator value) {
            this.calculatedFields.put(field, value);
            return this;
        }

        public Group set(Map<String, Accumulator> calculatedFields) {
            calculatedFields.putAll(calculatedFields);
            return this;
        }

        public Expression<?> key() {
            return this.key;
        }

        public Set<Map.Entry<String, Accumulator>> calculatedFields() {
            return this.calculatedFields.entrySet();
        }

        public static class Accumulator {
            public final Op operator;
            public final Expression<?> expression;

            private Accumulator(Op operator, Expression<?> expression) {
                this.operator = operator;
                this.expression = expression;
            }
        }

        public static enum Op {
            $addToSet,
            $avg,
            $first,
            $last,
            $max,
            $min,
            $push,
            $sum;

        }
    }

    private static abstract class SimpleStage
    implements Pipeline.Stage<Void> {
        private SimpleStage() {
        }

        @Override
        public Pipeline.Stage<Void> set(String field, Void value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Pipeline.Stage<Void> set(Map<String, Void> fields) {
            throw new UnsupportedOperationException();
        }
    }
}

