/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import org.mongojack.JacksonDBCollection;

public class MapReduceOutput<T, K> {
    private final com.mongodb.MapReduceOutput output;
    private final JacksonDBCollection<T, K> outputCollection;
    private final Iterable<T> resultSet;

    MapReduceOutput(JacksonDBCollection<?, ?> sourceCollection, com.mongodb.MapReduceOutput output, Class<T> type, Class<K> keyType) {
        this.output = output;
        if (output.getOutputCollection() != null) {
            this.outputCollection = JacksonDBCollection.wrap(output.getOutputCollection(), type, keyType, sourceCollection.getObjectMapper());
            this.resultSet = this.outputCollection.find();
        } else {
            this.outputCollection = null;
            ArrayList<T> results = new ArrayList<T>();
            for (DBObject result : output.results()) {
                results.add(sourceCollection.convertFromDbObject(result, type));
            }
            this.resultSet = results;
        }
    }

    public Iterable<T> results() {
        return this.resultSet;
    }

    public void drop() {
        this.output.drop();
    }

    public JacksonDBCollection<T, K> getOutputCollection() {
        return this.outputCollection;
    }

    public int getDuration() {
        return this.output.getDuration();
    }

    public int getInputCount() {
        return this.output.getInputCount();
    }

    public int getOutputCount() {
        return this.output.getOutputCount();
    }

    public int getEmitCount() {
        return this.output.getEmitCount();
    }

    @Deprecated
    public CommandResult getCommandResult() {
        return this.output.getCommandResult();
    }

    public DBObject getCommand() {
        return this.output.getCommand();
    }

    @Deprecated
    public ServerAddress getServerUsed() {
        return this.output.getServerUsed();
    }

    public String toString() {
        return this.output.toString();
    }
}

