/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.mongojack.DBRef;
import org.mongojack.JacksonDBCollection;
import org.mongojack.internal.FetchableDBRef;
import org.mongojack.internal.JacksonDBCollectionProvider;

public class DBRefDeserializer<T, K>
extends JsonDeserializer<DBRef> {
    private final JavaType type;
    private final JavaType keyType;
    private final JsonDeserializer<K> keyDeserializer;

    public DBRefDeserializer(JavaType type, JavaType keyType) {
        this(type, keyType, null);
    }

    public DBRefDeserializer(JavaType type, JavaType keyType, JsonDeserializer<K> keyDeserializer) {
        this.type = type;
        this.keyType = keyType;
        this.keyDeserializer = keyDeserializer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DBRef deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (!(jp instanceof JacksonDBCollectionProvider)) throw ctxt.instantiationException(DBRef.class, "DBRef can only be deserialised by this deserializer if parser implements " + JacksonDBCollectionProvider.class.getName() + " parser is actually " + jp.getClass().getName());
        Object id = null;
        String collectionName = null;
        JsonToken token = jp.getCurrentToken();
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object object = jp.getEmbeddedObject();
            if (!(object instanceof com.mongodb.DBRef)) throw ctxt.instantiationException(DBRef.class, "Don't know what to do with embedded object: " + object);
            id = this.keyDeserializer != null ? this.keyDeserializer.deserialize(jp, ctxt) : ((com.mongodb.DBRef)object).getId();
            collectionName = ((com.mongodb.DBRef)object).getCollectionName();
        } else if (token == JsonToken.START_OBJECT) {
            token = jp.nextValue();
            while (token != JsonToken.END_OBJECT) {
                if (jp.getCurrentName().equals("$id")) {
                    id = this.keyDeserializer != null ? this.keyDeserializer.deserialize(jp, ctxt) : jp.getEmbeddedObject();
                } else if (jp.getCurrentName().equals("$ref")) {
                    collectionName = jp.getText();
                }
                token = jp.nextValue();
            }
        }
        if (id == null) {
            return null;
        }
        if (collectionName == null) {
            throw ctxt.instantiationException(DBRef.class, "DBRef contains no collection name");
        }
        JacksonDBCollection coll = ((JacksonDBCollectionProvider)jp).getDBCollection();
        JacksonDBCollection refColl = coll.getReferenceCollection(collectionName, this.type, this.keyType);
        return new FetchableDBRef(id, refColl);
    }
}

