/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.stream;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.DBEncoder;
import com.mongodb.MongoException;
import java.io.IOException;
import org.bson.BSONObject;
import org.bson.io.OutputBuffer;
import org.mongojack.MongoJsonMappingException;
import org.mongojack.internal.stream.DBEncoderBsonGenerator;
import org.mongojack.internal.stream.JacksonDBObject;
import org.mongojack.internal.stream.OutputBufferOutputStream;

public class JacksonDBEncoder
implements DBEncoder {
    private final ObjectMapper objectMapper;
    private final DBEncoder defaultDBEncoder;

    public JacksonDBEncoder(ObjectMapper objectMapper, DBEncoder defaultDBEncoder) {
        this.objectMapper = objectMapper;
        this.defaultDBEncoder = defaultDBEncoder;
    }

    public int writeObject(OutputBuffer buf, BSONObject object) {
        if (object instanceof JacksonDBObject) {
            JacksonDBObject jacksonDbObject = (JacksonDBObject)object;
            OutputBufferOutputStream stream = new OutputBufferOutputStream(buf);
            DBEncoderBsonGenerator generator = new DBEncoderBsonGenerator(JsonGenerator.Feature.collectDefaults(), stream);
            try {
                this.objectMapper.writerWithView(jacksonDbObject.getView()).writeValue((JsonGenerator)generator, jacksonDbObject.getObject());
                generator.close();
            }
            catch (JsonMappingException e) {
                throw new MongoJsonMappingException(e);
            }
            catch (IOException e) {
                throw new MongoException("Error writing object out", (Throwable)e);
            }
            return stream.getCount();
        }
        return this.defaultDBEncoder.writeObject(buf, object);
    }
}

