/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import org.beanio.internal.parser.CollectionParser;
import org.beanio.internal.parser.ParsingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayParser
extends CollectionParser {
    private Class<?> arrayType;

    @Override
    public int type() {
        return 4;
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    public Object getValue(ParsingContext context) {
        if (this.isInvalid(context)) {
            return super.getValue(context);
        }
        Collection<Object> collection = super.getCollection(context);
        if (collection == null) {
            return null;
        }
        int index = 0;
        Object array = Array.newInstance(this.arrayType, collection.size());
        for (Object obj : collection) {
            if (obj != null || !this.arrayType.isPrimitive()) {
                Array.set(array, index, obj);
            }
            ++index;
        }
        return array;
    }

    @Override
    public void setValue(ParsingContext context, Object value) {
        int length;
        ArrayList<Object> collection = null;
        if (value != null && (length = Array.getLength(value)) > 0) {
            collection = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                collection.add(Array.get(value, i));
            }
        }
        super.setValue(context, collection);
    }

    @Override
    protected Collection<Object> createCollection() {
        return new ArrayList<Object>();
    }

    public Class<?> getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(Class<?> arrayType) {
        this.arrayType = arrayType;
    }
}

