/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.Serializable;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public abstract class JpaItemReaderWriterBase {
    @Inject
    protected Instance<EntityManager> entityManagerInstance;
    @Inject
    @BatchProperty
    protected String entityManagerLookupName;
    @Inject
    @BatchProperty
    protected String persistenceUnitName;
    @Inject
    @BatchProperty
    protected Map persistenceUnitProperties;
    protected EntityManagerFactory emf;
    protected EntityManager em;

    public void open(Serializable checkpoint) throws Exception {
        try (InitialContext ic = null;){
            if (this.entityManagerLookupName != null) {
                ic = new InitialContext();
                this.em = (EntityManager)ic.lookup(this.entityManagerLookupName);
            } else {
                if (this.entityManagerInstance != null && !this.entityManagerInstance.isUnsatisfied()) {
                    this.em = (EntityManager)this.entityManagerInstance.get();
                }
                if (this.em == null) {
                    this.emf = Persistence.createEntityManagerFactory((String)this.persistenceUnitName, (Map)this.persistenceUnitProperties);
                    this.em = this.emf.createEntityManager();
                }
            }
        }
    }

    public void close() throws Exception {
        if (this.emf != null) {
            this.em.close();
            this.emf.close();
        }
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }
}

