/*
 * Decompiled with CFR 0.152.
 */
package org.jberet._private;

import java.sql.Connection;
import javax.batch.runtime.BatchStatus;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="JBERET")
@ValidIdRange(min=1, max=599)
public interface BatchLogger
extends BasicLogger {
    public static final BatchLogger LOGGER = (BatchLogger)Logger.getMessageLogger(BatchLogger.class, (String)"org.jberet");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="Failed to run batchlet %s")
    public void failToRunBatchlet(@Cause Throwable var1, Object var2);

    @Message(id=2, value="A step cannot contain both chunk type and batchlet type: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void cannotContainBothChunkAndBatchlet(String var1);

    @Message(id=3, value="A concrete step must contain either a chunk or batchlet type: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void stepContainsNoChunkOrBatchlet(String var1);

    @Message(id=4, value="Unrecognized property category: %s, variable name: %s in property value: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void unrecognizedPropertyReference(String var1, String var2, String var3);

    @Message(id=5, value="Invalid exception filter class '%s'")
    @LogMessage(level=Logger.Level.WARN)
    public void invalidExceptionClassFilter(@Cause Throwable var1, String var2);

    @Message(id=6, value="The job: %s already exists in the job repository and will not be added.")
    @LogMessage(level=Logger.Level.TRACE)
    public void jobAlreadyExists(String var1);

    @Message(id=7, value="Failed to run job %s, %s, %s")
    @LogMessage(level=Logger.Level.ERROR)
    public void failToRunJob(@Cause Throwable var1, String var2, String var3, Object var4);

    @Message(id=8, value="Possible syntax errors in property: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void possibleSyntaxErrorInProperty(String var1);

    @Message(id=9, value="A decision cannot be the first element: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void decisionCannotBeFirst(String var1);

    @Message(id=10, value="Could not resolve expression because: %s")
    @LogMessage(level=Logger.Level.DEBUG)
    public void unresolvableExpression(String var1);

    @Message(id=11, value="Failed to stop the job %s, %s, %s")
    @LogMessage(level=Logger.Level.WARN)
    public void failToStopJob(@Cause Throwable var1, String var2, String var3, Object var4);

    @Message(id=12, value="Failed to clone %s when running job [%s] and step [%s]")
    @LogMessage(level=Logger.Level.WARN)
    public void failToClone(@Cause Throwable var1, Object var2, String var3, String var4);

    @Message(id=13, value="Failed to destroy artifact %s")
    @LogMessage(level=Logger.Level.WARN)
    public void failToDestroyArtifact(@Cause Throwable var1, Object var2);

    @Message(id=14, value="Tables created for batch job repository with DDL file %s")
    @LogMessage(level=Logger.Level.DEBUG)
    public void tableCreated(String var1);

    @Message(id=15, value="Adding ddl entry for batch job repository:%n %s")
    @LogMessage(level=Logger.Level.DEBUG)
    public void addDDLEntry(String var1);

    @Message(id=16, value="Failed to close %s: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void failToClose(@Cause Throwable var1, Class<?> var2, Object var3);

    @Message(id=17, value="Persisted %s with id %s")
    @LogMessage(level=Logger.Level.DEBUG)
    public void persisted(Object var1, long var2);

    @Message(id=18, value="Could not find the original step execution to restart.  Current step execution id: %s, step name: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void couldNotFindOriginalStepToRestart(long var1, String var3);

    @Message(id=19, value="Encountered errors when creating batch job repository tables.")
    @LogMessage(level=Logger.Level.WARN)
    public void errorWhenCreatingTable(@Cause Throwable var1);

    @Message(id=20, value="Failed to get database product name from connection %s")
    @LogMessage(level=Logger.Level.WARN)
    public void failToGetDatabaseProductName(@Cause Throwable var1, Connection var2);

    @Message(id=21, value="About to initialize batch job repository with ddl-file: %s for database %s")
    @LogMessage(level=Logger.Level.INFO)
    public void ddlFileAndDatabaseProductName(String var1, String var2);

    @Message(id=22, value="%s is not implemented for local transactions")
    @LogMessage(level=Logger.Level.TRACE)
    public void notImplementedOnLocalTx(String var1);

    @Message(id=23, value="Removing %s %s")
    @LogMessage(level=Logger.Level.INFO)
    public void removing(String var1, String var2);

    @Message(id=24, value="About to mark it FAILED before restarting job execution %s, job name %s, batch status %s, restart mode %s")
    @LogMessage(level=Logger.Level.INFO)
    public void markAsFailed(long var1, String var3, BatchStatus var4, String var5);

    @Message(id=25, value="Failed to set attributes to script context for engine %s, script type %s, and some data will not be passed to script")
    @LogMessage(level=Logger.Level.WARN)
    public void failToSetAttributesToScriptContext(@Cause Throwable var1, String var2, String var3);

    @Message(id=26, value="job %s is added to waiting queue due to low number of available threads: %s")
    @LogMessage
    public void jobAddedToWaitingQueue(Object var1, int var2);

    @Message(id=27, value="job %s is taken from waiting queue and resubmitted")
    @LogMessage
    public void resubmitedQueuedJob(Object var1);

    @Message(id=28, value="Failed to serialize exception: %s")
    @LogMessage(level=Logger.Level.WARN)
    public void failedToSerializeException(@Cause Throwable var1, Throwable var2);

    @Message(id=29, value="Applied custom restart position: %s, instead of the default restart position: %s")
    @LogMessage(level=Logger.Level.INFO)
    public void customRestartPosition(String var1, String var2);
}

