/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.ViewId;
import org.jgroups.util.ArrayIterator;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class View
implements Comparable<View>,
Streamable,
Iterable<Address> {
    protected ViewId view_id;
    protected Address[] members;
    protected static final boolean suppress_view_size = Boolean.getBoolean("suppress.view_size");

    public View() {
    }

    public View(ViewId view_id, List<Address> members) {
        this.view_id = view_id;
        if (members == null) {
            throw new IllegalArgumentException("members cannot be null");
        }
        this.members = new Address[members.size()];
        int index = 0;
        for (Address member : members) {
            this.members[index++] = member;
        }
    }

    public View(ViewId view_id, Address[] members) {
        this.view_id = view_id;
        this.members = members;
        if (members == null) {
            throw new IllegalArgumentException("members cannot be null");
        }
    }

    public View(Address creator, long id, List<Address> members) {
        this(new ViewId(creator, id), members);
    }

    public static View create(Address coord, long id, Address ... members) {
        return new View(new ViewId(coord, id), members);
    }

    @Deprecated
    public ViewId getVid() {
        return this.view_id;
    }

    public ViewId getViewId() {
        return this.view_id;
    }

    public Address getCreator() {
        return this.view_id.getCreator();
    }

    public Address getCoord() {
        return this.members.length > 0 ? this.members[0] : null;
    }

    public List<Address> getMembers() {
        return Collections.unmodifiableList(Arrays.asList(this.members));
    }

    public Address[] getMembersRaw() {
        return this.members;
    }

    public boolean containsMember(Address mbr) {
        if (mbr == null || this.members == null) {
            return false;
        }
        for (Address member : this.members) {
            if (member == null || !member.equals(mbr)) continue;
            return true;
        }
        return false;
    }

    public boolean containsMembers(Address ... mbrs) {
        if (mbrs == null || this.members == null) {
            return false;
        }
        for (Address mbr : mbrs) {
            if (this.containsMember(mbr)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(View o) {
        return this.view_id.compareTo(o.view_id);
    }

    public boolean equals(Object obj) {
        return obj instanceof View && (this == obj || this.compareTo((View)obj) == 0);
    }

    public boolean deepEquals(View other) {
        return this == other || this.equals(other) && Arrays.equals(this.members, other.members);
    }

    public int hashCode() {
        return this.view_id.hashCode();
    }

    public int size() {
        return this.members.length;
    }

    @Deprecated
    public View copy() {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.view_id);
        if (this.members != null) {
            if (!suppress_view_size) {
                sb.append(" (").append(this.members.length).append(")");
            }
            sb.append(" [").append(Util.printListWithDelimiter(this.members, ", ", Util.MAX_LIST_PRINT_SIZE)).append("]");
        }
        return sb.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        this.view_id.writeTo(out);
        Util.writeAddresses(this.members, out);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.view_id = new ViewId();
        this.view_id.readFrom(in);
        this.members = Util.readAddresses(in);
    }

    public int serializedSize() {
        return (int)((long)this.view_id.serializedSize() + Util.size(this.members));
    }

    public static List<Address> leftMembers(View one, View two) {
        if (one == null || two == null) {
            return null;
        }
        ArrayList<Address> retval = new ArrayList<Address>(one.getMembers());
        retval.removeAll(two.getMembers());
        return retval;
    }

    public static Address[][] diff(View from, View to) {
        if (to == null) {
            throw new IllegalArgumentException("the second view cannot be null");
        }
        if (from == null) {
            Address[] joined = new Address[to.size()];
            int index = 0;
            for (Address addr : to.getMembers()) {
                joined[index++] = addr;
            }
            return new Address[][]{joined, new Address[0]};
        }
        Address[] joined = null;
        Address[] left = null;
        int num_joiners = 0;
        int num_left = 0;
        for (Address addr : to) {
            if (from.containsMember(addr)) continue;
            ++num_joiners;
        }
        if (num_joiners > 0) {
            joined = new Address[num_joiners];
            int index = 0;
            for (Address addr : to) {
                if (from.containsMember(addr)) continue;
                joined[index++] = addr;
            }
        }
        for (Address addr : from) {
            if (to.containsMember(addr)) continue;
            ++num_left;
        }
        if (num_left > 0) {
            left = new Address[num_left];
            int index = 0;
            for (Address addr : from) {
                if (to.containsMember(addr)) continue;
                left[index++] = addr;
            }
        }
        return new Address[][]{joined != null ? joined : new Address[]{}, left != null ? left : new Address[]{}};
    }

    @Override
    public Iterator<Address> iterator() {
        return new ArrayIterator<Address>(this.members);
    }
}

