/*
 * Decompiled with CFR 0.152.
 */
package org.beanio;

import java.util.Collection;
import java.util.Map;
import org.beanio.InvalidRecordException;
import org.beanio.RecordContext;

public class InvalidRecordGroupException
extends InvalidRecordException {
    private static final long serialVersionUID = 1L;
    private String groupName;

    public InvalidRecordGroupException(RecordContext[] context, String message, String groupName) {
        super(message);
        this.groupName = groupName;
        this.setRecordContext(context);
    }

    public String getRecordName() {
        return this.groupName;
    }

    protected void appendMessageDetails(StringBuilder s) {
        int j = this.getRecordCount();
        for (int i = 0; i < j; ++i) {
            RecordContext context = this.getRecordContext(i);
            if (!context.hasErrors()) continue;
            s.append("\n ==> Invalid '").append(context.getRecordName()).append("' record at line ").append(context.getLineNumber());
            if (context.hasRecordErrors()) {
                for (String string : context.getRecordErrors()) {
                    s.append("\n     - ");
                    s.append(string);
                }
            }
            if (!context.hasFieldErrors()) continue;
            for (Map.Entry entry : context.getFieldErrors().entrySet()) {
                String fieldName = (String)entry.getKey();
                for (String error : (Collection)entry.getValue()) {
                    s.append("\n     - Invalid '");
                    s.append(fieldName);
                    s.append("':  ");
                    s.append(error);
                }
            }
        }
    }
}

