/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Function;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;

public class NameBasedResolver {
    private ComputingCache<String, Set<Bean<?>>> resolvedNames;

    public NameBasedResolver(BeanManagerImpl manager, Iterable<? extends Bean<?>> allBeans) {
        this.resolvedNames = ComputingCacheBuilder.newBuilder().build(new NameToBeanSet(manager, allBeans));
    }

    public void clear() {
        this.resolvedNames.clear();
    }

    public Set<Bean<?>> resolve(String name) {
        return this.resolvedNames.getValue(name);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Resolver\n");
        buffer.append("Resolved names points: ").append(this.resolvedNames.size()).append('\n');
        return buffer.toString();
    }

    private static class NameToBeanSet
    implements Function<String, Set<Bean<?>>> {
        private final BeanManagerImpl beanManager;
        private final Iterable<? extends Bean<?>> allBeans;
        private final SpecializationAndEnablementRegistry registry;

        private NameToBeanSet(BeanManagerImpl beanManager, Iterable<? extends Bean<?>> allBeans) {
            this.beanManager = beanManager;
            this.allBeans = allBeans;
            this.registry = beanManager.getServices().get(SpecializationAndEnablementRegistry.class);
        }

        @Override
        public Set<Bean<?>> apply(String from) {
            HashSet matchedBeans = new HashSet();
            for (Bean<?> bean : this.allBeans) {
                if ((bean.getName() != null || from != null) && (bean.getName() == null || !bean.getName().equals(from))) continue;
                matchedBeans.add(bean);
            }
            return Beans.removeDisabledBeans(matchedBeans, this.beanManager, this.registry);
        }
    }
}

