/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.Container;
import org.jboss.weld.bean.WrappedContextual;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.context.SerializableContextualInstanceImpl;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.beanstore.BeanStore;
import org.jboss.weld.context.beanstore.LockedBean;
import org.jboss.weld.context.cache.RequestScopedCache;
import org.jboss.weld.logging.ContextLogger;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.Beans;

public abstract class AbstractContext
implements AlterableContext {
    private final boolean multithreaded;
    private final ServiceRegistry serviceRegistry;

    public AbstractContext(String contextId, boolean multithreaded) {
        this.multithreaded = multithreaded;
        this.serviceRegistry = Container.instance(contextId).services();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK"}, justification="False positive from FindBugs")
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        this.checkContextInitialized();
        BeanStore beanStore = this.getBeanStore();
        if (beanStore == null) {
            return null;
        }
        if (contextual == null) {
            throw ContextLogger.LOG.contextualIsNull();
        }
        BeanIdentifier id = this.getId(contextual);
        ContextualInstance beanInstance = beanStore.get(id);
        if (beanInstance != null) {
            return beanInstance.getInstance();
        }
        if (creationalContext != null) {
            LockedBean lock = null;
            try {
                T instance;
                if (this.multithreaded) {
                    lock = beanStore.lock(id);
                    beanInstance = beanStore.get(id);
                    if (beanInstance != null) {
                        Object t = beanInstance.getInstance();
                        return t;
                    }
                }
                if ((instance = contextual.create(creationalContext)) != null) {
                    beanInstance = new SerializableContextualInstanceImpl<Contextual<T>, T>(contextual, instance, creationalContext, this.serviceRegistry.get(ContextualStore.class));
                    beanStore.put(id, beanInstance);
                }
                T t = instance;
                return t;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        return null;
    }

    @Override
    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    @Override
    public void destroy(Contextual<?> contextual) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        this.checkContextInitialized();
        if (contextual == null) {
            throw ContextLogger.LOG.contextualIsNull();
        }
        BeanStore beanStore = this.getBeanStore();
        if (beanStore == null) {
            throw ContextLogger.LOG.noBeanStoreAvailable(this);
        }
        BeanIdentifier id = this.getId(contextual);
        ContextualInstance beanInstance = beanStore.remove(id);
        if (beanInstance != null) {
            RequestScopedCache.invalidate();
            this.destroyContextualInstance(beanInstance);
        }
    }

    private <T> void destroyContextualInstance(ContextualInstance<T> instance) {
        instance.getContextual().destroy(instance.getInstance(), instance.getCreationalContext());
        ContextLogger.LOG.contextualInstanceRemoved(instance, this);
    }

    protected void destroy() {
        ContextLogger.LOG.contextCleared(this);
        BeanStore beanStore = this.getBeanStore();
        if (beanStore == null) {
            throw ContextLogger.LOG.noBeanStoreAvailable(this);
        }
        for (BeanIdentifier id : beanStore) {
            this.destroyContextualInstance(beanStore.get(id));
        }
        beanStore.clear();
    }

    protected abstract BeanStore getBeanStore();

    public void cleanup() {
        BeanStore beanStore = this.getBeanStore();
        if (beanStore != null) {
            try {
                beanStore.clear();
            }
            catch (Exception e) {
                ContextLogger.LOG.unableToClearBeanStore(beanStore);
                ContextLogger.LOG.catchingDebug(e);
            }
        }
    }

    protected static <T> Contextual<T> getContextual(String contextId, String id) {
        return Container.instance(contextId).services().get(ContextualStore.class).getContextual(id);
    }

    protected BeanIdentifier getId(Contextual<?> contextual) {
        if (contextual instanceof WrappedContextual) {
            contextual = ((WrappedContextual)contextual).delegate();
        }
        return Beans.getIdentifier(contextual, this.serviceRegistry);
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected void checkContextInitialized() {
    }
}

