/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionIsRunningException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jberet._private.BatchLogger;
import org.jberet._private.BatchMessages;
import org.jberet.creation.ArchiveXmlLoader;
import org.jberet.creation.ArtifactFactoryWrapper;
import org.jberet.job.model.Job;
import org.jberet.repository.ApplicationAndJobName;
import org.jberet.repository.JobRepository;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.context.JobContextImpl;
import org.jberet.runtime.runner.JobExecutionRunner;
import org.jberet.spi.BatchEnvironment;

public abstract class AbstractJobOperator
implements JobOperator {
    protected abstract BatchEnvironment getBatchEnvironment();

    protected JobRepository getJobRepository() {
        return this.getBatchEnvironment().getJobRepository();
    }

    public long start(String jobXMLName, Properties jobParameters) throws JobStartException, JobSecurityException {
        return this.start(jobXMLName, jobParameters, null);
    }

    public long start(String jobXMLName, Properties jobParameters, String user) throws JobStartException, JobSecurityException {
        BatchEnvironment batchEnvironment = this.getBatchEnvironment();
        Job jobDefined = ArchiveXmlLoader.loadJobXml(jobXMLName, batchEnvironment.getClassLoader(), new ArrayList<Job>(), batchEnvironment.getJobXmlResolver());
        return this.start(jobDefined, jobParameters, user);
    }

    public long start(Job jobDefined, Properties jobParameters) throws JobStartException, JobSecurityException {
        return this.start(jobDefined, jobParameters, null);
    }

    public long start(final Job jobDefined, final Properties jobParameters, final String user) throws JobStartException, JobSecurityException {
        BatchEnvironment batchEnvironment = this.getBatchEnvironment();
        final ClassLoader classLoader = batchEnvironment.getClassLoader();
        final String applicationName = this.getApplicationName();
        this.getJobRepository().addJob(new ApplicationAndJobName(applicationName, jobDefined.getId()), jobDefined);
        try {
            return this.invokeTransaction(new TransactionInvocation<Long>(){

                @Override
                public Long invoke() throws JobStartException, JobSecurityException {
                    JobInstanceImpl jobInstance = AbstractJobOperator.this.getJobRepository().createJobInstance(jobDefined, applicationName, classLoader);
                    return AbstractJobOperator.this.startJobExecution(jobInstance, jobParameters, null, user);
                }
            });
        }
        catch (InvalidTransactionException | SystemException e) {
            throw new JobStartException(e);
        }
    }

    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        JobExecutionImpl jobExecution = this.getJobExecutionImpl(executionId);
        BatchStatus s = jobExecution.getBatchStatus();
        if (s == BatchStatus.STOPPED || s == BatchStatus.FAILED || s == BatchStatus.ABANDONED || s == BatchStatus.COMPLETED) {
            throw BatchMessages.MESSAGES.jobExecutionNotRunningException(executionId, s);
        }
        if (s != BatchStatus.STOPPING) {
            jobExecution.setBatchStatus(BatchStatus.STOPPING);
            jobExecution.stop();
        }
    }

    public Set<String> getJobNames() throws JobSecurityException {
        return this.getJobRepository().getJobNames();
    }

    public int getJobInstanceCount(String jobName) throws NoSuchJobException, JobSecurityException {
        if (jobName == null) {
            throw BatchMessages.MESSAGES.noSuchJobException(null);
        }
        JobRepository repository = this.getJobRepository();
        int count = repository.getJobInstanceCount(jobName);
        if (count == 0 && !repository.jobExists(jobName)) {
            throw BatchMessages.MESSAGES.noSuchJobException(jobName);
        }
        return count;
    }

    public List<JobInstance> getJobInstances(String jobName, int start, int count) throws NoSuchJobException, JobSecurityException {
        if (jobName == null) {
            throw BatchMessages.MESSAGES.noSuchJobException(null);
        }
        JobRepository repository = this.getJobRepository();
        List<JobInstance> instances = repository.getJobInstances(jobName);
        int size = instances.size();
        if (size == 0 && !repository.jobExists(jobName)) {
            throw BatchMessages.MESSAGES.noSuchJobException(jobName);
        }
        return instances.subList(Math.min(start, size), Math.min(start + count, size));
    }

    public List<Long> getRunningExecutions(String jobName) throws NoSuchJobException, JobSecurityException {
        if (jobName == null) {
            throw BatchMessages.MESSAGES.noSuchJobException(null);
        }
        JobRepository repository = this.getJobRepository();
        List<Long> result = repository.getRunningExecutions(jobName);
        if (result.size() == 0 && !repository.jobExists(jobName)) {
            throw BatchMessages.MESSAGES.noSuchJobException(jobName);
        }
        return result;
    }

    public Properties getParameters(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.getJobExecutionImpl(executionId).getJobParameters();
    }

    public long restart(long executionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        return this.restart(executionId, restartParameters, null);
    }

    public long restart(long executionId, Properties restartParameters, String user) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        String restartMode;
        JobExecutionImpl originalToRestart = this.getJobExecutionImpl(executionId);
        if ("jberet.unrestartable".equals(originalToRestart.getRestartPosition())) {
            throw BatchMessages.MESSAGES.unrestartableJob(originalToRestart.getJobName(), executionId);
        }
        BatchStatus previousStatus = originalToRestart.getBatchStatus();
        if (previousStatus == BatchStatus.FAILED || previousStatus == BatchStatus.STOPPED) {
            return this.restartFailedOrStopped(executionId, originalToRestart, restartParameters, user);
        }
        if (previousStatus == BatchStatus.COMPLETED) {
            throw BatchMessages.MESSAGES.jobExecutionAlreadyCompleteException(executionId);
        }
        if (previousStatus == BatchStatus.ABANDONED) {
            throw BatchMessages.MESSAGES.jobRestartException(executionId, previousStatus);
        }
        String string = restartMode = restartParameters != null ? restartParameters.getProperty("jberet.restart.mode") : null;
        if ("strict".equalsIgnoreCase(restartMode)) {
            throw BatchMessages.MESSAGES.jobRestartException(executionId, previousStatus);
        }
        if (restartMode == null || restartMode.equalsIgnoreCase("detect")) {
            if (originalToRestart.getJobInstance().getUnsubstitutedJob() != null) {
                throw BatchMessages.MESSAGES.restartRunningExecution(executionId, originalToRestart.getJobName(), previousStatus, restartMode);
            }
        } else if (!restartMode.equalsIgnoreCase("force")) {
            throw BatchMessages.MESSAGES.invalidRestartMode(executionId, originalToRestart.getJobName(), previousStatus, restartMode, Arrays.asList("detect", "force", "strict"));
        }
        BatchLogger.LOGGER.markAsFailed(executionId, originalToRestart.getJobName(), previousStatus, restartMode);
        originalToRestart.setBatchStatus(BatchStatus.FAILED);
        this.getJobRepository().updateJobExecution(originalToRestart, false, false);
        return this.restartFailedOrStopped(executionId, originalToRestart, restartParameters, user);
    }

    public void abandon(long executionId) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        JobExecutionImpl jobExecution = this.getJobExecutionImpl(executionId);
        BatchStatus batchStatus = jobExecution.getBatchStatus();
        if (batchStatus == BatchStatus.COMPLETED || batchStatus == BatchStatus.FAILED || batchStatus == BatchStatus.STOPPED || batchStatus == BatchStatus.ABANDONED) {
            jobExecution.setBatchStatus(BatchStatus.ABANDONED);
            this.getJobRepository().updateJobExecution(jobExecution, false, false);
            JobInstanceImpl jobInstance = jobExecution.getJobInstance();
            if (jobInstance != null) {
                jobInstance.setUnsubstitutedJob(null);
            }
        } else {
            throw BatchMessages.MESSAGES.jobExecutionIsRunningException(executionId);
        }
    }

    public JobInstance getJobInstance(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        JobExecutionImpl jobExecution = this.getJobExecutionImpl(executionId);
        return jobExecution.getJobInstance();
    }

    public List<JobExecution> getJobExecutions(JobInstance instance) throws NoSuchJobInstanceException, JobSecurityException {
        return this.getJobRepository().getJobExecutions(instance);
    }

    public JobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        return this.getJobExecutionImpl(executionId);
    }

    public List<StepExecution> getStepExecutions(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        List<StepExecution> stepExecutions = this.getJobRepository().getStepExecutions(jobExecutionId, this.getBatchEnvironment().getClassLoader());
        if (stepExecutions.isEmpty()) {
            this.getJobExecutionImpl(jobExecutionId);
        }
        return stepExecutions;
    }

    protected JobExecutionImpl getJobExecutionImpl(long executionId) throws NoSuchJobExecutionException {
        JobExecutionImpl jobExecution = (JobExecutionImpl)this.getJobRepository().getJobExecution(executionId);
        if (jobExecution == null) {
            throw BatchMessages.MESSAGES.noSuchJobExecution(executionId);
        }
        return jobExecution;
    }

    private long restartFailedOrStopped(long executionId, final JobExecutionImpl originalToRestart, Properties restartParameters, final String user) throws JobExecutionNotMostRecentException, JobRestartException {
        final JobInstanceImpl jobInstance = originalToRestart.getJobInstance();
        if (jobInstance == null) {
            throw BatchMessages.MESSAGES.noSuchJobInstance(null);
        }
        List<JobExecution> executions = this.getJobExecutions(jobInstance);
        JobExecution mostRecentExecution = executions.get(executions.size() - 1);
        if (executionId != mostRecentExecution.getExecutionId()) {
            throw BatchMessages.MESSAGES.jobExecutionNotMostRecentException(executionId, jobInstance.getInstanceId());
        }
        BatchEnvironment batchEnvironment = this.getBatchEnvironment();
        JobRepository repository = this.getJobRepository();
        String jobName = originalToRestart.getJobName();
        Properties oldJobParameters = originalToRestart.getJobParameters();
        Job jobDefined = jobInstance.getUnsubstitutedJob();
        if (jobDefined == null) {
            ApplicationAndJobName applicationAndJobName = new ApplicationAndJobName(jobInstance.getApplicationName(), jobName);
            jobDefined = repository.getJob(applicationAndJobName);
            if (jobDefined == null) {
                String jobXmlName = null;
                if (oldJobParameters != null) {
                    jobXmlName = oldJobParameters.getProperty("jberet.jobXmlName");
                }
                if (jobXmlName == null) {
                    jobXmlName = jobName;
                } else {
                    oldJobParameters.remove("jberet.jobXmlName");
                    if (!oldJobParameters.propertyNames().hasMoreElements()) {
                        oldJobParameters = null;
                    }
                }
                jobDefined = ArchiveXmlLoader.loadJobXml(jobXmlName, batchEnvironment.getClassLoader(), new ArrayList<Job>(), batchEnvironment.getJobXmlResolver());
                repository.addJob(applicationAndJobName, jobDefined);
            }
            jobInstance.setUnsubstitutedJob(jobDefined);
        }
        try {
            Properties combinedProperties;
            if (oldJobParameters != null) {
                if (restartParameters == null) {
                    combinedProperties = oldJobParameters;
                } else {
                    combinedProperties = new Properties(oldJobParameters);
                    for (String k : restartParameters.stringPropertyNames()) {
                        combinedProperties.setProperty(k, restartParameters.getProperty(k));
                    }
                }
            } else {
                combinedProperties = restartParameters;
            }
            return this.invokeTransaction(new TransactionInvocation<Long>(){

                @Override
                public Long invoke() throws JobStartException, JobSecurityException {
                    return AbstractJobOperator.this.startJobExecution(jobInstance, combinedProperties, originalToRestart, user);
                }
            });
        }
        catch (Exception e) {
            throw new JobRestartException((Throwable)e);
        }
    }

    private long startJobExecution(JobInstanceImpl jobInstance, Properties jobParameters, JobExecutionImpl originalToRestart, String user) throws JobStartException, JobSecurityException {
        BatchEnvironment batchEnvironment = this.getBatchEnvironment();
        JobRepository repository = this.getJobRepository();
        JobExecutionImpl jobExecution = repository.createJobExecution(jobInstance, jobParameters);
        jobExecution.setUser(user);
        JobContextImpl jobContext = new JobContextImpl(jobExecution, originalToRestart, new ArtifactFactoryWrapper(batchEnvironment.getArtifactFactory()), repository, batchEnvironment);
        JobExecutionRunner jobExecutionRunner = new JobExecutionRunner(jobContext);
        jobContext.getBatchEnvironment().submitTask(jobExecutionRunner);
        return jobExecution.getExecutionId();
    }

    private String getApplicationName() {
        try {
            return (String)InitialContext.doLookup("java:app/AppName");
        }
        catch (NamingException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T invokeTransaction(TransactionInvocation<T> transactionInvocation) throws SystemException, InvalidTransactionException {
        TransactionManager tm = this.getBatchEnvironment().getTransactionManager();
        Transaction tx = tm.suspend();
        if (tx != null) {
            try {
                T t = transactionInvocation.invoke();
                return t;
            }
            finally {
                tm.resume(tx);
            }
        }
        return transactionInvocation.invoke();
    }

    private static interface TransactionInvocation<T> {
        public T invoke() throws JobStartException, JobSecurityException;
    }
}

