/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.beanio.BeanIOConfigurationException;
import org.beanio.BeanReader;
import org.beanio.BeanWriter;
import org.beanio.Marshaller;
import org.beanio.StreamFactory;
import org.beanio.Unmarshaller;
import org.beanio.builder.StreamBuilder;
import org.beanio.internal.compiler.StreamCompiler;
import org.beanio.internal.parser.Stream;

public class DefaultStreamFactory
extends StreamFactory {
    private StreamCompiler compiler;
    private Map<String, Stream> contextMap = new ConcurrentHashMap<String, Stream>();

    protected void init() {
        super.init();
        this.compiler = new StreamCompiler(this.getClassLoader());
    }

    public void define(StreamBuilder builder) {
        this.addStream(this.compiler.build(builder.build()));
    }

    public void load(InputStream in, Properties properties) throws IOException, BeanIOConfigurationException {
        Collection<Stream> streams = this.compiler.loadMapping(in, properties);
        for (Stream stream : streams) {
            this.addStream(stream);
        }
    }

    public BeanReader createReader(String name, Reader in, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Stream stream = this.getStream(name);
        switch (stream.getMode()) {
            case 0: 
            case 1: {
                return stream.createBeanReader(in, locale);
            }
        }
        throw new IllegalArgumentException("Read mode not supported for stream mapping '" + name + "'");
    }

    public Unmarshaller createUnmarshaller(String name, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Stream stream = this.getStream(name);
        switch (stream.getMode()) {
            case 0: 
            case 1: {
                return stream.createUnmarshaller(locale);
            }
        }
        throw new IllegalArgumentException("Read mode not supported for stream mapping '" + name + "'");
    }

    public BeanWriter createWriter(String name, Writer out) {
        Stream stream = this.getStream(name);
        switch (stream.getMode()) {
            case 0: 
            case 2: {
                return stream.createBeanWriter(out);
            }
        }
        throw new IllegalArgumentException("Write mode not supported for stream mapping '" + name + "'");
    }

    public Marshaller createMarshaller(String name) {
        Stream stream = this.getStream(name);
        switch (stream.getMode()) {
            case 0: 
            case 2: {
                return stream.createMarshaller();
            }
        }
        throw new IllegalArgumentException("Write mode not supported for stream mapping '" + name + "'");
    }

    protected Stream getStream(String name) throws IllegalArgumentException {
        Stream s = this.contextMap.get(name);
        if (s == null) {
            throw new IllegalArgumentException("No stream mapping configured for name '" + name + "'");
        }
        return s;
    }

    public void addStream(Stream stream) {
        this.contextMap.put(stream.getName(), stream);
    }

    public Stream removeStream(String name) {
        return this.contextMap.remove(name);
    }

    public void setCompiler(StreamCompiler compiler) {
        this.compiler = compiler;
    }

    public boolean isMapped(String streamName) {
        return this.contextMap.containsKey(streamName);
    }
}

