/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser.format.delimited;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.beanio.internal.parser.MarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelimitedMarshallingContext
extends MarshallingContext {
    private int committed = 0;
    private ArrayList<String> record = new ArrayList();
    private ArrayList<Entry> entries = new ArrayList();

    @Override
    public void clear() {
        super.clear();
        this.entries.clear();
        this.committed = 0;
    }

    public void setField(int position, String fieldText, boolean commit) {
        int index = this.getAdjustedFieldPosition(position);
        Entry entry = new Entry(index, fieldText);
        this.entries.add(entry);
        if (commit) {
            this.committed = this.entries.size();
        }
    }

    @Override
    public Object getRecordObject() {
        this.record.clear();
        List<Entry> committedEntries = this.committed < this.entries.size() ? this.entries.subList(0, this.committed) : this.entries;
        Collections.sort(committedEntries);
        int size = 0;
        int offset = -1;
        for (Entry entry : committedEntries) {
            int index = entry.position;
            if (index < 0) {
                if (offset == -1) {
                    offset = size + Math.abs(index);
                    index = size;
                } else {
                    index += offset;
                }
            }
            if (index < size) {
                this.record.set(index, entry.text);
                continue;
            }
            while (index > size) {
                this.record.add("");
                ++size;
            }
            this.record.add(entry.text);
            ++size;
        }
        return this.record.toArray(new String[0]);
    }

    @Override
    public String[] toArray(Object record) {
        return (String[])record;
    }

    @Override
    public List<String> toList(Object record) {
        return Arrays.asList((String[])record);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry
    implements Comparable<Entry> {
        int position;
        int order;
        String text;

        public Entry(int position, String text) {
            this.position = position;
            this.order = position < 0 ? position + Integer.MAX_VALUE : position;
            this.text = text;
        }

        @Override
        public int compareTo(Entry o) {
            return new Integer(this.order).compareTo(o.order);
        }

        public String toString() {
            return this.order + ":" + this.text;
        }
    }
}

