/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.builder;

public final class TypedProperty<T> {
    private final String _name;
    private final Class<T> _type;

    public TypedProperty(String name, Class<T> type) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this._name = name;
        this._type = type;
    }

    public String name() {
        return this._name;
    }

    public Class<T> type() {
        return this._type;
    }

    public String toString() {
        return this._name + "(" + this._type + ")";
    }

    public static <T> TypedProperty<T> with(String name, Class<T> type) {
        return new TypedProperty<T>(name, type);
    }

    public static <T> TypedProperty<T> with(Class<T> type) {
        return new TypedProperty<T>(type.getSimpleName(), type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypedProperty other = (TypedProperty)obj;
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        return !(this._type == null ? other._type != null : !this._type.equals(other._type));
    }
}

