/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config.store;

import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.builder.ImmutableContainer;
import de.flapdoodle.embed.process.builder.TypedProperty;
import de.flapdoodle.embed.process.config.store.ILibraryStore;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Platform;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlatformLibraryStoreBuilder
extends AbstractBuilder<ILibraryStore> {
    private static final TypedProperty<LibraryContainer> LIBRARIES = TypedProperty.with("Libraries", LibraryContainer.class);

    public PlatformLibraryStoreBuilder defaults() {
        this.setDefault(LIBRARIES, null);
        return this;
    }

    public PlatformLibraryStoreBuilder setLibraries(Platform platform, String[] libraries) {
        Map<Platform, List<String>> _libraries;
        LibraryContainer libraryContainer = this.get(LIBRARIES, null);
        if (libraryContainer == null) {
            _libraries = new HashMap();
            this.set(LIBRARIES, new LibraryContainer(_libraries));
        } else {
            _libraries = (Map)libraryContainer.value();
        }
        _libraries.put(platform, Arrays.asList(libraries));
        return this;
    }

    public PlatformLibraryStoreBuilder setLibrary(Platform platform, String library) {
        HashMap<Platform, List<String>> _libraries = (HashMap<Platform, List<String>>)this.get(LIBRARIES).value();
        if (_libraries == null) {
            _libraries = new HashMap<Platform, List<String>>();
            _libraries.put(platform, Arrays.asList(library));
        }
        this.set(LIBRARIES, new LibraryContainer((Map<Platform, List<String>>)_libraries));
        return this;
    }

    @Override
    public ILibraryStore build() {
        Map value = (Map)this.get(LIBRARIES).value();
        return new ImmutableLibraryStore(value);
    }

    static class ImmutableLibraryStore
    implements ILibraryStore {
        private final Map<Platform, List<String>> _libraries;

        private ImmutableLibraryStore(Map<Platform, List<String>> _libraries) {
            this._libraries = _libraries;
        }

        @Override
        public List<String> getLibrary(Distribution distribution) {
            return this._libraries.get((Object)distribution.getPlatform());
        }
    }

    static class LibraryContainer
    extends ImmutableContainer<Map<Platform, List<String>>> {
        public LibraryContainer(Map<Platform, List<String>> libraries) {
            super(libraries);
        }
    }
}

