/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.extract.CommonsArchiveEntryAdapter;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.extract.IExtractionMatch;
import de.flapdoodle.embed.process.extract.IExtractor;
import de.flapdoodle.embed.process.extract.ImmutableExtractedFileSet;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.ArchiveEntry;

public abstract class AbstractExtractor
implements IExtractor {
    private static Logger _logger = Logger.getLogger(AbstractExtractor.class.getName());

    protected abstract ArchiveWrapper archiveStream(File var1) throws FileNotFoundException, IOException;

    private ArchiveWrapper archiveStreamWithExceptionHint(File source) throws FileNotFoundException, IOException {
        try {
            return this.archiveStream(source);
        }
        catch (IOException iox) {
            _logger.log(Level.WARNING, "\n--------------------------\nIf you get this exception more than once, you should check if the file is corrupt.\nIf you remove the file (" + source.getAbsolutePath() + "), it will be downloaded again.\n--------------------------", iox);
            throw new IOException("File " + source.getAbsolutePath(), iox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExtractedFileSet extract(IDownloadConfig runtime, File source, FilesToExtract toExtract) throws IOException {
        ImmutableExtractedFileSet.Builder builder = ImmutableExtractedFileSet.builder(toExtract.generatedBaseDir());
        IProgressListener progressListener = runtime.getProgressListener();
        String progressLabel = "Extract " + source;
        progressListener.start(progressLabel);
        ArchiveWrapper archive = this.archiveStreamWithExceptionHint(source);
        try {
            ArchiveEntry entry;
            while ((entry = archive.getNextEntry()) != null) {
                IExtractionMatch match = toExtract.find(new CommonsArchiveEntryAdapter(entry));
                if (match == null) continue;
                if (archive.canReadEntryData(entry)) {
                    long size = entry.getSize();
                    builder.file(match.type(), match.write(archive.asStream(entry), size));
                }
                if (!toExtract.nothingLeft()) continue;
                progressListener.done(progressLabel);
                break;
            }
        }
        finally {
            archive.close();
        }
        return builder.build();
    }

    protected static interface ArchiveWrapper {
        public ArchiveEntry getNextEntry() throws IOException;

        public InputStream asStream(ArchiveEntry var1) throws IOException;

        public void close() throws IOException;

        public boolean canReadEntryData(ArchiveEntry var1);
    }
}

