/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.mongo.config.IMongoConfig;
import de.flapdoodle.embed.mongo.config.MongoCmdOptionsBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.builder.IProperty;
import de.flapdoodle.embed.process.builder.TypedProperty;
import de.flapdoodle.embed.process.config.ISupportConfig;
import java.io.IOException;
import java.net.UnknownHostException;

public abstract class AbstractMongoConfigBuilder<T extends IMongoConfig>
extends AbstractBuilder<T> {
    protected static final TypedProperty<IFeatureAwareVersion> VERSION = TypedProperty.with((String)"Version", IFeatureAwareVersion.class);
    protected static final TypedProperty<Timeout> TIMEOUT = TypedProperty.with((String)"Timeout", Timeout.class);
    protected static final TypedProperty<Net> NET = TypedProperty.with((String)"Net", Net.class);
    protected static final TypedProperty<IMongoCmdOptions> CMD_OPTIONS = TypedProperty.with((String)"CmdOptions", IMongoCmdOptions.class);
    protected static final TypedProperty<String> PID_FILE = TypedProperty.with((String)"PidFile", String.class);

    public AbstractMongoConfigBuilder() throws UnknownHostException, IOException {
        this.timeout().setDefault((Object)new Timeout());
        this.net().setDefault((Object)new Net());
        this.cmdOptions().setDefault((Object)new MongoCmdOptionsBuilder().build());
    }

    protected IProperty<IFeatureAwareVersion> version() {
        return this.property(VERSION);
    }

    protected IProperty<Timeout> timeout() {
        return this.property(TIMEOUT);
    }

    protected IProperty<Net> net() {
        return this.property(NET);
    }

    protected IProperty<IMongoCmdOptions> cmdOptions() {
        return this.property(CMD_OPTIONS);
    }

    protected IProperty<String> pidFile() {
        return this.property(PID_FILE);
    }

    static class ImmutableMongoConfig
    implements IMongoConfig {
        private final ISupportConfig _supportConfig;
        private final IFeatureAwareVersion _version;
        private final Timeout _timeout;
        private final Net _net;
        private final IMongoCmdOptions _cmdOptions;
        private final String _pidFile;

        public ImmutableMongoConfig(ISupportConfig supportConfig, IFeatureAwareVersion version, Net net, Timeout timeout, IMongoCmdOptions cmdOptions, String pidFile) {
            this._supportConfig = supportConfig;
            this._version = version;
            this._net = net;
            this._timeout = timeout;
            this._cmdOptions = cmdOptions;
            this._pidFile = pidFile;
        }

        @Override
        public IFeatureAwareVersion version() {
            return this._version;
        }

        @Override
        public Timeout timeout() {
            return this._timeout;
        }

        @Override
        public Net net() {
            return this._net;
        }

        @Override
        public IMongoCmdOptions cmdOptions() {
            return this._cmdOptions;
        }

        @Override
        public String pidFile() {
            return this._pidFile;
        }

        public ISupportConfig supportConfig() {
            return this._supportConfig;
        }
    }
}

