/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.tests;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongosExecutable;
import de.flapdoodle.embed.mongo.MongosProcess;
import de.flapdoodle.embed.mongo.MongosStarter;
import de.flapdoodle.embed.mongo.config.IMongosConfig;
import de.flapdoodle.embed.mongo.config.MongosConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.logging.Logger;

public class MongosForTestsFactory {
    private static Logger logger = Logger.getLogger(MongosForTestsFactory.class.getName());
    private final MongosExecutable mongoConfigExecutable;
    private final MongosProcess mongoConfigProcess;
    private final MongosExecutable mongosExecutable;
    private final MongosProcess mongosProcess;

    public static MongosForTestsFactory with(IFeatureAwareVersion version) throws IOException {
        return new MongosForTestsFactory(version);
    }

    public MongosForTestsFactory() throws IOException {
        this(Version.Main.PRODUCTION);
    }

    public MongosForTestsFactory(IFeatureAwareVersion version) throws IOException {
        MongosStarter mongoConfigRuntime = MongosStarter.getInstance(new RuntimeConfigBuilder().defaultsWithLogger(Command.MongoS, logger).build());
        int configServerPort = 27019;
        int mongosPort = 27017;
        IMongosConfig config = new MongosConfigBuilder().version(version).net(new Net(configServerPort, Network.localhostIsIPv6())).configDB("testDB").build();
        this.mongoConfigExecutable = (MongosExecutable)mongoConfigRuntime.prepare(config);
        this.mongoConfigProcess = (MongosProcess)this.mongoConfigExecutable.start();
        MongosStarter runtime = MongosStarter.getInstance(new RuntimeConfigBuilder().defaultsWithLogger(Command.MongoS, logger).build());
        config = new MongosConfigBuilder().version(version).net(new Net(mongosPort, Network.localhostIsIPv6())).configDB(Network.getLocalHost().getHostName() + ":" + configServerPort).build();
        this.mongosExecutable = (MongosExecutable)runtime.prepare(config);
        this.mongosProcess = (MongosProcess)this.mongosExecutable.start();
    }

    public Mongo newMongo() throws UnknownHostException, MongoException {
        return new Mongo(new ServerAddress(((IMongosConfig)this.mongosProcess.getConfig()).net().getServerAddress(), ((IMongosConfig)this.mongosProcess.getConfig()).net().getPort()));
    }

    public DB newDB(Mongo mongo) {
        return mongo.getDB(UUID.randomUUID().toString());
    }

    public void shutdown() {
        this.mongosProcess.stop();
        this.mongosExecutable.stop();
    }
}

