/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.bean.CommonBean;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.contexts.SerializableContextualFactory;
import org.jboss.weld.contexts.SerializableContextualInstanceImpl;
import org.jboss.weld.serialization.BeanIdentifierIndex;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.serialization.spi.helpers.SerializableContextualInstance;
import org.jboss.weld.util.reflection.Reflections;

public class ContextualStoreImpl
implements ContextualStore {
    private static final String GENERATED_ID_PREFIX = ContextualStoreImpl.class.getName();
    private final ConcurrentMap<Contextual<?>, BeanIdentifier> contextuals;
    private final ConcurrentMap<BeanIdentifier, Contextual<?>> contextualsInverse;
    private final ConcurrentMap<BeanIdentifier, Contextual<?>> passivationCapableContextuals;
    private final AtomicInteger idGenerator;
    private final String contextId;
    private final BeanIdentifierIndex beanIdentifierIndex;

    public ContextualStoreImpl(String contextId, BeanIdentifierIndex beanIdentifierIndex) {
        this.contextId = contextId;
        this.beanIdentifierIndex = beanIdentifierIndex;
        this.idGenerator = new AtomicInteger(0);
        this.contextuals = new ConcurrentHashMap();
        this.contextualsInverse = new ConcurrentHashMap();
        this.passivationCapableContextuals = new ConcurrentHashMap();
    }

    public <C extends Contextual<I>, I> C getContextual(String id) {
        return this.getContextual(new StringBeanIdentifier(id));
    }

    public <C extends Contextual<I>, I> C getContextual(BeanIdentifier identifier) {
        if (identifier.asString().startsWith(GENERATED_ID_PREFIX)) {
            return (C)((Contextual)this.contextualsInverse.get(identifier));
        }
        return (C)((Contextual)this.passivationCapableContextuals.get(identifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_OF_PUTIFABSENT_IGNORED"}, justification="Using non-standard semantics of putIfAbsent")
    public BeanIdentifier putIfAbsent(Contextual<?> contextual) {
        if (contextual instanceof CommonBean) {
            CommonBean bean = (CommonBean)contextual;
            this.passivationCapableContextuals.putIfAbsent(bean.getIdentifier(), contextual);
            return bean.getIdentifier();
        }
        if (contextual instanceof PassivationCapable) {
            PassivationCapable passivationCapable = (PassivationCapable)contextual;
            String id = passivationCapable.getId();
            StringBeanIdentifier identifier = new StringBeanIdentifier(id);
            this.passivationCapableContextuals.putIfAbsent(identifier, contextual);
            return identifier;
        }
        BeanIdentifier id = (BeanIdentifier)this.contextuals.get(contextual);
        if (id != null) {
            return id;
        }
        Contextual<?> contextual2 = contextual;
        synchronized (contextual2) {
            id = (BeanIdentifier)this.contextuals.get(contextual);
            if (id == null) {
                id = new StringBeanIdentifier(GENERATED_ID_PREFIX + this.idGenerator.incrementAndGet());
                this.contextuals.put(contextual, id);
                this.contextualsInverse.put(id, contextual);
            }
            return id;
        }
    }

    public <C extends Contextual<I>, I> SerializableContextual<C, I> getSerializableContextual(Contextual<I> contextual) {
        if (contextual instanceof SerializableContextual) {
            return (SerializableContextual)Reflections.cast(contextual);
        }
        return SerializableContextualFactory.create(this.contextId, (Contextual)Reflections.cast(contextual), this, this.beanIdentifierIndex);
    }

    public <C extends Contextual<I>, I> SerializableContextualInstance<C, I> getSerializableContextualInstance(Contextual<I> contextual, I instance, CreationalContext<I> creationalContext) {
        return new SerializableContextualInstanceImpl<Contextual, I>((Contextual)Reflections.cast(contextual), instance, creationalContext, this);
    }

    public void cleanup() {
        this.contextuals.clear();
        this.contextualsInverse.clear();
        this.passivationCapableContextuals.clear();
    }
}

