/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.batch.api.BatchProperty;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jberet.support._private.SupportMessages;

public abstract class JpaItemReaderWriterBase {
    @Inject
    protected Instance<EntityManager> entityManagerInstance;
    @Inject
    @BatchProperty
    protected String entityManagerLookupName;
    @Inject
    @BatchProperty
    protected String persistenceUnitName;
    @Inject
    @BatchProperty
    protected Map persistenceUnitProperties;
    protected EntityManagerFactory emf;
    protected EntityManager em;

    @PostConstruct
    protected void postConstruct() {
        this.initEntityManager();
    }

    @PreDestroy
    protected void preDestroy() {
        this.closeEntityManager();
    }

    protected void initEntityManager() {
        if (this.em == null) {
            if (this.entityManagerLookupName != null) {
                InitialContext ic = null;
                try {
                    ic = new InitialContext();
                    this.em = (EntityManager)ic.lookup(this.entityManagerLookupName);
                }
                catch (NamingException e) {
                    throw SupportMessages.MESSAGES.failToLookup(e, this.entityManagerLookupName);
                }
                finally {
                    if (ic != null) {
                        try {
                            ic.close();
                        }
                        catch (NamingException namingException) {}
                    }
                }
            }
            if (this.entityManagerInstance != null && !this.entityManagerInstance.isUnsatisfied()) {
                this.em = (EntityManager)this.entityManagerInstance.get();
            }
            if (this.em == null) {
                this.emf = Persistence.createEntityManagerFactory((String)this.persistenceUnitName, (Map)this.persistenceUnitProperties);
                this.em = this.emf.createEntityManager();
            }
        }
    }

    protected void closeEntityManager() {
        if (this.emf != null) {
            this.em.close();
            this.emf.close();
        }
    }
}

