/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.ItemReaderWriterBase;
import org.jboss.logging.Logger;

@Named
@Dependent
public class MockItemWriter
extends ItemReaderWriterBase
implements ItemWriter {
    @Inject
    @BatchProperty
    protected Boolean toConsole;
    @Inject
    @BatchProperty
    protected Class toClass;
    protected List listField;
    @Inject
    @BatchProperty
    protected String toFile;
    @Inject
    @BatchProperty
    protected String writeMode;
    protected PrintWriter printWriter;

    public void open(Serializable checkpoint) throws Exception {
        Field[] fieldArray;
        int n;
        int n2;
        if (this.toClass != null && (n2 = 0) < (n = (fieldArray = this.toClass.getFields()).length)) {
            Field f = fieldArray[n2];
            if (List.class.isAssignableFrom(f.getType())) {
                this.listField = (List)f.get(null);
                if (this.listField == null) {
                    this.listField = new ArrayList();
                    f.set(null, this.listField);
                }
            } else {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.toClass.getName(), "toClass");
            }
        }
        if (this.toFile != null) {
            this.resource = this.toFile;
            this.printWriter = new PrintWriter(this.getOutputStream(this.writeMode), true);
        }
    }

    public void writeItems(List<Object> items) throws Exception {
        if (this.listField != null) {
            this.listField.addAll(items);
        }
        if (this.printWriter != null) {
            for (Object e : items) {
                this.printWriter.println(e.toString());
            }
        }
        if (this.toClass == null && this.toFile == null && this.toConsole == null || this.toConsole == Boolean.TRUE) {
            for (Object e : items) {
                System.out.println(e.toString());
            }
            System.out.flush();
        }
    }

    public void close() throws Exception {
        if (this.printWriter != null) {
            try {
                this.printWriter.close();
            }
            catch (Exception e) {
                SupportLogger.LOGGER.logf(Logger.Level.TRACE, e, "Failed to close PrintWriter %s for file %s%n", this.printWriter, this.toFile);
            }
        }
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }
}

