/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.json.DupDetector;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.dataformat.csv.CsvMappingException;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.PackageVersion;
import com.fasterxml.jackson.dataformat.csv.impl.CsvDecoder;
import com.fasterxml.jackson.dataformat.csv.impl.CsvIOContext;
import com.fasterxml.jackson.dataformat.csv.impl.TextBuffer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CsvParser
extends ParserMinimalBase {
    private static final CsvSchema EMPTY_SCHEMA = CsvSchema.emptySchema();
    protected static final int STATE_DOC_START = 0;
    protected static final int STATE_RECORD_START = 1;
    protected static final int STATE_NEXT_ENTRY = 2;
    protected static final int STATE_NAMED_VALUE = 3;
    protected static final int STATE_UNNAMED_VALUE = 4;
    protected static final int STATE_IN_ARRAY = 5;
    protected static final int STATE_SKIP_EXTRA_COLUMNS = 6;
    protected static final int STATE_MISSING_NAME = 7;
    protected static final int STATE_MISSING_VALUE = 8;
    protected static final int STATE_DOC_END = 9;
    protected ObjectCodec _objectCodec;
    protected int _formatFeatures;
    protected CsvSchema _schema = EMPTY_SCHEMA;
    protected int _columnCount = 0;
    protected JsonReadContext _parsingContext;
    protected String _currentName;
    protected String _currentValue;
    protected int _columnIndex;
    protected int _state = 0;
    protected byte[] _binaryValue;
    protected int _arrayValueStart;
    protected String _arrayValue;
    protected String _arraySeparator;
    protected String _nullValue;
    protected final CsvDecoder _reader;
    protected final TextBuffer _textBuffer;
    protected ByteArrayBuilder _byteArrayBuilder;

    public CsvParser(CsvIOContext ctxt, int stdFeatures, int csvFeatures, ObjectCodec codec, Reader reader) {
        super(stdFeatures);
        this._objectCodec = codec;
        this._textBuffer = ctxt.csvTextBuffer();
        DupDetector dups = JsonParser.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(stdFeatures) ? DupDetector.rootDetector((JsonParser)this) : null;
        this._formatFeatures = csvFeatures;
        this._parsingContext = JsonReadContext.createRootContext((DupDetector)dups);
        this._reader = new CsvDecoder(this, ctxt, reader, this._schema, this._textBuffer, stdFeatures, csvFeatures);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return schema instanceof CsvSchema;
    }

    public void setSchema(FormatSchema schema) {
        if (schema instanceof CsvSchema) {
            String str;
            this._schema = (CsvSchema)schema;
            this._nullValue = str = this._schema.getNullValueString();
        } else if (schema == null) {
            schema = EMPTY_SCHEMA;
        } else {
            super.setSchema(schema);
        }
        this._columnCount = this._schema.size();
        this._reader.setSchema(this._schema);
    }

    public int releaseBuffered(Writer out) throws IOException {
        return this._reader.releaseBuffered(out);
    }

    public boolean isClosed() {
        return this._reader.isClosed();
    }

    public void close() throws IOException {
        this._reader.close();
    }

    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    public JsonParser overrideFormatFeatures(int values, int mask) {
        int oldF = this._formatFeatures;
        int newF = this._formatFeatures & ~mask | values & mask;
        if (oldF != newF) {
            this._formatFeatures = newF;
            this._reader.overrideFormatFeatures(newF);
        }
        return this;
    }

    public JsonParser enable(Feature f) {
        this._formatFeatures |= f.getMask();
        return this;
    }

    public JsonParser disable(Feature f) {
        this._formatFeatures &= ~f.getMask();
        return this;
    }

    public JsonParser configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public boolean isEnabled(Feature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public CsvSchema getSchema() {
        return this._schema;
    }

    public JsonStreamContext getParsingContext() {
        return this._parsingContext;
    }

    public JsonLocation getTokenLocation() {
        return this._reader.getTokenLocation();
    }

    public JsonLocation getCurrentLocation() {
        return this._reader.getCurrentLocation();
    }

    public Object getInputSource() {
        return this._reader.getInputSource();
    }

    public boolean isExpectedStartArrayToken() {
        if (this._currToken == null) {
            return false;
        }
        switch (this._currToken.id()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return false;
            }
            case 3: {
                return true;
            }
        }
        if (this._columnIndex < this._columnCount) {
            CsvSchema.Column column = this._schema.column(this._columnIndex);
            if (column.getType() == CsvSchema.ColumnType.STRING) {
                this._startArray(column);
                return true;
            }
        } else if (this._currToken == JsonToken.VALUE_STRING) {
            this._startArray(CsvSchema.Column.PLACEHOLDER);
            return true;
        }
        return false;
    }

    public String getCurrentName() throws IOException {
        return this._currentName;
    }

    public void overrideCurrentName(String name) {
        this._currentName = name;
    }

    public JsonToken nextToken() throws IOException {
        this._binaryValue = null;
        switch (this._state) {
            case 0: {
                this._currToken = this._handleStartDoc();
                return this._currToken;
            }
            case 1: {
                this._currToken = this._handleRecordStart();
                return this._currToken;
            }
            case 2: {
                this._currToken = this._handleNextEntry();
                return this._currToken;
            }
            case 3: {
                this._currToken = this._handleNamedValue();
                return this._currToken;
            }
            case 4: {
                this._currToken = this._handleUnnamedValue();
                return this._currToken;
            }
            case 5: {
                this._currToken = this._handleArrayValue();
                return this._currToken;
            }
            case 6: {
                return this._skipUntilEndOfLine();
            }
            case 7: {
                this._currToken = this._handleMissingName();
                return this._currToken;
            }
            case 8: {
                this._currToken = this._handleMissingValue();
                return this._currToken;
            }
            case 9: {
                this._reader.close();
                if (this._parsingContext.inRoot()) {
                    return null;
                }
                boolean inArray = this._parsingContext.inArray();
                this._parsingContext = this._parsingContext.getParent();
                return inArray ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
            }
        }
        throw new IllegalStateException();
    }

    public boolean nextFieldName(SerializableString str) throws IOException {
        if (this._state == 2) {
            JsonToken t;
            this._binaryValue = null;
            this._currToken = t = this._handleNextEntry();
            if (t == JsonToken.FIELD_NAME) {
                return str.getValue().equals(this._currentName);
            }
            return false;
        }
        return this.nextToken() == JsonToken.FIELD_NAME && str.getValue().equals(this.getCurrentName());
    }

    public String nextFieldName() throws IOException {
        if (this._state == 2) {
            JsonToken t;
            this._binaryValue = null;
            this._currToken = t = this._handleNextEntry();
            if (t == JsonToken.FIELD_NAME) {
                return this._currentName;
            }
            return null;
        }
        return this.nextToken() == JsonToken.FIELD_NAME ? this.getCurrentName() : null;
    }

    public String nextTextValue() throws IOException {
        this._binaryValue = null;
        if (this._state == 3) {
            JsonToken t;
            this._currToken = t = this._handleNamedValue();
            if (t == JsonToken.VALUE_STRING) {
                return this._currentValue;
            }
        } else if (this._state == 4) {
            JsonToken t;
            this._currToken = t = this._handleUnnamedValue();
            if (t == JsonToken.VALUE_STRING) {
                return this._currentValue;
            }
        } else {
            JsonToken t = this.nextToken();
            if (t == JsonToken.VALUE_STRING) {
                return this.getText();
            }
        }
        return null;
    }

    protected void _readHeaderLine() throws IOException {
        String name;
        if (this._schema.size() > 0 && !this._schema.reordersColumns()) {
            if (this._schema.strictHeaders()) {
                String name2;
                for (CsvSchema.Column column : this._schema._columns) {
                    name2 = this._reader.nextString();
                    if (name2 == null) {
                        this._reportError(String.format("Missing header %s", column.getName()));
                        continue;
                    }
                    if (column.getName().equals(name2)) continue;
                    this._reportError(String.format("Expected header %s, actual header %s", column.getName(), name2));
                }
                name2 = this._reader.nextString();
                if (name2 != null) {
                    this._reportError(String.format("Extra header %s", name2));
                }
            } else {
                while (this._reader.nextString() != null) {
                }
            }
            return;
        }
        CsvSchema.Builder builder = this._schema.rebuild().clearColumns();
        while ((name = this._reader.nextString()) != null) {
            CsvSchema.Column prev = this._schema.column(name = name.trim());
            if (prev != null) {
                builder.addColumn(name, prev.getType());
                continue;
            }
            builder.addColumn(name);
        }
        CsvSchema newSchema = builder.build();
        int size = newSchema.size();
        if (size < 2) {
            String first;
            String string = first = size == 0 ? "" : newSchema.columnName(0).trim();
            if (first.length() == 0) {
                this._reportCsvMappingError("Empty header line: can not bind data", new Object[0]);
            }
        }
        this.setSchema(builder.build());
    }

    protected JsonToken _handleStartDoc() throws IOException {
        this._reader.skipLeadingComments();
        if (this._schema.usesHeader()) {
            this._readHeaderLine();
            this._reader.skipLeadingComments();
        }
        if (this._schema.skipsFirstDataRow()) {
            this._reader.skipLine();
            this._reader.skipLeadingComments();
        }
        boolean wrapAsArray = Feature.WRAP_AS_ARRAY.enabledIn(this._formatFeatures);
        if (!this._reader.hasMoreInput()) {
            this._state = 9;
            if (wrapAsArray) {
                this._parsingContext = this._reader.childArrayContext(this._parsingContext);
                return JsonToken.START_ARRAY;
            }
            return null;
        }
        if (wrapAsArray) {
            this._parsingContext = this._reader.childArrayContext(this._parsingContext);
            this._state = 1;
            return JsonToken.START_ARRAY;
        }
        return this._handleRecordStart();
    }

    protected JsonToken _handleRecordStart() throws IOException {
        this._columnIndex = 0;
        if (this._columnCount == 0) {
            this._state = 4;
            this._parsingContext = this._reader.childArrayContext(this._parsingContext);
            return JsonToken.START_ARRAY;
        }
        this._parsingContext = this._reader.childObjectContext(this._parsingContext);
        this._state = 2;
        return JsonToken.START_OBJECT;
    }

    protected JsonToken _handleNextEntry() throws IOException {
        String next;
        try {
            next = this._reader.nextString();
        }
        catch (IOException e) {
            this._state = 6;
            throw e;
        }
        if (next == null) {
            if (this._columnIndex < this._columnCount) {
                return this._handleMissingColumns();
            }
            return this._handleObjectRowEnd();
        }
        this._currentValue = next;
        if (this._columnIndex >= this._columnCount) {
            return this._handleExtraColumn(next);
        }
        this._state = 3;
        this._currentName = this._schema.columnName(this._columnIndex);
        return JsonToken.FIELD_NAME;
    }

    protected JsonToken _handleNamedValue() throws IOException {
        if (this._columnIndex < this._columnCount) {
            CsvSchema.Column column = this._schema.column(this._columnIndex);
            ++this._columnIndex;
            if (column.isArray()) {
                this._startArray(column);
                return JsonToken.START_ARRAY;
            }
        }
        this._state = 2;
        if (this._nullValue != null && this._nullValue.equals(this._currentValue)) {
            return JsonToken.VALUE_NULL;
        }
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleUnnamedValue() throws IOException {
        String next = this._reader.nextString();
        if (next == null) {
            this._parsingContext = this._parsingContext.getParent();
            this._state = !this._reader.startNewLine() ? 9 : 1;
            return JsonToken.END_ARRAY;
        }
        this._currentValue = next;
        ++this._columnIndex;
        if (this._nullValue != null && this._nullValue.equals(next)) {
            return JsonToken.VALUE_NULL;
        }
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleArrayValue() throws IOException {
        int offset = this._arrayValueStart;
        if (offset < 0) {
            this._parsingContext = this._parsingContext.getParent();
            this._state = 2;
            return JsonToken.END_ARRAY;
        }
        int end = this._arrayValue.indexOf(this._arraySeparator, offset);
        if (end < 0) {
            this._arrayValueStart = end;
            if (offset == 0) {
                if (this._arrayValue.isEmpty() || this._arrayValue.trim().isEmpty()) {
                    this._parsingContext = this._parsingContext.getParent();
                    this._state = 2;
                    return JsonToken.END_ARRAY;
                }
                this._currentValue = this._arrayValue;
            } else {
                this._currentValue = this._arrayValue.substring(offset);
            }
        } else {
            this._currentValue = this._arrayValue.substring(offset, end);
            this._arrayValueStart = end + this._arraySeparator.length();
        }
        if (this.isEnabled(Feature.TRIM_SPACES)) {
            this._currentValue = this._currentValue.trim();
        }
        if (this._nullValue != null && this._nullValue.equals(this._currentValue)) {
            return JsonToken.VALUE_NULL;
        }
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleExtraColumn(String value) throws IOException {
        String next;
        String anyProp = this._schema.getAnyPropertyName();
        if (anyProp != null) {
            this._currentName = anyProp;
            this._state = 3;
            return JsonToken.FIELD_NAME;
        }
        this._currentName = null;
        if (Feature.IGNORE_TRAILING_UNMAPPABLE.enabledIn(this._formatFeatures)) {
            this._state = 6;
            return this._skipUntilEndOfLine();
        }
        this._state = 6;
        if (this._columnIndex == this._columnCount && Feature.ALLOW_TRAILING_COMMA.enabledIn(this._formatFeatures) && (value = value.trim()).isEmpty() && (next = this._reader.nextString()) == null) {
            return this._handleObjectRowEnd();
        }
        return (JsonToken)this._reportCsvMappingError("Too many entries: expected at most %d (value #%d (%d chars) \"%s\")", this._columnCount, this._columnIndex, value.length(), value);
    }

    protected JsonToken _handleMissingColumns() throws IOException {
        if (Feature.FAIL_ON_MISSING_COLUMNS.enabledIn(this._formatFeatures)) {
            this._handleObjectRowEnd();
            return (JsonToken)this._reportCsvMappingError("Not enough column values: expected %d, found %d", this._columnCount, this._columnIndex);
        }
        if (Feature.INSERT_NULLS_FOR_MISSING_COLUMNS.enabledIn(this._formatFeatures)) {
            this._state = 8;
            this._currentName = this._schema.columnName(this._columnIndex);
            this._currentValue = null;
            return JsonToken.FIELD_NAME;
        }
        return this._handleObjectRowEnd();
    }

    protected JsonToken _handleMissingName() throws IOException {
        if (++this._columnIndex < this._columnCount) {
            this._state = 8;
            this._currentName = this._schema.columnName(this._columnIndex);
            return JsonToken.FIELD_NAME;
        }
        return this._handleObjectRowEnd();
    }

    protected JsonToken _handleMissingValue() throws IOException {
        this._state = 7;
        return JsonToken.VALUE_NULL;
    }

    protected final JsonToken _handleObjectRowEnd() throws IOException {
        this._parsingContext = this._parsingContext.getParent();
        this._state = !this._reader.startNewLine() ? 9 : 1;
        return JsonToken.END_OBJECT;
    }

    protected final JsonToken _skipUntilEndOfLine() throws IOException {
        while (this._reader.nextString() != null) {
        }
        this._parsingContext = this._parsingContext.getParent();
        this._state = this._reader.startNewLine() ? 1 : 9;
        this._currToken = this._parsingContext.inArray() ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
        return this._currToken;
    }

    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return false;
        }
        return this._textBuffer.hasTextAsCharacters();
    }

    public String getText() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._currentName;
        }
        return this._currentValue;
    }

    public char[] getTextCharacters() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._currentName.toCharArray();
        }
        return this._textBuffer.contentsAsArray();
    }

    public int getTextLength() throws IOException {
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._currentName.length();
        }
        return this._textBuffer.size();
    }

    public int getTextOffset() throws IOException {
        return 0;
    }

    public int getText(Writer w) throws IOException {
        String value;
        String string = value = this._currToken == JsonToken.FIELD_NAME ? this._currentName : this._currentValue;
        if (value == null) {
            return 0;
        }
        w.write(value);
        return value.length();
    }

    public Object getEmbeddedObject() throws IOException {
        return this._binaryValue;
    }

    public byte[] getBinaryValue(Base64Variant variant) throws IOException {
        if (this._binaryValue == null) {
            if (this._currToken != JsonToken.VALUE_STRING) {
                this._reportCsvMappingError("Current token (%s) not VALUE_STRING, can not access as binary", this._currToken);
            }
            ByteArrayBuilder builder = this._getByteArrayBuilder();
            this._decodeBase64(this._currentValue, builder, variant);
            this._binaryValue = builder.toByteArray();
        }
        return this._binaryValue;
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        return this._reader.getNumberType();
    }

    public Number getNumberValue() throws IOException {
        return this._reader.getNumberValue();
    }

    public int getIntValue() throws IOException {
        return this._reader.getIntValue();
    }

    public long getLongValue() throws IOException {
        return this._reader.getLongValue();
    }

    public BigInteger getBigIntegerValue() throws IOException {
        return this._reader.getBigIntegerValue();
    }

    public float getFloatValue() throws IOException {
        return this._reader.getFloatValue();
    }

    public double getDoubleValue() throws IOException {
        return this._reader.getDoubleValue();
    }

    public BigDecimal getDecimalValue() throws IOException {
        return this._reader.getDecimalValue();
    }

    protected void _handleEOF() throws JsonParseException {
        this._reportInvalidEOF(": expected closing quote character", null);
    }

    public <T> T _reportCsvMappingError(String msg, Object ... args) throws JsonProcessingException {
        if (args.length > 0) {
            msg = String.format(msg, args);
        }
        throw CsvMappingException.from(this, msg, this._schema);
    }

    public void _reportParsingError(String msg) throws JsonProcessingException {
        super._reportError(msg);
    }

    public void _reportUnexpectedCsvChar(int ch, String msg) throws JsonProcessingException {
        super._reportUnexpectedChar(ch, msg);
    }

    public ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected void _startArray(CsvSchema.Column column) {
        this._currToken = JsonToken.START_ARRAY;
        this._parsingContext = this._parsingContext.createChildArrayContext(this._reader.getCurrentRow(), this._reader.getCurrentColumn());
        this._state = 5;
        this._arrayValueStart = 0;
        this._arrayValue = this._currentValue;
        String sep = column.getArrayElementSeparator();
        if (sep.isEmpty()) {
            sep = this._schema.getArrayElementSeparator();
        }
        this._arraySeparator = sep;
    }

    public static enum Feature implements FormatFeature
    {
        TRIM_SPACES(false),
        WRAP_AS_ARRAY(false),
        IGNORE_TRAILING_UNMAPPABLE(false),
        SKIP_EMPTY_LINES(false),
        ALLOW_TRAILING_COMMA(true),
        FAIL_ON_MISSING_COLUMNS(false),
        INSERT_NULLS_FOR_MISSING_COLUMNS(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

