/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import org.jboss.marshalling.ByteOutput;

public class ByteBufferOutput
extends OutputStream
implements ByteOutput {
    private final ByteBuffer buffer;

    private static EOFException writePastEnd() {
        return new EOFException("Write past end of buffer");
    }

    private static IOException readOnlyBuffer() {
        return new IOException("Read only buffer");
    }

    public ByteBufferOutput(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.buffer.put((byte)b);
        }
        catch (BufferOverflowException e) {
            throw ByteBufferOutput.writePastEnd();
        }
        catch (ReadOnlyBufferException e) {
            throw ByteBufferOutput.readOnlyBuffer();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.buffer.put(b);
        }
        catch (BufferOverflowException e) {
            throw ByteBufferOutput.writePastEnd();
        }
        catch (ReadOnlyBufferException e) {
            throw ByteBufferOutput.readOnlyBuffer();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.buffer.put(b, off, len);
        }
        catch (BufferOverflowException e) {
            throw ByteBufferOutput.writePastEnd();
        }
        catch (ReadOnlyBufferException e) {
            throw ByteBufferOutput.readOnlyBuffer();
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }
}

