/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import com.mongodb.AggregationOutput;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mongojack.JacksonDBCollection;

public class AggregationResult<T> {
    private AggregationOutput output;
    private List<T> results;
    private JacksonDBCollection<?, ?> collection;
    private Class<T> resultType;

    public AggregationResult(JacksonDBCollection<?, ?> collection, AggregationOutput output, Class<T> resultType) {
        this.output = output;
        this.collection = collection;
        this.resultType = resultType;
    }

    public AggregationOutput getAggregationOutput() {
        return this.output;
    }

    public List<T> results() {
        if (this.results == null) {
            this.results = new ArrayList<T>();
            Iterable iterable = this.output.results();
            Iterator iter = iterable.iterator();
            while (iter.hasNext()) {
                this.results.add(this.collection.convertFromDbObject((DBObject)iter.next(), this.resultType));
            }
        }
        return this.results;
    }
}

