/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import com.mongodb.BasicDBObject;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.internal.query.QueryCondition;

public class DBCursor<T>
extends DBQuery.AbstractBuilder<DBCursor<T>>
implements Iterator<T>,
Iterable<T> {
    private final com.mongodb.DBCursor cursor;
    private final JacksonDBCollection<T, ?> jacksonDBCollection;
    private T current;
    private final List<T> all = new ArrayList<T>();
    private boolean executed;

    public DBCursor(JacksonDBCollection<T, ?> jacksonDBCollection, com.mongodb.DBCursor cursor) {
        this.jacksonDBCollection = jacksonDBCollection;
        this.cursor = cursor;
        if (jacksonDBCollection.isEnabled(JacksonDBCollection.Feature.USE_STREAM_DESERIALIZATION)) {
            this.cursor.setDecoderFactory(jacksonDBCollection.getDecoderFactory());
        }
    }

    public DBCursor<T> copy() {
        return new DBCursor<T>(this.jacksonDBCollection, this.cursor.copy());
    }

    @Override
    public Iterator<T> iterator() {
        return this.copy();
    }

    public DBCursor<T> sort(DBObject orderBy) {
        this.cursor.sort(orderBy);
        return this;
    }

    public DBCursor<T> addSpecial(String name, Object o) {
        this.cursor.addSpecial(name, o);
        return this;
    }

    public DBCursor<T> hint(DBObject indexKeys) {
        this.cursor.hint(indexKeys);
        return this;
    }

    public DBCursor<T> hint(String indexName) {
        this.cursor.hint(indexName);
        return this;
    }

    public DBCursor<T> snapshot() {
        this.cursor.snapshot();
        return this;
    }

    public DBObject explain() {
        return this.cursor.explain();
    }

    public DBCursor<T> limit(int n) {
        this.cursor.limit(n);
        return this;
    }

    public DBCursor<T> batchSize(int n) {
        this.cursor.batchSize(n);
        return this;
    }

    public DBCursor<T> skip(int n) {
        this.cursor.skip(n);
        return this;
    }

    public long getCursorId() {
        return this.cursor.getCursorId();
    }

    public void close() {
        this.cursor.close();
    }

    public DBCursor<T> addOption(int option) {
        this.cursor.addOption(option);
        return this;
    }

    public DBCursor<T> setOptions(int options) {
        this.cursor.setOptions(options);
        return this;
    }

    public DBCursor<T> resetOptions() {
        this.cursor.resetOptions();
        return this;
    }

    public int getOptions() {
        return this.cursor.getOptions();
    }

    @Deprecated
    public int numGetMores() {
        return this.cursor.numGetMores();
    }

    @Deprecated
    public List<Integer> getSizes() {
        return this.cursor.getSizes();
    }

    public int numSeen() {
        return this.cursor.numSeen();
    }

    @Override
    public boolean hasNext() throws MongoException {
        this.executed();
        return this.cursor.hasNext();
    }

    @Override
    public T next() throws MongoException {
        this.executed();
        this.current = this.jacksonDBCollection.convertFromDbObject(this.cursor.next());
        return this.current;
    }

    public T curr() {
        this.cursor.curr();
        return this.current;
    }

    @Override
    public void remove() {
        this.cursor.remove();
    }

    public int length() throws MongoException {
        this.executed();
        return this.cursor.length();
    }

    public List<T> toArray() throws MongoException {
        this.executed();
        return this.toArray(Integer.MAX_VALUE);
    }

    public List<T> toArray(int max) throws MongoException {
        this.executed();
        if (max > this.all.size()) {
            List objects = this.cursor.toArray(max);
            for (int i = this.all.size(); i < objects.size(); ++i) {
                this.all.add(this.jacksonDBCollection.convertFromDbObject((DBObject)objects.get(i)));
            }
        }
        return this.all;
    }

    public int itcount() {
        this.executed();
        return this.cursor.itcount();
    }

    public int count() {
        this.executed();
        return this.cursor.count();
    }

    public int size() {
        this.executed();
        return this.cursor.size();
    }

    public DBObject getKeysWanted() {
        return this.cursor.getKeysWanted();
    }

    public DBObject getQuery() {
        return this.cursor.getQuery();
    }

    public JacksonDBCollection getCollection() {
        return this.jacksonDBCollection;
    }

    public ServerAddress getServerAddress() {
        return this.cursor.getServerAddress();
    }

    public DBCursor<T> setReadPreference(ReadPreference preference) {
        this.cursor.setReadPreference(preference);
        return this;
    }

    public ReadPreference getReadPreference() {
        return this.cursor.getReadPreference();
    }

    public DBCursor<T> setDecoderFactory(DBDecoderFactory fact) {
        this.cursor.setDecoderFactory(fact);
        return this;
    }

    public DBDecoderFactory getDecoderFactory() {
        return this.cursor.getDecoderFactory();
    }

    public com.mongodb.DBCursor getCursor() {
        return this.cursor;
    }

    private void executed() {
        this.executed = true;
    }

    private void checkExecuted() {
        if (this.executed) {
            throw new MongoException("Cannot modify query after it's been executed");
        }
    }

    @Override
    protected DBCursor<T> put(String op, QueryCondition value) {
        this.checkExecuted();
        this.cursor.getQuery().put(op, this.jacksonDBCollection.serializeQueryCondition(op, value));
        return this;
    }

    @Override
    protected DBCursor<T> put(String field, String op, QueryCondition value) {
        DBObject subQuery;
        this.checkExecuted();
        Object saved = this.cursor.getQuery().get(field);
        if (!(saved instanceof DBObject)) {
            subQuery = new BasicDBObject();
            this.cursor.getQuery().put(field, (Object)subQuery);
        } else {
            subQuery = (DBObject)saved;
        }
        subQuery.put(op, this.jacksonDBCollection.serializeQueryCondition(field, value));
        return this;
    }

    @Override
    protected DBCursor<T> putGroup(String op, DBQuery.Query ... expressions) {
        this.checkExecuted();
        ArrayList<DBObject> conditions = new ArrayList<DBObject>();
        Object existing = this.cursor.getQuery().get(op);
        if (existing == null) {
            this.cursor.getQuery().put(op, conditions);
        } else if (existing instanceof List) {
            conditions.addAll((List)existing);
        } else {
            throw new IllegalStateException("Expecting collection for " + op);
        }
        for (DBQuery.Query query : expressions) {
            conditions.add(this.jacksonDBCollection.serializeQuery(query));
        }
        return this;
    }
}

