/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DBObject;
import com.mongodb.GroupCommand;
import com.mongodb.MapReduceCommand;
import com.mongodb.MongoException;
import com.mongodb.QueryBuilder;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.BSONObject;
import org.bson.types.ObjectId;
import org.mongojack.Aggregation;
import org.mongojack.AggregationResult;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBRef;
import org.mongojack.DBUpdate;
import org.mongojack.MapReduce;
import org.mongojack.MapReduceOutput;
import org.mongojack.MongoJsonMappingException;
import org.mongojack.WriteResult;
import org.mongojack.internal.FetchableDBRef;
import org.mongojack.internal.JacksonCollectionKey;
import org.mongojack.internal.MongoJackModule;
import org.mongojack.internal.object.BsonObjectGenerator;
import org.mongojack.internal.object.BsonObjectTraversingParser;
import org.mongojack.internal.query.QueryCondition;
import org.mongojack.internal.stream.JacksonDBObject;
import org.mongojack.internal.stream.JacksonDecoderFactory;
import org.mongojack.internal.stream.JacksonEncoderFactory;
import org.mongojack.internal.util.IdHandler;
import org.mongojack.internal.util.IdHandlerFactory;
import org.mongojack.internal.util.SerializationUtils;

public class JacksonDBCollection<T, K> {
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = MongoJackModule.configure(new ObjectMapper());
    private final DBCollection dbCollection;
    private final JavaType type;
    private final JavaType keyType;
    private final ObjectMapper objectMapper;
    private final Class<?> view;
    private final IdHandler<K, Object> idHandler;
    private final JacksonDecoderFactory<T> decoderFactory;
    private final Map<Feature, Boolean> features;
    private final Map<JacksonCollectionKey, JacksonDBCollection> referencedCollectionCache = new ConcurrentHashMap<JacksonCollectionKey, JacksonDBCollection>();

    protected JacksonDBCollection(DBCollection dbCollection, JavaType type, JavaType keyType, ObjectMapper objectMapper, Class<?> view, Map<Feature, Boolean> features) {
        this.dbCollection = dbCollection;
        this.type = type;
        this.keyType = keyType;
        this.objectMapper = objectMapper;
        this.view = view;
        this.decoderFactory = new JacksonDecoderFactory(this, objectMapper, type);
        try {
            this.idHandler = IdHandlerFactory.getIdHandlerForProperty(objectMapper, type);
        }
        catch (JsonMappingException e) {
            throw new MongoJsonMappingException("Unable to introspect class", e);
        }
        this.features = features == null ? new ConcurrentHashMap<Feature, Boolean>() : features;
        dbCollection.setDBEncoderFactory((DBEncoderFactory)new JacksonEncoderFactory(objectMapper, this));
    }

    public static <T> JacksonDBCollection<T, Object> wrap(DBCollection dbCollection, Class<T> type) {
        return new JacksonDBCollection(dbCollection, DEFAULT_OBJECT_MAPPER.constructType(type), DEFAULT_OBJECT_MAPPER.constructType(Object.class), DEFAULT_OBJECT_MAPPER, null, null);
    }

    public static <T, K> JacksonDBCollection<T, K> wrap(DBCollection dbCollection, Class<T> type, Class<K> keyType) {
        return new JacksonDBCollection<T, K>(dbCollection, DEFAULT_OBJECT_MAPPER.constructType(type), DEFAULT_OBJECT_MAPPER.constructType(keyType), DEFAULT_OBJECT_MAPPER, null, null);
    }

    public static <T, K> JacksonDBCollection<T, K> wrap(DBCollection dbCollection, Class<T> type, Class<K> keyType, Class<?> view) {
        ObjectMapper objectMapper = new ObjectMapper();
        MongoJackModule.configure(objectMapper);
        return new JacksonDBCollection<T, K>(dbCollection, DEFAULT_OBJECT_MAPPER.constructType(type), DEFAULT_OBJECT_MAPPER.constructType(keyType), objectMapper, view, null);
    }

    public static <T, K> JacksonDBCollection<T, K> wrap(DBCollection dbCollection, Class<T> type, Class<K> keyType, ObjectMapper objectMapper) {
        return new JacksonDBCollection<T, K>(dbCollection, objectMapper.constructType(type), objectMapper.constructType(keyType), objectMapper, null, null);
    }

    public JacksonDBCollection<T, K> enable(Feature feature) {
        this.features.put(feature, true);
        return this;
    }

    public JacksonDBCollection<T, K> disable(Feature feature) {
        this.features.put(feature, false);
        return this;
    }

    public boolean isEnabled(Feature feature) {
        Boolean enabled = this.features.get((Object)feature);
        if (enabled == null) {
            return feature.isEnabledByDefault();
        }
        return enabled;
    }

    public DBCollection getDbCollection() {
        return this.dbCollection;
    }

    public WriteResult<T, K> insert(T object) throws MongoException {
        DBObject dbObject = this.convertToDbObject(object);
        return new WriteResult(this, this.dbCollection.insert(new DBObject[]{dbObject}), dbObject);
    }

    public WriteResult<T, K> insert(T object, WriteConcern concern) throws MongoException {
        DBObject dbObject = this.convertToDbObject(object);
        return new WriteResult(this, this.dbCollection.insert(dbObject, concern), dbObject);
    }

    public WriteResult<T, K> insert(T ... objects) throws MongoException {
        DBObject[] dbObjects = this.convertToDbObjects(objects);
        return new WriteResult(this, this.dbCollection.insert(dbObjects), dbObjects);
    }

    public WriteResult<T, K> insert(WriteConcern concern, T ... objects) throws MongoException {
        DBObject[] dbObjects = this.convertToDbObjects(objects);
        return new WriteResult(this, this.dbCollection.insert(concern, dbObjects), dbObjects);
    }

    public WriteResult<T, K> insert(List<T> list) throws MongoException {
        return this.insert(list.toArray(new Object[list.size()]));
    }

    public WriteResult<T, K> insert(List<T> list, WriteConcern concern) throws MongoException {
        return this.insert(concern, list.toArray(new Object[list.size()]));
    }

    public WriteResult<T, K> update(DBObject query, DBObject object, boolean upsert, boolean multi, WriteConcern concern) throws MongoException {
        return new WriteResult(this, this.dbCollection.update(this.serializeFields(query), object, upsert, multi, concern), new DBObject[0]);
    }

    public WriteResult<T, K> update(DBQuery.Query query, DBUpdate.Builder update, boolean upsert, boolean multi, WriteConcern concern) throws MongoException {
        return new WriteResult(this, this.dbCollection.update(this.serializeQuery(query), update.serialiseAndGet(this.objectMapper, this.type), upsert, multi, concern), new DBObject[0]);
    }

    public WriteResult<T, K> update(DBQuery.Query query, T object, boolean upsert, boolean multi, WriteConcern concern) throws MongoException {
        return new WriteResult(this, this.dbCollection.update(this.serializeQuery(query), this.convertToBasicDbObject(object), upsert, multi, concern), new DBObject[0]);
    }

    public WriteResult<T, K> update(DBObject query, DBObject object, boolean upsert, boolean multi) throws MongoException {
        return this.update(query, object, upsert, multi, this.getWriteConcern());
    }

    public WriteResult<T, K> update(DBQuery.Query query, DBUpdate.Builder update, boolean upsert, boolean multi) throws MongoException {
        return this.update(query, (T)update, upsert, multi, this.getWriteConcern());
    }

    public WriteResult<T, K> update(DBQuery.Query query, T object, boolean upsert, boolean multi) throws MongoException {
        return this.update(query, object, upsert, multi, this.getWriteConcern());
    }

    public WriteResult<T, K> update(DBObject query, DBObject object) throws MongoException {
        return this.update(query, object, false, false);
    }

    public WriteResult<T, K> update(DBQuery.Query query, DBUpdate.Builder update) throws MongoException {
        return this.update(query, (T)update, false, false);
    }

    public WriteResult<T, K> update(DBQuery.Query query, T object) throws MongoException {
        return this.update(query, object, false, false);
    }

    public WriteResult<T, K> updateById(K id, T object) throws MongoException {
        return this.update(this.createIdQuery(id), this.convertToDbObject(object), false, false);
    }

    public WriteResult<T, K> updateById(K id, DBUpdate.Builder update) throws MongoException {
        return this.update(this.createIdQuery(id), update.serialiseAndGet(this.objectMapper, this.type));
    }

    public WriteResult<T, K> updateMulti(DBObject query, DBObject object) throws MongoException {
        return this.update(query, object, false, true);
    }

    public WriteResult<T, K> updateMulti(DBQuery.Query query, DBUpdate.Builder update) throws MongoException {
        return this.update(query, (T)update, false, true);
    }

    public WriteResult<T, K> updateMulti(DBQuery.Query query, T object) throws MongoException {
        return this.update(query, object, false, true);
    }

    public WriteResult<T, K> remove(DBObject query, WriteConcern concern) throws MongoException {
        return new WriteResult(this, this.dbCollection.remove(this.serializeFields(query), concern), new DBObject[0]);
    }

    public WriteResult<T, K> remove(DBQuery.Query query, WriteConcern concern) throws MongoException {
        return new WriteResult(this, this.dbCollection.remove(this.serializeQuery(query), concern), new DBObject[0]);
    }

    public WriteResult<T, K> remove(DBObject query) throws MongoException {
        return new WriteResult(this, this.dbCollection.remove(this.serializeFields(query)), new DBObject[0]);
    }

    public WriteResult<T, K> remove(DBQuery.Query query) throws MongoException {
        return new WriteResult(this, this.dbCollection.remove(this.serializeQuery(query)), new DBObject[0]);
    }

    public WriteResult<T, K> removeById(K id) throws MongoException {
        return new WriteResult(this, this.dbCollection.remove(this.createIdQuery(id)), new DBObject[0]);
    }

    public T findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert) {
        return this.convertFromDbObject(this.dbCollection.findAndModify(this.serializeFields(query), fields, sort, remove, update, returnNew, upsert));
    }

    public T findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, T update, boolean returnNew, boolean upsert) {
        return this.convertFromDbObject(this.dbCollection.findAndModify(this.serializeFields(query), fields, sort, remove, this.convertToBasicDbObject(update), returnNew, upsert));
    }

    public T findAndModify(DBQuery.Query query, DBObject fields, DBObject sort, boolean remove, T update, boolean returnNew, boolean upsert) {
        return this.convertFromDbObject(this.dbCollection.findAndModify(this.serializeQuery(query), fields, sort, remove, this.convertToBasicDbObject(update), returnNew, upsert));
    }

    public T findAndModify(DBQuery.Query query, DBObject fields, DBObject sort, boolean remove, DBUpdate.Builder update, boolean returnNew, boolean upsert) {
        return this.convertFromDbObject(this.dbCollection.findAndModify(this.serializeQuery(query), fields, sort, remove, update.serialiseAndGet(this.objectMapper, this.type), returnNew, upsert));
    }

    public T findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBUpdate.Builder update, boolean returnNew, boolean upsert) {
        return this.convertFromDbObject(this.dbCollection.findAndModify(this.serializeFields(query), fields, sort, remove, update.serialiseAndGet(this.objectMapper, this.type), returnNew, upsert));
    }

    public T findAndModify(DBObject query, DBObject sort, DBObject update) {
        return (T)this.findAndModify(query, null, sort, false, (T)update, false, false);
    }

    public T findAndModify(DBObject query, DBObject sort, DBUpdate.Builder update) {
        return this.findAndModify(query, (DBObject)null, sort, false, update, false, false);
    }

    public T findAndModify(DBQuery.Query query, DBObject sort, DBUpdate.Builder update) {
        return this.findAndModify(query, (DBObject)null, sort, false, update, false, false);
    }

    public T findAndModify(DBObject query, DBObject update) {
        return (T)this.findAndModify(query, null, null, false, (T)update, false, false);
    }

    public T findAndModify(DBObject query, DBUpdate.Builder update) {
        return this.findAndModify(query, (DBObject)null, (DBObject)null, false, update, false, false);
    }

    public T findAndModify(DBQuery.Query query, DBUpdate.Builder update) {
        return this.findAndModify(query, (DBObject)null, (DBObject)null, false, update, false, false);
    }

    public T findAndRemove(DBObject query) {
        return (T)this.findAndModify(query, null, null, true, new BasicDBObject(), false, false);
    }

    public T findAndRemove(DBQuery.Query query) {
        return (T)this.findAndModify(this.serializeQuery(query), null, null, true, new BasicDBObject(), false, false);
    }

    public void createIndex(DBObject keys) throws MongoException {
        this.dbCollection.createIndex(keys);
    }

    public void createIndex(DBObject keys, DBObject options) throws MongoException {
        this.dbCollection.createIndex(keys, options);
    }

    @Deprecated
    public void ensureIndex(String name) {
        this.ensureIndex((DBObject)new BasicDBObject(name, (Object)1));
    }

    @Deprecated
    public void ensureIndex(DBObject keys) throws MongoException {
        this.dbCollection.createIndex(keys);
    }

    @Deprecated
    public void ensureIndex(DBObject keys, String name) throws MongoException {
        this.ensureIndex(keys, name, false);
    }

    @Deprecated
    public void ensureIndex(DBObject keys, String name, boolean unique) throws MongoException {
        this.dbCollection.createIndex(keys, name, unique);
    }

    @Deprecated
    public void ensureIndex(DBObject keys, DBObject optionsIN) throws MongoException {
        this.dbCollection.createIndex(keys, optionsIN);
    }

    @Deprecated
    public void resetIndexCache() {
        this.dbCollection.resetIndexCache();
    }

    public void setHintFields(List<DBObject> lst) {
        this.dbCollection.setHintFields(lst);
    }

    public DBCursor<T> find(DBObject query) throws MongoException {
        return new DBCursor(this, this.dbCollection.find(this.serializeFields(query)));
    }

    public DBCursor<T> find(DBQuery.Query query) throws MongoException {
        return new DBCursor(this, this.dbCollection.find(this.serializeQuery(query)));
    }

    public DBCursor<T> find(DBObject query, DBObject keys) {
        return new DBCursor(this, this.dbCollection.find(this.serializeFields(query), keys));
    }

    public DBCursor<T> find(DBQuery.Query query, DBObject keys) {
        return new DBCursor(this, this.dbCollection.find(this.serializeQuery(query), keys));
    }

    public DBCursor<T> find() throws MongoException {
        return new DBCursor(this, this.dbCollection.find());
    }

    public T findOne() throws MongoException {
        return this.findOne((DBObject)new BasicDBObject());
    }

    public T findOneById(K id) throws MongoException {
        return (T)this.findOneById(id, (T)null);
    }

    public T findOneById(K id, DBObject fields) throws MongoException {
        return this.findOne(this.createIdQuery(id), fields);
    }

    public T findOneById(K id, T fields) throws MongoException {
        return (T)this.findOneById(id, (T)this.convertToBasicDbObject(fields));
    }

    public T findOne(DBObject query) throws MongoException {
        return this.findOne(query, null);
    }

    public T findOne(DBQuery.Query query) throws MongoException {
        return this.findOne(query, null);
    }

    public T findOne(DBObject query, DBObject fields) {
        return this.findOne(query, fields, this.getReadPreference());
    }

    public T findOne(DBQuery.Query query, DBObject fields) {
        return this.findOne(query, fields, this.getReadPreference());
    }

    public T findOne(DBObject query, DBObject fields, ReadPreference readPref) {
        DBCursor<T> cursor = this.find(query, fields).setReadPreference(readPref);
        if (cursor.hasNext()) {
            return cursor.next();
        }
        return null;
    }

    public T findOne(DBQuery.Query query, DBObject fields, ReadPreference readPref) {
        DBCursor<T> cursor = this.find(query, fields).setReadPreference(readPref);
        if (cursor.hasNext()) {
            return cursor.next();
        }
        return null;
    }

    public <R, RK> List<R> fetch(Collection<DBRef<R, RK>> collection) {
        return this.fetch(collection, null);
    }

    public <R, RK> List<R> fetch(Collection<DBRef<R, RK>> collection, DBObject fields) {
        HashMap<JacksonCollectionKey, ArrayList<Object>> collectionsToIds = new HashMap<JacksonCollectionKey, ArrayList<Object>>();
        for (DBRef<R, RK> ref : collection) {
            if (!(ref instanceof FetchableDBRef)) continue;
            JacksonCollectionKey key = ((FetchableDBRef)ref).getCollectionKey();
            ArrayList<Object> ids = (ArrayList<Object>)collectionsToIds.get(key);
            if (ids == null) {
                ids = new ArrayList<Object>();
                collectionsToIds.put(key, ids);
            }
            ids.add(this.getReferenceCollection(key).convertToDbId(ref.getId()));
        }
        ArrayList<T> results = new ArrayList<T>();
        for (Map.Entry entry : collectionsToIds.entrySet()) {
            for (T result : this.getReferenceCollection((JacksonCollectionKey)entry.getKey()).find(new QueryBuilder().put("_id").in(entry.getValue()).get(), fields)) {
                results.add(result);
            }
        }
        return results;
    }

    public WriteResult<T, K> save(T object) {
        return this.save(object, this.getWriteConcern());
    }

    public WriteResult<T, K> save(T object, WriteConcern concern) throws MongoException {
        DBObject dbObject = this.convertToDbObject(object);
        return new WriteResult(this, this.dbCollection.save(dbObject, concern), dbObject);
    }

    public void dropIndexes() throws MongoException {
        this.dropIndexes("*");
    }

    public void dropIndexes(String name) throws MongoException {
        this.dbCollection.dropIndexes(name);
    }

    public void drop() throws MongoException {
        this.dbCollection.drop();
    }

    public long count() throws MongoException {
        return this.getCount((DBObject)new BasicDBObject(), null);
    }

    public long count(DBObject query) throws MongoException {
        return this.getCount(query, null);
    }

    public long getCount() throws MongoException {
        return this.getCount((DBObject)new BasicDBObject(), null);
    }

    public long getCount(DBObject query) throws MongoException {
        return this.getCount(query, null);
    }

    public long getCount(DBQuery.Query query) throws MongoException {
        return this.getCount(query, null);
    }

    public long getCount(DBObject query, DBObject fields) throws MongoException {
        return this.getCount(query, fields, 0L, 0L);
    }

    public long getCount(DBQuery.Query query, DBObject fields) throws MongoException {
        return this.getCount(query, fields, 0L, 0L);
    }

    public long getCount(DBObject query, DBObject fields, long limit, long skip) throws MongoException {
        return this.dbCollection.getCount(this.serializeFields(query), fields, limit, skip);
    }

    public long getCount(DBQuery.Query query, DBObject fields, long limit, long skip) throws MongoException {
        return this.dbCollection.getCount(this.serializeQuery(query), fields, limit, skip);
    }

    public JacksonDBCollection<T, K> rename(String newName) throws MongoException {
        return this.rename(newName, false);
    }

    public JacksonDBCollection<T, K> rename(String newName, boolean dropTarget) throws MongoException {
        return new JacksonDBCollection<T, K>(this.dbCollection.rename(newName, dropTarget), this.type, this.keyType, this.objectMapper, null, this.features);
    }

    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce) throws MongoException {
        return this.group(key, cond, initial, reduce, null);
    }

    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce, String finalize) throws MongoException {
        GroupCommand cmd = new GroupCommand(this.dbCollection, key, cond, initial, reduce, finalize);
        return this.group(cmd);
    }

    public DBObject group(GroupCommand cmd) {
        return this.dbCollection.group(cmd);
    }

    public List distinct(String key) {
        return this.distinct(key, (DBObject)new BasicDBObject());
    }

    public List distinct(String key, DBObject query) {
        return this.dbCollection.distinct(key, this.serializeFields(query));
    }

    @Deprecated
    public com.mongodb.MapReduceOutput mapReduce(String map, String reduce, String outputTarget, DBObject query) throws MongoException {
        return this.mapReduce(new MapReduceCommand(this.dbCollection, map, reduce, outputTarget, MapReduceCommand.OutputType.REPLACE, this.serializeFields(query)));
    }

    @Deprecated
    public com.mongodb.MapReduceOutput mapReduce(String map, String reduce, String outputTarget, MapReduceCommand.OutputType outputType, DBObject query) throws MongoException {
        return this.mapReduce(new MapReduceCommand(this.dbCollection, map, reduce, outputTarget, outputType, this.serializeFields(query)));
    }

    @Deprecated
    public com.mongodb.MapReduceOutput mapReduce(MapReduceCommand command) throws MongoException {
        return this.dbCollection.mapReduce(command);
    }

    @Deprecated
    public com.mongodb.MapReduceOutput mapReduce(DBObject command) throws MongoException {
        return this.dbCollection.mapReduce(command);
    }

    public <S, L> MapReduceOutput<S, L> mapReduce(MapReduce.MapReduceCommand<S, L> command) throws MongoException {
        return new MapReduceOutput<S, L>(this, this.dbCollection.mapReduce(command.build(this)), command.getResultType(), command.getKeyType());
    }

    public <S> AggregationResult<S> aggregate(Aggregation<S> aggregation) throws MongoException {
        ArrayList<DBObject> serializedOps = new ArrayList<DBObject>();
        for (DBObject dbObject : aggregation.getAllOps()) {
            serializedOps.add(this.serializeFields(dbObject));
        }
        return new AggregationResult<S>(this, this.dbCollection.aggregate(serializedOps), aggregation.getResultType());
    }

    public <S> AggregationResult<S> aggregate(Aggregation.Pipeline<?> pipeline, Class<S> resultType) throws MongoException {
        return new AggregationResult<S>(this, this.dbCollection.aggregate(this.serializePipeline(pipeline)), resultType);
    }

    public List<DBObject> getIndexInfo() {
        return this.dbCollection.getIndexInfo();
    }

    public void dropIndex(DBObject keys) throws MongoException {
        this.dbCollection.dropIndex(keys);
    }

    public void dropIndex(String name) throws MongoException {
        this.dbCollection.dropIndex(name);
    }

    public CommandResult getStats() {
        return this.dbCollection.getStats();
    }

    public boolean isCapped() {
        return this.dbCollection.isCapped();
    }

    public <S, L> JacksonDBCollection<S, L> getCollection(String n, Class<S> type, Class<L> keyType) {
        return JacksonDBCollection.wrap(this.getDB().getCollection(this.getName() + "." + n), type, keyType, this.objectMapper);
    }

    public String getName() {
        return this.dbCollection.getName();
    }

    public String getFullName() {
        return this.dbCollection.getFullName();
    }

    public DB getDB() {
        return this.dbCollection.getDB();
    }

    public int hashCode() {
        return this.dbCollection.hashCode();
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public String toString() {
        return this.dbCollection.toString();
    }

    public void setWriteConcern(WriteConcern concern) {
        this.dbCollection.setWriteConcern(concern);
    }

    public WriteConcern getWriteConcern() {
        return this.dbCollection.getWriteConcern();
    }

    public void setReadPreference(ReadPreference preference) {
        this.dbCollection.setReadPreference(preference);
    }

    public ReadPreference getReadPreference() {
        return this.dbCollection.getReadPreference();
    }

    public void addOption(int option) {
        this.dbCollection.addOption(option);
    }

    public void setOptions(int options) {
        this.dbCollection.setOptions(options);
    }

    public void resetOptions() {
        this.dbCollection.resetOptions();
    }

    public int getOptions() {
        return this.dbCollection.getOptions();
    }

    public JacksonCollectionKey getCollectionKey() {
        return new JacksonCollectionKey(this.getName(), this.type, this.keyType);
    }

    public <T, K> JacksonDBCollection<T, K> getReferenceCollection(String collectionName, JavaType type, JavaType keyType) {
        return this.getReferenceCollection(new JacksonCollectionKey(collectionName, type, keyType));
    }

    public <T, K> JacksonDBCollection<T, K> getReferenceCollection(JacksonCollectionKey collectionKey) {
        JacksonDBCollection<T, K> collection = this.referencedCollectionCache.get(collectionKey);
        if (collection == null) {
            collection = new JacksonDBCollection<T, K>(this.getDB().getCollection(collectionKey.getName()), collectionKey.getType(), collectionKey.getKeyType(), this.objectMapper, null, this.features);
            this.referencedCollectionCache.put(collectionKey, collection);
        }
        return collection;
    }

    JacksonDecoderFactory<T> getDecoderFactory() {
        return this.decoderFactory;
    }

    DBObject createIdQuery(K object) {
        return new BasicDBObject("_id", this.convertToDbId(object));
    }

    Object convertToDbId(K object) {
        if (object instanceof ObjectId) {
            return object;
        }
        return this.idHandler.toDbId(object);
    }

    public K convertFromDbId(Object object) {
        return this.idHandler.fromDbId(object);
    }

    DBObject convertToBasicDbObject(T object) throws MongoException {
        if (object == null) {
            return null;
        }
        BsonObjectGenerator generator = new BsonObjectGenerator();
        try {
            this.objectMapper.writeValue((JsonGenerator)generator, object);
        }
        catch (JsonMappingException e) {
            throw new MongoJsonMappingException(e);
        }
        catch (IOException e) {
            throw new MongoException("Unknown error occurred converting BSON to object", (Throwable)e);
        }
        return generator.getDBObject();
    }

    public DBObject convertToDbObject(T object) throws MongoException {
        if (object == null) {
            return null;
        }
        if (this.isEnabled(Feature.USE_STREAM_SERIALIZATION)) {
            return new JacksonDBObject<T>(object, this.view);
        }
        BsonObjectGenerator generator = new BsonObjectGenerator();
        try {
            this.objectMapper.writerWithView(this.view).writeValue((JsonGenerator)generator, object);
        }
        catch (JsonMappingException e) {
            throw new MongoJsonMappingException(e);
        }
        catch (IOException e) {
            throw new MongoException("Unknown error occurred converting BSON to object", (Throwable)e);
        }
        return generator.getDBObject();
    }

    public DBObject[] convertToDbObjects(T ... objects) throws MongoException {
        DBObject[] results = new DBObject[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            results[i] = this.convertToDbObject(objects[i]);
        }
        return results;
    }

    public T convertFromDbObject(DBObject dbObject) throws MongoException {
        if (dbObject == null) {
            return null;
        }
        if (dbObject instanceof JacksonDBObject) {
            return ((JacksonDBObject)dbObject).getObject();
        }
        try {
            return (T)this.objectMapper.readValue((JsonParser)new BsonObjectTraversingParser(this, (BSONObject)dbObject, (ObjectCodec)this.objectMapper), this.type);
        }
        catch (JsonMappingException e) {
            throw new MongoJsonMappingException(e);
        }
        catch (IOException e) {
            throw new MongoException("Unknown error occurred converting BSON to object", (Throwable)e);
        }
    }

    public <S> S convertFromDbObject(DBObject dbObject, Class<S> clazz) throws MongoException {
        if (dbObject == null) {
            return null;
        }
        if (dbObject instanceof JacksonDBObject) {
            return (S)((JacksonDBObject)dbObject).getObject();
        }
        try {
            return (S)this.objectMapper.readValue((JsonParser)new BsonObjectTraversingParser(this, (BSONObject)dbObject, (ObjectCodec)this.objectMapper), clazz);
        }
        catch (JsonMappingException e) {
            throw new MongoJsonMappingException(e);
        }
        catch (IOException e) {
            throw new MongoException("Unknown error occurred converting BSON to object", (Throwable)e);
        }
    }

    public List<T> convertFromDbObjects(DBObject ... dbObjects) throws MongoException {
        ArrayList<T> results = new ArrayList<T>(dbObjects.length);
        for (DBObject dbObject : dbObjects) {
            results.add(this.convertFromDbObject(dbObject));
        }
        return results;
    }

    public DBObject serializeFields(DBObject value) {
        return SerializationUtils.serializeFields(this.objectMapper, value);
    }

    public DBObject serializeQuery(DBQuery.Query query) {
        return SerializationUtils.serializeQuery(this.objectMapper, this.type, query);
    }

    Object serializeQueryCondition(String key, QueryCondition condition) {
        return SerializationUtils.serializeQueryCondition(this.objectMapper, this.type, key, condition);
    }

    public List<DBObject> serializePipeline(Aggregation.Pipeline<?> pipeline) {
        return SerializationUtils.serializePipeline(this.objectMapper, this.type, pipeline);
    }

    ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public static enum Feature {
        USE_STREAM_DESERIALIZATION(true),
        USE_STREAM_SERIALIZATION(false);

        private final boolean enabledByDefault;

        private Feature(boolean enabledByDefault) {
            this.enabledByDefault = enabledByDefault;
        }

        public boolean isEnabledByDefault() {
            return this.enabledByDefault;
        }
    }
}

