/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal;

import com.mongodb.DBObject;
import org.mongojack.DBRef;
import org.mongojack.JacksonDBCollection;
import org.mongojack.internal.JacksonCollectionKey;

public class FetchableDBRef<T, K>
extends DBRef<T, K> {
    private final JacksonDBCollection<T, K> dbCollection;
    private T object;

    public FetchableDBRef(K id, JacksonDBCollection<T, K> dbCollection) {
        super(id, dbCollection.getName());
        this.dbCollection = dbCollection;
    }

    @Override
    public T fetch() {
        if (this.object == null) {
            this.object = this.dbCollection.findOneById(this.getId());
        }
        return this.object;
    }

    @Override
    public T fetch(DBObject fields) {
        return (T)this.dbCollection.findOneById(this.getId(), fields);
    }

    public JacksonCollectionKey getCollectionKey() {
        return this.dbCollection.getCollectionKey();
    }
}

