/*
 * Decompiled with CFR 0.152.
 */
package org.mongojack.internal.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import org.mongojack.internal.util.IdHandler;
import org.mongojack.internal.util.JacksonAccessor;

public class IdHandlerFactory {
    public static <K> IdHandler<K, ?> getIdHandlerForProperty(ObjectMapper objectMapper, JavaType type) throws JsonMappingException {
        BeanPropertyWriter writer;
        JsonSerializer serializer;
        SettableBeanProperty property;
        JsonDeserializer deserializer = JacksonAccessor.findDeserializer(objectMapper, type);
        JsonDeserializer idDeserializer = null;
        JsonSerializer idSerializer = null;
        if (deserializer instanceof BeanDeserializer && (property = ((BeanDeserializer)deserializer).findProperty("_id")) != null) {
            idDeserializer = property.getValueDeserializer();
        }
        if ((serializer = JacksonAccessor.findValueSerializer(JacksonAccessor.getSerializerProvider(objectMapper), type)) instanceof BeanSerializerBase && (writer = JacksonAccessor.findPropertyWriter((BeanSerializerBase)serializer, "_id")) != null) {
            idSerializer = writer.getSerializer();
        }
        if (idDeserializer != null && idSerializer != null) {
            return new IdHandler.JacksonIdHandler(idSerializer, idDeserializer, objectMapper);
        }
        return new IdHandler.NoopIdHandler();
    }
}

