/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.ByteString;

public class BackupPutMapRpcCommand
extends BaseRpcCommand
implements TopologyAffectedCommand {
    public static final byte COMMAND_ID = 66;
    private CommandInvocationId commandInvocationId;
    private Map<Object, Object> map;
    private Metadata metadata;
    private long flags;
    private int topologyId;
    private long sequence;
    private InvocationContextFactory invocationContextFactory;
    private AsyncInterceptorChain interceptorChain;
    private CacheNotifier cacheNotifier;

    public BackupPutMapRpcCommand() {
        super(null);
    }

    public BackupPutMapRpcCommand(ByteString cacheName, PutMapCommand command) {
        super(cacheName);
        this.metadata = command.getMetadata();
        this.flags = command.getFlagsBitSet();
        this.topologyId = command.getTopologyId();
        this.commandInvocationId = command.getCommandInvocationId();
    }

    public BackupPutMapRpcCommand(ByteString cacheName) {
        super(cacheName);
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    public void setMap(Map<Object, Object> map) {
        this.map = map;
    }

    public CommandInvocationId getCommandInvocationId() {
        return this.commandInvocationId;
    }

    public void init(InvocationContextFactory invocationContextFactory, AsyncInterceptorChain interceptorChain, CacheNotifier cacheNotifier) {
        this.invocationContextFactory = invocationContextFactory;
        this.interceptorChain = interceptorChain;
        this.cacheNotifier = cacheNotifier;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public byte getCommandId() {
        return 66;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        MarshallUtil.marshallMap(this.map, (ObjectOutput)output);
        output.writeObject(this.metadata);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.flags));
        output.writeLong(this.sequence);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.map = MarshallUtil.unmarshallMap((ObjectInput)input, HashMap::new);
        this.metadata = (Metadata)input.readObject();
        this.flags = input.readLong();
        this.sequence = input.readLong();
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        PutMapCommand command = new PutMapCommand(this.map, this.cacheNotifier, this.metadata, this.flags, this.commandInvocationId);
        command.addFlags(FlagBitSets.SKIP_LOCKING);
        command.setValueMatcher(ValueMatcher.MATCH_ALWAYS);
        command.setTopologyId(this.topologyId);
        command.setForwarded(true);
        InvocationContext invocationContext = this.invocationContextFactory.createRemoteInvocationContextForCommand(command, this.getOrigin());
        return this.interceptorChain.invokeAsync(invocationContext, command);
    }

    @Override
    public String toString() {
        return "BackupPutMapRpcCommand{commandInvocationId=" + this.commandInvocationId + ", map=" + this.map + ", metadata=" + this.metadata + ", flags=" + EnumUtil.prettyPrintBitSet((long)this.flags, Flag.class) + ", topologyId=" + this.topologyId + ", sequence=" + this.sequence + '}';
    }

    public long getSequence() {
        return this.sequence;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }
}

