/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Map;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.marshall.NotSerializableException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.DDAsyncInterceptor;

public class IsMarshallableInterceptor
extends DDAsyncInterceptor {
    private StreamingMarshaller marshaller;
    private boolean usingAsyncStore;

    @Inject
    protected void injectMarshaller(StreamingMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Start
    protected void start() {
        this.usingAsyncStore = this.cacheConfiguration.persistence().usingAsyncStore();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (this.isUsingAsyncStore(ctx, command)) {
            this.checkMarshallable(command.getValue());
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (this.isUsingAsyncStore(ctx, command)) {
            this.checkMarshallable(command.getMap());
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        if (this.isUsingAsyncStore(ctx, command)) {
            this.checkMarshallable(command.getKey());
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        if (this.isUsingAsyncStore(ctx, command)) {
            this.checkMarshallable(command.getNewValue());
        }
        return this.invokeNext(ctx, command);
    }

    private boolean isUsingAsyncStore(InvocationContext ctx, FlagAffectedCommand command) {
        return this.usingAsyncStore && ctx.isOriginLocal() && !command.hasAnyFlag(FlagBitSets.SKIP_CACHE_STORE);
    }

    private void checkMarshallable(Object o) throws NotSerializableException {
        boolean marshallable = false;
        try {
            marshallable = this.marshaller.isMarshallable(o);
        }
        catch (Exception e) {
            this.throwNotSerializable(o, e);
        }
        if (!marshallable) {
            this.throwNotSerializable(o, null);
        }
    }

    private void throwNotSerializable(Object o, Throwable t) {
        String msg = String.format("Object of type %s expected to be marshallable", o.getClass());
        if (t == null) {
            throw new NotSerializableException(msg);
        }
        throw new NotSerializableException(msg, t);
    }

    private void checkMarshallable(Map<Object, Object> objs) throws NotSerializableException {
        for (Map.Entry<Object, Object> entry : objs.entrySet()) {
            this.checkMarshallable(entry.getKey());
            this.checkMarshallable(entry.getValue());
        }
    }
}

