/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.io.IOException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.compat.TypeConverter;
import org.infinispan.context.Flag;

public class MarshallerConverter
implements TypeConverter<Object, Object, Object, Object> {
    private final StreamingMarshaller marshaller;
    private final boolean convertAll;

    public MarshallerConverter(StreamingMarshaller marshaller, boolean convertAll) {
        this.marshaller = marshaller;
        this.convertAll = convertAll;
    }

    @Override
    public Object unboxKey(Object key) {
        try {
            return key instanceof WrappedByteArray ? this.marshaller.objectFromByteBuffer(((WrappedByteArray)key).getBytes()) : key;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public Object unboxValue(Object value) {
        return this.unboxKey(value);
    }

    @Override
    public Object boxKey(Object target) {
        if (target == null || !this.convertAll && MarshallerConverter.isTypeExcluded(target.getClass())) {
            return target;
        }
        try {
            return new WrappedByteArray(this.marshaller.objectToByteBuffer(target));
        }
        catch (IOException | InterruptedException e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public Object boxValue(Object target) {
        return this.boxKey(target);
    }

    @Override
    public boolean supportsInvocation(Flag flag) {
        return false;
    }

    @Override
    public void setMarshaller(Marshaller marshaller) {
    }

    public static boolean isTypeExcluded(Class<?> type) {
        return type.equals(String.class) || type.isPrimitive() || type.equals(Boolean.class) || type.equals(Character.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Float.class) || type.equals(Double.class) || type.equals(WrappedByteArray.class);
    }
}

