/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.MarshallableTypeHints;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.marshall.jboss.ExtendedRiverUnmarshaller;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.marshall.core.GlobalMarshaller;
import org.infinispan.marshall.core.JBossMarshaller;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;

final class ExternalJBossMarshaller
implements StreamingMarshaller {
    final MarshallableTypeHints marshallableTypeHints = new MarshallableTypeHints();
    final JBossMarshaller marshaller;

    ExternalJBossMarshaller(GlobalMarshaller marshaller, GlobalConfiguration globalCfg) {
        this.marshaller = new JBossMarshaller(marshaller, globalCfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        BufferSizePredictor sizePredictor = this.marshallableTypeHints.getBufferSizePredictor(obj.getClass());
        int estimatedSize = sizePredictor.nextSize(obj);
        ObjectOutput jbossOut = this.marshaller.startObjectOutput(new JBossByteOutput(out), false, estimatedSize);
        try {
            jbossOut.writeObject(obj);
        }
        finally {
            this.marshaller.finishObjectOutput(jbossOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException {
        ExtendedRiverUnmarshaller jbossIn = (ExtendedRiverUnmarshaller)this.marshaller.startObjectInput(new JBossByteInput(in), false);
        try {
            Object object = jbossIn.readObject();
            return object;
        }
        finally {
            in.skipBytes(-jbossIn.getUnreadBufferedCount());
            this.marshaller.finishObjectInput((ObjectInput)jbossIn);
        }
    }

    public void start() {
        this.marshaller.start();
    }

    public void stop() {
        this.marshaller.stop();
    }

    public boolean isMarshallable(Object o) throws Exception {
        return this.marshaller.isMarshallable(o);
    }

    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant, int estimatedSize) throws IOException {
        throw new UnsupportedOperationException("No longer in use");
    }

    public void finishObjectOutput(ObjectOutput oo) {
        throw new UnsupportedOperationException("No longer in use");
    }

    public ObjectInput startObjectInput(InputStream is, boolean isReentrant) throws IOException {
        throw new UnsupportedOperationException("No longer in use");
    }

    public void finishObjectInput(ObjectInput oi) {
        throw new UnsupportedOperationException("No longer in use");
    }

    public Object objectFromInputStream(InputStream is) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("No longer in use");
    }

    public byte[] objectToByteBuffer(Object obj, int estimatedSize) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("No longer in use");
    }

    public byte[] objectToByteBuffer(Object obj) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("No longer in use");
    }

    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("No longer in use");
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("No longer in use");
    }

    public ByteBuffer objectToBuffer(Object o) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("No longer in use");
    }

    public BufferSizePredictor getBufferSizePredictor(Object o) {
        throw new UnsupportedOperationException("No longer in use");
    }

    static final class JBossByteInput
    extends InputStream
    implements ByteInput {
        final ObjectInput in;

        JBossByteInput(ObjectInput in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            try {
                return this.in.readUnsignedByte();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return -1;
            }
        }
    }

    static final class JBossByteOutput
    extends OutputStream
    implements ByteOutput {
        final ObjectOutput out;

        JBossByteOutput(ObjectOutput out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }
    }
}

