/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.function.BiConsumer;
import org.infinispan.commands.RemoteCommandsFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ExposedByteArrayOutputStream;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallableTypeHints;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.SerializeFunctionWith;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.core.BytesObjectInput;
import org.infinispan.marshall.core.BytesObjectOutput;
import org.infinispan.marshall.core.ClassIdentifiers;
import org.infinispan.marshall.core.ClassToExternalizerMap;
import org.infinispan.marshall.core.ExternalExternalizers;
import org.infinispan.marshall.core.ExternalJBossMarshaller;
import org.infinispan.marshall.core.ExternallyMarshallable;
import org.infinispan.marshall.core.InternalExternalizers;
import org.infinispan.marshall.core.Primitives;
import org.infinispan.marshall.core.StreamBytesObjectOutput;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class GlobalMarshaller
implements StreamingMarshaller {
    private static final Log log = LogFactory.getLog(GlobalMarshaller.class);
    private static final boolean trace = log.isTraceEnabled();
    static final int NOT_FOUND = -1;
    static final int ID_NULL = 0;
    static final int ID_PRIMITIVE = 1;
    static final int ID_INTERNAL = 2;
    static final int ID_EXTERNAL = 3;
    static final int ID_ANNOTATED = 4;
    static final int ID_UNKNOWN = 5;
    static final int ID_ARRAY = 6;
    static final int ID_CLASS = 7;
    static final int TYPE_MASK = 7;
    static final int ARRAY_SIZE_MASK = 192;
    static final int FLAG_SINGLE_TYPE = 8;
    static final int FLAG_COMPONENT_TYPE_MATCH = 16;
    static final int FLAG_ALL_NULL = 32;
    static final int FLAG_ARRAY_EMPTY = 0;
    static final int FLAG_ARRAY_SMALL = 64;
    static final int FLAG_ARRAY_MEDIUM = 128;
    static final int FLAG_ARRAY_LARGE = 192;
    private final MarshallableTypeHints marshallableTypeHints = new MarshallableTypeHints();
    private GlobalComponentRegistry gcr;
    private RemoteCommandsFactory cmdFactory;
    private ClassToExternalizerMap internalExts;
    private ClassToExternalizerMap.IdToExternalizerMap reverseInternalExts;
    private ClassToExternalizerMap externalExts;
    private ClassToExternalizerMap.IdToExternalizerMap reverseExternalExts;
    private ClassIdentifiers classIdentifiers;
    private Marshaller external;

    public GlobalMarshaller() {
    }

    public GlobalMarshaller(Marshaller external) {
        this.external = external;
    }

    @Inject
    public void inject(GlobalComponentRegistry gcr, RemoteCommandsFactory cmdFactory) {
        this.gcr = gcr;
        this.cmdFactory = cmdFactory;
    }

    @Start(priority=8)
    public void start() {
        this.internalExts = InternalExternalizers.load(this, this.gcr, this.cmdFactory);
        this.reverseInternalExts = this.internalExts.reverseMap(128);
        if (trace) {
            log.tracef("Internal class to externalizer ids: %s", this.internalExts);
            log.tracef("Internal reverse externalizers: %s", this.reverseInternalExts);
        }
        this.externalExts = ExternalExternalizers.load(this.gcr.getGlobalConfiguration());
        this.reverseExternalExts = this.externalExts.reverseMap();
        if (trace) {
            log.tracef("External class to externalizer ids: %s", this.externalExts);
            log.tracef("External reverse externalizers: %s", this.reverseExternalExts);
        }
        if (this.external == null) {
            this.external = this.startDefaultExternalMarshaller(this.gcr.getGlobalConfiguration());
        }
        this.classIdentifiers = ClassIdentifiers.load(this.gcr.getGlobalConfiguration());
    }

    public Marshaller startDefaultExternalMarshaller(GlobalConfiguration globalCfg) {
        ExternalJBossMarshaller marshaller = new ExternalJBossMarshaller(this, globalCfg);
        marshaller.start();
        return marshaller;
    }

    @Stop(priority=11)
    public void stop() {
        this.internalExts.clear();
        this.reverseInternalExts.clear();
        this.externalExts.clear();
        this.reverseExternalExts.clear();
        this.classIdentifiers = null;
        this.stopDefaultExternalMarshaller();
    }

    public void stopDefaultExternalMarshaller() {
        if (this.external instanceof StreamingMarshaller) {
            ((StreamingMarshaller)this.external).stop();
        }
    }

    public byte[] objectToByteBuffer(Object obj) throws IOException, InterruptedException {
        try {
            BytesObjectOutput out = this.writeObjectOutput(obj);
            return out.toBytes();
        }
        catch (NotSerializableException nse) {
            if (log.isDebugEnabled()) {
                log.debug("Object is not serializable", nse);
            }
            throw new org.infinispan.commons.marshall.NotSerializableException(nse.getMessage(), nse.getCause());
        }
    }

    private BytesObjectOutput writeObjectOutput(Object obj) throws IOException {
        BufferSizePredictor sizePredictor = this.marshallableTypeHints.getBufferSizePredictor(obj);
        BytesObjectOutput out = this.writeObjectOutput(obj, sizePredictor.nextSize(obj));
        sizePredictor.recordSize(out.pos);
        return out;
    }

    private BytesObjectOutput writeObjectOutput(Object obj, int estimatedSize) throws IOException {
        BytesObjectOutput out = new BytesObjectOutput(estimatedSize, this);
        this.writeNullableObject(obj, out);
        return out;
    }

    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        BytesObjectInput in = BytesObjectInput.from(buf, this);
        return this.objectFromObjectInput(in);
    }

    private Object objectFromObjectInput(BytesObjectInput in) throws IOException, ClassNotFoundException {
        return this.readNullableObject(in);
    }

    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant, int estimatedSize) throws IOException {
        BytesObjectOutput out = new BytesObjectOutput(estimatedSize, this);
        return new StreamBytesObjectOutput(os, out);
    }

    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        out.writeObject(obj);
    }

    public void finishObjectOutput(ObjectOutput oo) {
        try {
            oo.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object objectFromByteBuffer(byte[] bytes, int offset, int len) throws IOException, ClassNotFoundException {
        BytesObjectInput in = BytesObjectInput.from(bytes, offset, this);
        return this.objectFromObjectInput(in);
    }

    public Object objectFromInputStream(InputStream is) throws IOException, ClassNotFoundException {
        int bytesRead;
        byte[] buf;
        ExposedByteArrayOutputStream bytes;
        int len = is.available();
        if (len > 0) {
            bytes = new ExposedByteArrayOutputStream(len);
            buf = new byte[Math.min(len, 1024)];
        } else {
            bytes = new ExposedByteArrayOutputStream();
            buf = new byte[1024];
        }
        while ((bytesRead = is.read(buf, 0, buf.length)) != -1) {
            bytes.write(buf, 0, bytesRead);
        }
        return this.objectFromByteBuffer(bytes.getRawBuffer(), 0, bytes.size());
    }

    public boolean isMarshallable(Object o) throws Exception {
        Class<?> clazz = o.getClass();
        boolean containsMarshallable = this.marshallableTypeHints.isKnownMarshallable(clazz);
        if (containsMarshallable) {
            boolean marshallable = this.marshallableTypeHints.isMarshallable(clazz);
            if (trace) {
                log.tracef("Marshallable type '%s' known and is marshallable=%b", clazz.getName(), marshallable);
            }
            return marshallable;
        }
        if (this.isMarshallableCandidate(o)) {
            boolean isMarshallable = true;
            try {
                this.objectToBuffer(o);
            }
            catch (Exception e) {
                isMarshallable = false;
                throw e;
            }
            finally {
                this.marshallableTypeHints.markMarshallable(clazz, isMarshallable);
            }
            return isMarshallable;
        }
        return false;
    }

    private boolean isMarshallableCandidate(Object o) {
        return o instanceof Serializable || this.internalExts.get(o.getClass()) != null || this.externalExts.get(o.getClass()) != null || o.getClass().getAnnotation(SerializeWith.class) != null || this.isExternalMarshallable(o);
    }

    private boolean isExternalMarshallable(Object o) {
        try {
            return this.external.isMarshallable(o);
        }
        catch (Exception e) {
            throw new org.infinispan.commons.marshall.NotSerializableException("Object of type " + o.getClass() + " expected to be marshallable", (Throwable)e);
        }
    }

    public BufferSizePredictor getBufferSizePredictor(Object o) {
        return this.marshallableTypeHints.getBufferSizePredictor(o.getClass());
    }

    public ByteBuffer objectToBuffer(Object o) throws IOException, InterruptedException {
        try {
            BytesObjectOutput out = this.writeObjectOutput(o);
            return out.toByteBuffer();
        }
        catch (NotSerializableException nse) {
            if (log.isDebugEnabled()) {
                log.debug("Object is not serializable", nse);
            }
            throw new org.infinispan.commons.marshall.NotSerializableException(nse.getMessage(), nse.getCause());
        }
    }

    public byte[] objectToByteBuffer(Object obj, int estimatedSize) throws IOException, InterruptedException {
        try {
            BytesObjectOutput out = this.writeObjectOutput(obj, estimatedSize);
            return out.toBytes();
        }
        catch (NotSerializableException nse) {
            if (log.isDebugEnabled()) {
                log.debug("Object is not serializable", nse);
            }
            throw new org.infinispan.commons.marshall.NotSerializableException(nse.getMessage(), nse.getCause());
        }
    }

    public ObjectInput startObjectInput(InputStream is, boolean isReentrant) {
        throw new UnsupportedOperationException("No longer in use");
    }

    public void finishObjectInput(ObjectInput oi) {
        throw new UnsupportedOperationException("No longer in use");
    }

    public Object objectFromObjectStream(ObjectInput in) {
        throw new UnsupportedOperationException("No longer in use");
    }

    public <T> Externalizer<T> findExternalizerFor(Object obj) {
        Class<?> clazz = obj.getClass();
        Externalizer<T> ext = this.internalExts.get(clazz);
        if (ext == null && (ext = this.externalExts.get(clazz)) == null) {
            ext = this.findAnnotatedExternalizer(clazz);
        }
        return ext;
    }

    void writeNullableObject(Object obj, BytesObjectOutput out) throws IOException {
        if (obj == null) {
            out.writeByte(0);
        } else {
            this.writeNonNullableObject(obj, out);
        }
    }

    Object readNullableObject(BytesObjectInput in) throws IOException, ClassNotFoundException {
        int type = in.readUnsignedByte();
        return type == 0 ? null : this.readNonNullableObject(type, in);
    }

    BiConsumer<ObjectOutput, Object> findWriter(Object obj) {
        Class<?> clazz = obj.getClass();
        AdvancedExternalizer internalExt = this.internalExts.get(clazz);
        if (internalExt != null) {
            return (out, object) -> this.writeInternalClean(object, internalExt, (ObjectOutput)out);
        }
        AdvancedExternalizer externalExt = this.externalExts.get(clazz);
        if (externalExt != null) {
            return (out, object) -> this.writeExternalClean(object, externalExt, (ObjectOutput)out);
        }
        return null;
    }

    <T> AdvancedExternalizer<T> findExternalizerIn(ObjectInput in) throws IOException {
        int type = in.readUnsignedByte();
        switch (type) {
            case 2: {
                return this.reverseInternalExts.get(in.readUnsignedByte());
            }
            case 3: {
                return this.reverseExternalExts.get(in.readInt());
            }
        }
        return null;
    }

    private void writeNonNullableObject(Object obj, BytesObjectOutput out) throws IOException {
        Class<?> clazz = obj.getClass();
        int id = Primitives.PRIMITIVES.get(clazz, -1);
        if (id != -1) {
            this.writePrimitive(obj, out, id);
        } else if (clazz.isArray()) {
            this.writeArray(clazz, obj, out);
        } else {
            AdvancedExternalizer ext = this.internalExts.get(clazz);
            if (ext != null) {
                this.writeInternal(obj, ext, out);
            } else {
                ext = this.externalExts.get(clazz);
                if (ext != null) {
                    this.writeExternal(obj, ext, out);
                } else {
                    Externalizer annotExt = this.findAnnotatedExternalizer(clazz);
                    if (annotExt != null) {
                        this.writeAnnotated(obj, out, annotExt);
                    } else {
                        this.writeUnknown(obj, out);
                    }
                }
            }
        }
    }

    private void writeArray(Class<?> clazz, Object array, BytesObjectOutput out) throws IOException {
        AdvancedExternalizer ext;
        int flags;
        out.writeByte(6);
        Class<?> componentType = clazz.getComponentType();
        int length = Array.getLength(array);
        boolean singleType = true;
        Class<?> elementType = null;
        if (length == 0) {
            flags = 0;
        } else {
            flags = length <= 256 ? 64 : (length <= 65792 ? 128 : 192);
            Object firstElement = Array.get(array, 0);
            if (firstElement != null) {
                elementType = firstElement.getClass();
            }
            for (int i = 1; i < length; ++i) {
                Object element = Array.get(array, i);
                if (element == null) {
                    if (elementType == null) continue;
                    singleType = false;
                    break;
                }
                if (element.getClass() == elementType) continue;
                singleType = false;
                break;
            }
        }
        boolean componentTypeMatch = false;
        if (singleType) {
            flags |= 8;
            if (elementType == null) {
                flags |= 0x20;
            } else if (elementType == componentType) {
                flags |= 0x10;
                componentTypeMatch = true;
            }
        }
        if ((ext = this.internalExts.get(componentType)) != null) {
            this.writeFlagsWithExternalizer(out, componentType, componentTypeMatch, ext, flags, 2);
        } else {
            ext = this.externalExts.get(componentType);
            if (ext != null) {
                this.writeFlagsWithExternalizer(out, componentType, componentTypeMatch, ext, flags, 3);
            } else {
                componentTypeMatch = false;
                flags &= 0xFFFFFFEF;
                int classId = this.classIdentifiers.getId(componentType);
                if (classId != -1) {
                    out.writeByte(flags | 7);
                    if (classId < 255) {
                        out.writeByte(classId);
                    } else {
                        out.writeByte(255);
                        out.writeInt(classId);
                    }
                } else {
                    out.writeByte(flags | 5);
                    out.writeObject(componentType);
                }
            }
        }
        if (length != 0) {
            if (length <= 256) {
                out.writeByte(length - 1);
            } else if (length <= 65792) {
                out.writeShort(length - 257);
            } else {
                out.writeInt(length);
            }
        }
        if (singleType) {
            AdvancedExternalizer elementExt;
            if (elementType == null) {
                return;
            }
            if (componentTypeMatch) {
                elementExt = ext;
            } else {
                elementExt = this.internalExts.get(elementType);
                if (elementExt != null) {
                    out.writeByte(2);
                    out.writeByte(elementExt.getId());
                } else {
                    elementExt = this.externalExts.get(elementType);
                    if (elementExt != null) {
                        out.writeByte(3);
                        out.writeInt(((AdvancedExternalizer)elementExt).getId());
                    } else {
                        elementExt = this.findAnnotatedExternalizer(elementType);
                        if (elementExt != null) {
                            out.writeByte(4);
                            out.writeObject(elementExt.getClass());
                        } else {
                            int primitiveId = Primitives.PRIMITIVES.get(elementType, -1);
                            if (primitiveId != -1) {
                                out.writeByte(1);
                                out.writeByte(primitiveId);
                                for (int i = 0; i < length; ++i) {
                                    Object element = Array.get(array, i);
                                    assert (element != null);
                                    Primitives.writeRawPrimitive(element, out, primitiveId);
                                }
                                return;
                            }
                            out.writeByte(5);
                        }
                    }
                }
            }
            if (elementExt != null) {
                for (int i = 0; i < length; ++i) {
                    Object element = Array.get(array, i);
                    assert (element != null);
                    elementExt.writeObject((ObjectOutput)out, element);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    Object element = Array.get(array, i);
                    assert (element != null);
                    this.writeRawUnknown(element, out);
                }
            }
        } else {
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(array, i);
                this.writeNullableObject(element, out);
            }
        }
    }

    private void writeFlagsWithExternalizer(BytesObjectOutput out, Class<?> componentType, boolean componentTypeMatch, AdvancedExternalizer ext, int flags, int externalizerType) throws IOException {
        boolean hasSingleClass = ext.getTypeClasses().size() == 1;
        int classId = -1;
        if (componentTypeMatch || hasSingleClass) {
            out.writeByte(flags | externalizerType);
            switch (externalizerType) {
                case 2: {
                    out.writeByte(ext.getId());
                    break;
                }
                case 3: {
                    out.writeInt(ext.getId());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!hasSingleClass) {
                classId = this.classIdentifiers.getId(componentType);
            }
        } else {
            classId = this.classIdentifiers.getId(componentType);
            if (classId >= 0) {
                out.writeByte(flags | 7);
            } else {
                out.writeByte(flags | 5);
            }
        }
        if (!hasSingleClass) {
            if (classId < 0) {
                out.writeObject(componentType);
            } else if (classId < 255) {
                out.writeByte(classId);
            } else {
                out.writeByte(255);
                out.writeInt(classId);
            }
        }
    }

    private void writeUnknown(Object obj, BytesObjectOutput out) throws IOException {
        assert (ExternallyMarshallable.isAllowed(obj)) : "Check support for: " + obj.getClass();
        out.writeByte(5);
        this.writeRawUnknown(obj, out);
    }

    private void writeRawUnknown(Object obj, BytesObjectOutput out) throws IOException {
        if (this.external instanceof StreamingMarshaller) {
            ((StreamingMarshaller)this.external).objectToObjectStream(obj, (ObjectOutput)out);
        } else {
            try {
                byte[] bytes = this.external.objectToByteBuffer(obj);
                out.writeInt(bytes.length);
                out.write(bytes);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void writeAnnotated(Object obj, BytesObjectOutput out, Externalizer ext) throws IOException {
        out.writeByte(4);
        out.writeObject(ext.getClass());
        ext.writeObject((ObjectOutput)out, obj);
    }

    private void writeInternal(Object obj, AdvancedExternalizer ext, ObjectOutput out) throws IOException {
        out.writeByte(2);
        out.writeByte(ext.getId());
        ext.writeObject(out, obj);
    }

    private void writeInternalClean(Object obj, AdvancedExternalizer ext, ObjectOutput out) {
        try {
            this.writeInternal(obj, ext, out);
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private void writeExternal(Object obj, AdvancedExternalizer ext, ObjectOutput out) throws IOException {
        out.writeByte(3);
        out.writeInt(ext.getId());
        ext.writeObject(out, obj);
    }

    private void writeExternalClean(Object obj, AdvancedExternalizer ext, ObjectOutput out) {
        try {
            this.writeExternal(obj, ext, out);
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private void writePrimitive(Object obj, BytesObjectOutput out, int id) throws IOException {
        out.writeByte(1);
        Primitives.writePrimitive(obj, out, id);
    }

    private <T> Externalizer<T> findAnnotatedExternalizer(Class<?> clazz) {
        try {
            SerializeWith serialAnn = clazz.getAnnotation(SerializeWith.class);
            if (serialAnn != null) {
                return (Externalizer)serialAnn.value().newInstance();
            }
            SerializeFunctionWith funcSerialAnn = clazz.getAnnotation(SerializeFunctionWith.class);
            if (funcSerialAnn != null) {
                return (Externalizer)funcSerialAnn.value().newInstance();
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot instantiate externalizer for %s", clazz), e);
        }
    }

    private Object readNonNullableObject(int type, BytesObjectInput in) throws IOException, ClassNotFoundException {
        switch (type) {
            case 1: {
                return Primitives.readPrimitive(in);
            }
            case 2: {
                return this.readWithExternalizer(in.readUnsignedByte(), this.reverseInternalExts, in);
            }
            case 3: {
                return this.readWithExternalizer(in.readInt(), this.reverseExternalExts, in);
            }
            case 4: {
                return this.readAnnotated(in);
            }
            case 5: {
                return this.readUnknown(in);
            }
            case 6: {
                return this.readArray(in);
            }
        }
        throw new IOException("Unknown type: " + type);
    }

    private Object readWithExternalizer(int id, ClassToExternalizerMap.IdToExternalizerMap reverseMap, BytesObjectInput in) throws IOException, ClassNotFoundException {
        AdvancedExternalizer ext = reverseMap.get(id);
        return ext.readObject((ObjectInput)in);
    }

    private Object readAnnotated(BytesObjectInput in) throws IOException, ClassNotFoundException {
        Class clazz = (Class)in.readObject();
        try {
            Externalizer ext = (Externalizer)clazz.newInstance();
            return ext.readObject((ObjectInput)in);
        }
        catch (Exception e) {
            throw new CacheException("Error instantiating class: " + clazz, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object readArray(BytesObjectInput in) throws IOException, ClassNotFoundException {
        boolean componentTypeMatch;
        int length;
        Class<?> componentType;
        byte flags = in.readByte();
        int type = flags & 7;
        AdvancedExternalizer componentExt = null;
        Class extClazz = null;
        switch (type) {
            case 0: 
            case 1: 
            case 6: {
                throw new IOException("Unexpected component type: " + type);
            }
            case 2: {
                componentExt = this.reverseInternalExts.get(in.readByte());
                componentType = this.getOrReadClass(in, componentExt);
                break;
            }
            case 3: {
                componentExt = this.reverseExternalExts.get(in.readInt());
                componentType = this.getOrReadClass(in, componentExt);
                break;
            }
            case 4: {
                extClazz = (Class)in.readObject();
            }
            case 5: {
                componentType = (Class<?>)in.readObject();
                break;
            }
            case 7: {
                byte classId = in.readByte();
                if (classId < 255) {
                    componentType = this.classIdentifiers.getClass(classId);
                    break;
                }
                componentType = this.classIdentifiers.getClass(in.readInt());
                break;
            }
            default: {
                throw new IOException("Unknown component type: " + type);
            }
        }
        int maskedSize = flags & 0xC0;
        switch (maskedSize) {
            case 0: {
                length = 0;
                break;
            }
            case 64: {
                length = in.readUnsignedByte() + 1;
                break;
            }
            case 128: {
                length = in.readUnsignedShort() + 257;
                break;
            }
            case 192: {
                length = in.readInt();
                break;
            }
            default: {
                throw new IOException("Unknown array size: " + maskedSize);
            }
        }
        Object array = Array.newInstance(componentType, length);
        if ((flags & 0x20) != 0) {
            return array;
        }
        boolean singleType = (flags & 8) != 0;
        boolean bl = componentTypeMatch = (flags & 0x10) != 0;
        assert (!componentTypeMatch || singleType);
        if (singleType) {
            Externalizer<?> ext;
            if (componentTypeMatch) {
                ext = this.getExternalizer(type, componentExt, extClazz);
            } else {
                type = in.readByte();
                ext = this.readExternalizer(in, type);
            }
            if (ext != null) {
                for (int i = 0; i < length; ++i) {
                    Array.set(array, i, ext.readObject((ObjectInput)in));
                }
                return array;
            } else {
                switch (type) {
                    case 5: {
                        int i = 0;
                        while (true) {
                            if (i >= length) {
                                return array;
                            }
                            Array.set(array, i, this.readUnknown(in));
                            ++i;
                        }
                    }
                    case 1: {
                        byte primitiveId = in.readByte();
                        int i = 0;
                        while (i < length) {
                            Array.set(array, i, Primitives.readRawPrimitive(in, primitiveId));
                            ++i;
                        }
                        return array;
                    }
                }
                throw new IllegalStateException();
            }
        }
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, this.readNullableObject(in));
        }
        return array;
    }

    private Externalizer<?> getExternalizer(int type, AdvancedExternalizer<?> componentExt, Class<?> extClazz) throws IOException {
        switch (type) {
            case 2: 
            case 3: {
                return componentExt;
            }
            case 4: {
                try {
                    return (Externalizer)extClazz.newInstance();
                }
                catch (Exception e) {
                    throw new CacheException("Error instantiating class: " + extClazz, (Throwable)e);
                }
            }
            case 5: {
                return null;
            }
        }
        throw new IOException("Unexpected component type: " + type);
    }

    private Externalizer<?> readExternalizer(BytesObjectInput in, int type) throws ClassNotFoundException, IOException {
        switch (type) {
            case 2: {
                return this.reverseInternalExts.get(in.readByte());
            }
            case 3: {
                return this.reverseExternalExts.get(in.readInt());
            }
            case 4: {
                Class extClazz = (Class)in.readObject();
                try {
                    return (Externalizer)extClazz.newInstance();
                }
                catch (Exception e) {
                    throw new CacheException("Error instantiating class: " + extClazz, (Throwable)e);
                }
            }
            case 1: 
            case 5: {
                return null;
            }
        }
        throw new IOException("Unexpected component type: " + type);
    }

    private Class<?> getOrReadClass(BytesObjectInput in, AdvancedExternalizer<?> componentExt) throws ClassNotFoundException, IOException {
        if (componentExt.getTypeClasses().size() == 1) {
            return (Class)componentExt.getTypeClasses().iterator().next();
        }
        return (Class)in.readObject();
    }

    private Object readUnknown(BytesObjectInput in) throws IOException, ClassNotFoundException {
        if (this.external instanceof StreamingMarshaller) {
            try {
                return ((StreamingMarshaller)this.external).objectFromObjectStream((ObjectInput)in);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        int length = in.readInt();
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        return this.external.objectFromByteBuffer(bytes);
    }
}

