/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.jgroups.CustomRequestCorrelator;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.remoting.transport.jgroups.Responses;
import org.infinispan.remoting.transport.jgroups.RspListFuture;
import org.infinispan.remoting.transport.jgroups.SecurityActions;
import org.infinispan.remoting.transport.jgroups.SingleResponseFuture;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.jgroups.Address;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RspFilter;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Buffer;
import org.jgroups.util.Rsp;

public class CommandAwareRpcDispatcher
extends MessageDispatcher {
    private static final Log log = LogFactory.getLog(CommandAwareRpcDispatcher.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final boolean FORCE_MCAST = SecurityActions.getBooleanProperty("infinispan.unsafe.force_multicast");
    public static final short REPLY_FLAGS_TO_CLEAR = (short)(Message.Flag.RSVP.value() | Message.Flag.INTERNAL.value());
    public static final short REPLY_FLAGS_TO_SET = (short)(Message.Flag.NO_FC.value() | Message.Flag.OOB.value() | Message.Flag.NO_TOTAL_ORDER.value());
    private final InboundInvocationHandler handler;
    private final ScheduledExecutorService timeoutExecutor;
    private final TimeService timeService;
    private StreamingMarshaller ispnMarshaller;

    public CommandAwareRpcDispatcher(JChannel channel, JGroupsTransport transport, InboundInvocationHandler globalHandler, ScheduledExecutorService timeoutExecutor, TimeService timeService, Executor remoteExecutor, StreamingMarshaller ispnMarshaller) {
        super(channel);
        this.handler = globalHandler;
        this.timeoutExecutor = timeoutExecutor;
        this.timeService = timeService;
        this.ispnMarshaller = ispnMarshaller;
        this.setMembershipListener(transport);
        this.setChannel(channel);
        channel.addChannelListener((ChannelListener)this);
        this.asyncDispatching(true);
        this.correlator(new CustomRequestCorrelator((Protocol)this.prot_adapter, (RequestHandler)this, this.local_addr, remoteExecutor, ispnMarshaller));
    }

    public void close() {
        this.stop();
        this.channel.removeChannelListener((ChannelListener)this);
    }

    private boolean isValid(Message req) {
        if (req == null || req.getLength() == 0) {
            log.msgOrMsgBufferEmpty();
            return false;
        }
        return true;
    }

    public CompletableFuture<Responses> invokeRemoteCommands(List<Address> recipients, ReplicableCommand command, ResponseMode mode, long timeout, RspFilter filter, DeliverOrder deliverOrder) {
        try {
            CompletableFuture<Responses> future;
            if (recipients != null && recipients.size() > 1 && mode == ResponseMode.GET_FIRST) {
                future = new CompletableFuture();
                long nanoTimeout = timeout > 0L ? TimeUnit.MILLISECONDS.toNanos(timeout) : Long.MAX_VALUE;
                long deadline = this.timeService.expectedEndTime(nanoTimeout, TimeUnit.NANOSECONDS);
                this.processCallsStaggered(command, filter, recipients, mode, deliverOrder, future, 0, deadline, new Responses(recipients));
            } else {
                future = this.processCalls(command, recipients == null, timeout, filter, recipients, mode, deliverOrder);
            }
            return future;
        }
        catch (Exception e) {
            return (CompletableFuture)this.rethrowAsCacheException(e);
        }
    }

    public SingleResponseFuture invokeRemoteCommand(Address recipient, ReplicableCommand command, ResponseMode mode, long timeout, DeliverOrder deliverOrder) {
        try {
            SingleResponseFuture future = this.processSingleCall(command, timeout, recipient, mode, deliverOrder);
            return future;
        }
        catch (Exception e) {
            return (SingleResponseFuture)this.rethrowAsCacheException(e);
        }
    }

    private <T> T rethrowAsCacheException(Throwable t) {
        if (t instanceof CacheException) {
            throw (CacheException)t;
        }
        throw new CacheException(t);
    }

    public void handle(Message req, org.jgroups.blocks.Response response) throws Exception {
        block10: {
            if (this.isValid(req)) {
                ReplicableCommand cmd = null;
                try {
                    cmd = (ReplicableCommand)this.ispnMarshaller.objectFromByteBuffer(req.getRawBuffer(), req.getOffset(), req.getLength());
                    if (cmd == null) {
                        throw new NullPointerException("Unable to execute a null command!  Message was " + req);
                    }
                    if (req.getSrc() instanceof SiteAddress) {
                        this.executeCommandFromRemoteSite(cmd, req, response);
                        break block10;
                    }
                    this.executeCommandFromLocalCluster(cmd, req, response);
                }
                catch (IllegalLifecycleStateException e) {
                    if (trace) {
                        log.trace("Ignoring command unmarshalling error during shutdown");
                    }
                    this.reply(response, CacheNotFoundResponse.INSTANCE, cmd, req);
                }
                catch (Throwable x) {
                    if (cmd == null) {
                        log.errorUnMarshallingCommand(x);
                    } else {
                        log.exceptionHandlingCommand(cmd, x);
                    }
                    this.reply(response, new ExceptionResponse((Exception)((Object)new CacheException("Problems invoking command.", x))), cmd, req);
                }
            } else {
                this.reply(response, null, null, req);
            }
        }
    }

    private void executeCommandFromRemoteSite(ReplicableCommand cmd, Message req, org.jgroups.blocks.Response response) {
        SiteAddress siteAddress = (SiteAddress)req.getSrc();
        ((XSiteReplicateCommand)cmd).setOriginSite(siteAddress.getSite());
        Reply reply = returnValue -> this.reply(response, returnValue, cmd, req);
        this.handler.handleFromRemoteSite(siteAddress.getSite(), (XSiteReplicateCommand)cmd, reply, CommandAwareRpcDispatcher.decodeDeliverMode(req));
    }

    private void executeCommandFromLocalCluster(ReplicableCommand cmd, Message req, org.jgroups.blocks.Response response) {
        this.handler.handleFromCluster(JGroupsTransport.fromJGroupsAddress(req.getSrc()), cmd, returnValue -> this.reply(response, returnValue, cmd, req), CommandAwareRpcDispatcher.decodeDeliverMode(req));
    }

    private static DeliverOrder decodeDeliverMode(Message request) {
        boolean noTotalOrder = request.isFlagSet(Message.Flag.NO_TOTAL_ORDER);
        boolean oob = request.isFlagSet(Message.Flag.OOB);
        if (!noTotalOrder && oob) {
            return DeliverOrder.TOTAL;
        }
        if (noTotalOrder && oob) {
            return DeliverOrder.NONE;
        }
        if (noTotalOrder) {
            return DeliverOrder.PER_SENDER;
        }
        throw new IllegalArgumentException("Unable to decode message " + request);
    }

    private static void encodeDeliverMode(RequestOptions request, DeliverOrder deliverOrder) {
        switch (deliverOrder) {
            case TOTAL: {
                request.setFlags(Message.Flag.OOB.value());
                break;
            }
            case PER_SENDER: {
                request.setFlags(Message.Flag.NO_TOTAL_ORDER.value()).setTransientFlags(Message.TransientFlag.DONT_LOOPBACK.value());
                break;
            }
            case NONE: {
                request.setFlags((short)(Message.Flag.OOB.value() | Message.Flag.NO_TOTAL_ORDER.value())).setTransientFlags(Message.TransientFlag.DONT_LOOPBACK.value());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported deliver mode " + (Object)((Object)deliverOrder));
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[Marshaller: " + this.ispnMarshaller + "]";
    }

    private void reply(org.jgroups.blocks.Response response, Object retVal, ReplicableCommand command, Message req) {
        block9: {
            if (response != null) {
                Buffer rsp_buf;
                if (trace) {
                    log.tracef("About to send back response %s for command %s", retVal, command);
                }
                boolean is_exception = false;
                try {
                    ByteBuffer bytes = this.ispnMarshaller.objectToBuffer(retVal);
                    rsp_buf = new Buffer(bytes.getBuf(), bytes.getOffset(), bytes.getLength());
                }
                catch (Throwable t) {
                    try {
                        ByteBuffer bytes = this.ispnMarshaller.objectToBuffer((Object)t);
                        rsp_buf = new Buffer(bytes.getBuf(), bytes.getOffset(), bytes.getLength());
                        is_exception = true;
                    }
                    catch (IllegalLifecycleStateException tt) {
                        return;
                    }
                    catch (Throwable tt) {
                        log.errorMarshallingObject(tt, retVal);
                        return;
                    }
                }
                short flags = (short)(req.getFlags() | REPLY_FLAGS_TO_SET & ~REPLY_FLAGS_TO_CLEAR);
                Message rsp = req.makeReply().setFlag(flags).setBuffer(rsp_buf);
                try {
                    response.send(rsp, is_exception);
                }
                catch (Throwable t) {
                    if (!this.channel.isConnected()) break block9;
                    log.errorSendingResponse(command);
                }
            }
        }
    }

    static RequestOptions constructRequestOptions(ResponseMode mode, boolean rsvp, DeliverOrder deliverOrder, long timeout, boolean noRelay) {
        RequestOptions options = new RequestOptions(mode, timeout);
        if (noRelay) {
            options.setFlags(Message.Flag.NO_RELAY.value());
        }
        CommandAwareRpcDispatcher.encodeDeliverMode(options, deliverOrder);
        return rsvp ? options.setFlags(Message.Flag.RSVP.value()) : options;
    }

    Buffer marshallCall(ReplicableCommand command) {
        try {
            ByteBuffer bytes = this.ispnMarshaller.objectToBuffer((Object)command);
            return new Buffer(bytes.getBuf(), bytes.getOffset(), bytes.getLength());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failure to marshal argument(s)", e);
        }
    }

    protected SingleResponseFuture processSingleCall(ReplicableCommand command, long timeout, Address destination, ResponseMode mode, DeliverOrder deliverOrder) throws Exception {
        if (trace) {
            log.tracef("Replication task sending %s to single recipient %s with response mode %s", command, destination, mode);
        }
        boolean rsvp = CommandAwareRpcDispatcher.isRsvpCommand(command);
        Buffer buf = this.marshallCall(command);
        RequestOptions options = CommandAwareRpcDispatcher.constructRequestOptions(mode, rsvp, deliverOrder, timeout, true);
        CompletableFuture request = this.sendMessageWithFuture(destination, buf, options);
        if (mode == ResponseMode.GET_NONE) {
            return null;
        }
        SingleResponseFuture retval = new SingleResponseFuture(request);
        if (timeout > 0L && !retval.isDone()) {
            ScheduledFuture<Void> timeoutFuture = this.timeoutExecutor.schedule(retval, timeout, TimeUnit.MILLISECONDS);
            retval.setTimeoutFuture(timeoutFuture);
        }
        return retval;
    }

    private void processCallsStaggered(ReplicableCommand command, RspFilter filter, List<Address> dests, ResponseMode mode, DeliverOrder deliverOrder, CompletableFuture<Responses> theFuture, int destIndex, long deadline, Responses rsps) throws Exception {
        if (destIndex == dests.size()) {
            return;
        }
        Address dest = dests.get(destIndex);
        SingleResponseFuture subFuture = this.processSingleCall(command, -1L, dest, mode, deliverOrder);
        if (subFuture != null) {
            subFuture.whenComplete((rsp, throwable) -> {
                if (throwable != null) {
                    theFuture.completeExceptionally((Throwable)throwable);
                }
                rsps.addResponse(dest, (Rsp)rsp);
                if (rsp.wasReceived() && (filter == null || filter.isAcceptable(rsp.hasException() ? rsp.getException() : rsp.getValue(), dest))) {
                    if (trace) {
                        log.tracef("Got acceptable response: " + rsps, new Object[0]);
                    }
                    theFuture.complete(rsps);
                } else if (!rsps.isMissingResponses()) {
                    if (trace) {
                        log.tracef("No missing responses: " + rsps, new Object[0]);
                    }
                    theFuture.complete(rsps);
                } else {
                    this.staggeredProcessNext(command, filter, dests, mode, deliverOrder, theFuture, destIndex, deadline, rsps);
                }
            });
            if (!subFuture.isDone()) {
                long delayNanos = this.timeService.remainingTime(deadline, TimeUnit.NANOSECONDS);
                if (destIndex < dests.size() - 1) {
                    delayNanos = delayNanos / 10L / (long)dests.size();
                }
                ScheduledFuture<?> timeoutTask = this.timeoutExecutor.schedule(() -> this.staggeredProcessNext(command, filter, dests, mode, deliverOrder, theFuture, destIndex, deadline, rsps), delayNanos, TimeUnit.NANOSECONDS);
                theFuture.whenComplete((rsps1, throwable) -> timeoutTask.cancel(false));
            }
        } else {
            this.staggeredProcessNext(command, filter, dests, mode, deliverOrder, theFuture, destIndex, deadline, rsps);
        }
    }

    private void staggeredProcessNext(ReplicableCommand command, RspFilter filter, List<Address> dests, ResponseMode mode, DeliverOrder deliverOrder, CompletableFuture<Responses> theFuture, int destIndex, long deadline, Responses rsps) {
        if (theFuture.isDone()) {
            return;
        }
        if (this.timeService.isTimeExpired(deadline)) {
            rsps.setTimedOut();
            if (trace) {
                log.tracef("All requests timed out: " + rsps, new Object[0]);
            }
            theFuture.complete(rsps);
            return;
        }
        try {
            this.processCallsStaggered(command, filter, dests, mode, deliverOrder, theFuture, destIndex + 1, deadline, rsps);
        }
        catch (Exception e) {
            theFuture.completeExceptionally(e);
        }
    }

    private CompletableFuture<Responses> processCalls(ReplicableCommand command, boolean broadcast, long timeout, RspFilter filter, List<Address> dests, ResponseMode mode, DeliverOrder deliverOrder) throws Exception {
        if (trace) {
            log.tracef("Replication task sending %s to addresses %s with response mode %s", command, dests, mode);
        }
        boolean rsvp = CommandAwareRpcDispatcher.isRsvpCommand(command);
        Buffer buf = this.marshallCall(command);
        RequestOptions opts = CommandAwareRpcDispatcher.constructRequestOptions(mode, rsvp, deliverOrder, timeout, true);
        List<Address> realDest = dests;
        if (deliverOrder == DeliverOrder.TOTAL) {
            opts.anycasting(true).useAnycastAddresses(true);
        } else if (broadcast || FORCE_MCAST) {
            opts.anycasting(false);
            realDest = null;
        } else {
            opts.anycasting(true).setUseAnycastAddresses(false);
        }
        opts.rspFilter(filter);
        GroupRequest request = this.cast(realDest, buf, opts, false);
        if (mode == ResponseMode.GET_NONE) {
            return null;
        }
        RspListFuture retval = new RspListFuture(dests, (GroupRequest<Response>)request);
        if (timeout > 0L && !retval.isDone()) {
            ScheduledFuture<Void> timeoutFuture = this.timeoutExecutor.schedule(retval, timeout, TimeUnit.MILLISECONDS);
            retval.setTimeoutFuture(timeoutFuture);
        }
        return retval;
    }

    static boolean isRsvpCommand(ReplicableCommand command) {
        return command instanceof FlagAffectedCommand && ((FlagAffectedCommand)command).hasAnyFlag(FlagBitSets.GUARANTEED_DELIVERY);
    }

    public StreamingMarshaller getIspnMarshaller() {
        return this.ispnMarshaller;
    }

    public void setIspnMarshaller(StreamingMarshaller ispnMarshaller) {
        this.ispnMarshaller = ispnMarshaller;
    }
}

