/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.tm;

import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.Xid;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.util.Util;

public final class EmbeddedXid
implements Xid {
    private static final int FORMAT = 1;
    private static final AtomicLong GLOBAL_ID_GENERATOR = new AtomicLong(1L);
    private static final AtomicLong BRANCH_QUALIFIER_GENERATOR = new AtomicLong(1L);
    private final int cachedHashcode;
    private byte[] globalTransactionId = new byte[64];
    private byte[] branchQualifier = new byte[64];

    public EmbeddedXid(UUID transactionManagerId) {
        this.cachedHashcode = this.initializeAndCalculateHash(transactionManagerId);
    }

    @Override
    public int getFormatId() {
        return 1;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public String toString() {
        return "EmbeddedXid{, globalTransactionId = " + Util.printArray((byte[])this.globalTransactionId, (boolean)false) + ", branchQualifier = " + Util.printArray((byte[])this.branchQualifier, (boolean)false) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Xid)) {
            return false;
        }
        Xid other = (Xid)o;
        return other.getFormatId() == 1 && Arrays.equals(this.branchQualifier, other.getBranchQualifier()) && Arrays.equals(this.globalTransactionId, other.getGlobalTransactionId());
    }

    public int hashCode() {
        return this.cachedHashcode;
    }

    private int initializeAndCalculateHash(UUID transactionManagerId) {
        int hc1 = this.initialize(transactionManagerId, GLOBAL_ID_GENERATOR, this.globalTransactionId);
        return 37 * hc1 + this.initialize(transactionManagerId, BRANCH_QUALIFIER_GENERATOR, this.branchQualifier);
    }

    private int initialize(UUID transactionManagerId, AtomicLong generator, byte[] field) {
        long lsb = transactionManagerId.getLeastSignificantBits();
        long msb = transactionManagerId.getMostSignificantBits();
        long id = generator.getAndIncrement();
        Arrays.fill(field, (byte)0);
        UnsignedNumeric.writeUnsignedLong((byte[])field, (int)0, (long)lsb);
        UnsignedNumeric.writeUnsignedLong((byte[])field, (int)10, (long)msb);
        UnsignedNumeric.writeUnsignedLong((byte[])field, (int)20, (long)id);
        int hash = (int)(lsb ^ lsb >>> 32);
        hash = 37 * hash + (int)(msb ^ msb >>> 32);
        hash = 37 * hash + (int)(id ^ id >>> 32);
        return hash;
    }
}

