/*
 * Decompiled with CFR 0.152.
 */
package org.beanio;

import java.util.Collection;
import java.util.Map;
import org.beanio.BeanReaderException;
import org.beanio.RecordContext;

public class InvalidRecordException
extends BeanReaderException {
    private static final long serialVersionUID = 2L;

    protected InvalidRecordException(String message) {
        this(null, message);
    }

    public InvalidRecordException(RecordContext context, String message) {
        super(message);
        this.setRecordContext(context);
    }

    public String getRecordName() {
        RecordContext ctx = this.getRecordContext();
        return ctx != null ? ctx.getRecordName() : null;
    }

    public String toString() {
        String message = super.toString();
        if (this.getRecordCount() == 0) {
            return message;
        }
        StringBuilder s = new StringBuilder(message);
        this.appendMessageDetails(s);
        return s.toString();
    }

    protected void appendMessageDetails(StringBuilder s) {
        RecordContext context = this.getRecordContext();
        if (context.hasRecordErrors()) {
            for (String string : context.getRecordErrors()) {
                s.append("\n ==> ");
                s.append(string);
            }
        }
        if (context.hasFieldErrors()) {
            for (Map.Entry entry : context.getFieldErrors().entrySet()) {
                String fieldName = (String)entry.getKey();
                for (String error : (Collection)entry.getValue()) {
                    s.append("\n ==> Invalid '");
                    s.append(fieldName);
                    s.append("':  ");
                    s.append(error);
                }
            }
        }
    }
}

