/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.config.annotation;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.beanio.BeanIOConfigurationException;
import org.beanio.annotation.Field;
import org.beanio.annotation.Fields;
import org.beanio.annotation.Group;
import org.beanio.annotation.Record;
import org.beanio.annotation.Segment;
import org.beanio.internal.config.ComponentConfig;
import org.beanio.internal.config.FieldConfig;
import org.beanio.internal.config.GroupConfig;
import org.beanio.internal.config.PropertyConfig;
import org.beanio.internal.config.RecordConfig;
import org.beanio.internal.config.SegmentConfig;
import org.beanio.internal.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationParser {
    private static final Comparator<ComponentConfig> ORDINAL_COMPARATOR = new Comparator<ComponentConfig>(){

        @Override
        public int compare(ComponentConfig c1, ComponentConfig c2) {
            Integer o1 = c1.getOrdinal();
            Integer o2 = c2.getOrdinal();
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    };

    public static GroupConfig createGroupConfig(ClassLoader classLoader, String type) {
        Class<?> clazz = TypeUtil.toBeanType(classLoader, type);
        if (clazz == null) {
            return null;
        }
        return AnnotationParser.createGroupConfig(clazz);
    }

    public static GroupConfig createGroupConfig(Class<?> clazz) {
        Group group = clazz.getAnnotation(Group.class);
        if (group == null) {
            return null;
        }
        String name = AnnotationParser.toValue(group.name());
        if (name == null) {
            name = Introspector.decapitalize(clazz.getSimpleName());
        }
        TypeInfo info = new TypeInfo();
        info.name = name;
        info.type = clazz;
        return AnnotationParser.createGroup(info, group);
    }

    public static RecordConfig createRecordConfig(ClassLoader classLoader, String type) {
        Class<?> clazz = TypeUtil.toBeanType(classLoader, type);
        if (clazz == null) {
            return null;
        }
        return AnnotationParser.createRecordConfig(clazz);
    }

    public static RecordConfig createRecordConfig(Class<?> clazz) {
        Record record = clazz.getAnnotation(Record.class);
        if (record == null) {
            return null;
        }
        String name = AnnotationParser.toValue(record.name());
        if (name == null) {
            name = Introspector.decapitalize(clazz.getSimpleName());
        }
        TypeInfo info = new TypeInfo();
        info.name = name;
        info.type = clazz;
        return AnnotationParser.createRecord(info, record);
    }

    private static void addAllChildren(ComponentConfig config, Class<?> clazz) {
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz != null && superclazz != Object.class) {
            AnnotationParser.addAllChildren(config, superclazz);
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            AnnotationParser.addAllChildren(config, intf);
        }
        AnnotationParser.addChildren(config, clazz);
    }

    private static void handleConstructor(ComponentConfig config, Class<?> clazz) {
        try {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                Class<?>[] parameters = constructor.getParameterTypes();
                Type[] parameterTypes = constructor.getGenericParameterTypes();
                Annotation[][] annotations = constructor.getParameterAnnotations();
                for (int i = 0; i < annotations.length; ++i) {
                    Field fa = null;
                    for (int j = 0; j < annotations[i].length; ++j) {
                        if (annotations[i][j].annotationType() != Field.class) continue;
                        fa = (Field)annotations[i][j];
                        break;
                    }
                    if (fa == null) continue;
                    TypeInfo info = new TypeInfo();
                    info.carg = i + 1;
                    info.name = AnnotationParser.toValue(fa.name());
                    info.type = parameters[i];
                    info.genericType = parameterTypes[i];
                    config.add(AnnotationParser.createField(info, fa));
                }
            }
        }
        catch (IllegalArgumentException ex) {
            throw new BeanIOConfigurationException("Invalid @Field annotation on a constructor parameter in class '" + clazz.getName() + "': " + ex.getMessage(), ex);
        }
    }

    private static void addChildren(ComponentConfig config, Class<?> parent) {
        if (config.getComponentType() == 'G') {
            AnnotationParser.addGroupChildren(config, parent);
        } else {
            AnnotationParser.addRecordChildren(config, parent);
        }
    }

    private static void addGroupChildren(ComponentConfig config, Class<?> parent) {
        Record ra;
        Group ga;
        for (java.lang.reflect.Field field : parent.getDeclaredFields()) {
            PropertyConfig child;
            ga = field.getAnnotation(Group.class);
            ra = field.getAnnotation(Record.class);
            if (ra == null && ga == null) continue;
            if (ra != null && ga != null) {
                throw new BeanIOConfigurationException("Field '" + field.getName() + "' on class '" + parent.getName() + "' cannot be annotated with " + "both @Record and @Group");
            }
            TypeInfo info = new TypeInfo();
            info.bound = true;
            info.name = field.getName();
            info.type = field.getType();
            info.genericType = field.getGenericType();
            try {
                child = ra != null ? AnnotationParser.createRecord(info, ra) : AnnotationParser.createGroup(info, ga);
            }
            catch (IllegalArgumentException ex) {
                throw new BeanIOConfigurationException("Invalid annotation for field '" + field.getName() + "' on class '" + parent.getName() + "': " + ex.getMessage(), ex);
            }
            config.add(child);
        }
        for (AccessibleObject accessibleObject : parent.getDeclaredMethods()) {
            PropertyConfig child;
            Type type;
            Class<?> clazz;
            ga = ((Method)accessibleObject).getAnnotation(Group.class);
            ra = ((Method)accessibleObject).getAnnotation(Record.class);
            if (ra == null && ga == null) continue;
            if (ra != null && ga != null) {
                throw new BeanIOConfigurationException("Method '" + ((Method)accessibleObject).getName() + "' on class '" + parent.getName() + "' cannot be annotated with " + "both @Record and @Group");
            }
            String name = ((Method)accessibleObject).getName();
            String getter = null;
            String setter = null;
            if (((Method)accessibleObject).getReturnType() != Void.TYPE && ((Method)accessibleObject).getParameterTypes().length == 0) {
                getter = name;
                clazz = ((Method)accessibleObject).getReturnType();
                type = ((Method)accessibleObject).getGenericReturnType();
                if (name.startsWith("get")) {
                    name = name.substring(3);
                } else if (name.startsWith("is")) {
                    name = name.substring(2);
                }
            } else if (((Method)accessibleObject).getReturnType() == Void.TYPE && ((Method)accessibleObject).getParameterTypes().length == 1) {
                setter = name;
                clazz = ((Method)accessibleObject).getParameterTypes()[0];
                type = ((Method)accessibleObject).getGenericParameterTypes()[0];
                if (name.startsWith("set")) {
                    name = name.substring(3);
                }
            } else {
                throw new BeanIOConfigurationException("Method '" + ((Method)accessibleObject).getName() + "' on class '" + parent.getName() + "' is not a valid getter or setter");
            }
            name = Introspector.decapitalize(name);
            TypeInfo info = new TypeInfo();
            info.bound = true;
            info.name = name;
            info.type = clazz;
            info.genericType = type;
            info.getter = getter;
            info.setter = setter;
            try {
                child = ra != null ? AnnotationParser.createRecord(info, ra) : AnnotationParser.createGroup(info, ga);
            }
            catch (IllegalArgumentException ex) {
                throw new BeanIOConfigurationException("Invalid annotation for method '" + ((Method)accessibleObject).getName() + "' on class '" + parent.getName() + "': " + ex.getMessage(), ex);
            }
            config.add(child);
        }
    }

    private static void addRecordChildren(ComponentConfig config, Class<?> parent) {
        Segment sa;
        Field fa;
        for (java.lang.reflect.Field field : parent.getDeclaredFields()) {
            PropertyConfig child;
            fa = field.getAnnotation(Field.class);
            sa = field.getAnnotation(Segment.class);
            if (fa == null && sa == null) continue;
            if (fa != null && sa != null) {
                throw new BeanIOConfigurationException("Field '" + field.getName() + "' on class '" + parent.getName() + "' cannot be annotated with " + "both @Field and @Segment");
            }
            TypeInfo info = new TypeInfo();
            info.name = field.getName();
            info.type = field.getType();
            info.genericType = field.getGenericType();
            try {
                child = fa != null ? AnnotationParser.createField(info, fa) : AnnotationParser.createSegment(info, sa, field.getAnnotation(Fields.class));
            }
            catch (IllegalArgumentException ex) {
                throw new BeanIOConfigurationException("Invalid annotation for field '" + field.getName() + "' on class '" + parent.getName() + "': " + ex.getMessage(), ex);
            }
            config.add(child);
        }
        for (AccessibleObject accessibleObject : parent.getDeclaredMethods()) {
            PropertyConfig child;
            Type type;
            Class<?> clazz;
            fa = ((Method)accessibleObject).getAnnotation(Field.class);
            sa = ((Method)accessibleObject).getAnnotation(Segment.class);
            if (fa == null && sa == null) continue;
            if (fa != null && sa != null) {
                throw new BeanIOConfigurationException("Method '" + ((Method)accessibleObject).getName() + "' on class '" + parent.getName() + "' cannot be annotated with " + "both @Field and @Segment");
            }
            String name = ((Method)accessibleObject).getName();
            String getter = null;
            String setter = null;
            if (((Method)accessibleObject).getReturnType() != Void.TYPE && ((Method)accessibleObject).getParameterTypes().length == 0) {
                getter = name;
                clazz = ((Method)accessibleObject).getReturnType();
                type = ((Method)accessibleObject).getGenericReturnType();
                if (name.startsWith("get")) {
                    name = name.substring(3);
                } else if (name.startsWith("is")) {
                    name = name.substring(2);
                }
            } else if (((Method)accessibleObject).getReturnType() == Void.TYPE && ((Method)accessibleObject).getParameterTypes().length == 1) {
                setter = name;
                clazz = ((Method)accessibleObject).getParameterTypes()[0];
                type = ((Method)accessibleObject).getGenericParameterTypes()[0];
                if (name.startsWith("set")) {
                    name = name.substring(3);
                }
            } else {
                throw new BeanIOConfigurationException("Method '" + ((Method)accessibleObject).getName() + "' on class '" + parent.getName() + "' is not a valid getter or setter");
            }
            name = Introspector.decapitalize(name);
            TypeInfo info = new TypeInfo();
            info.name = name;
            info.type = clazz;
            info.genericType = type;
            info.getter = getter;
            info.setter = setter;
            try {
                child = fa != null ? AnnotationParser.createField(info, fa) : AnnotationParser.createSegment(info, sa, ((Method)accessibleObject).getAnnotation(Fields.class));
            }
            catch (IllegalArgumentException ex) {
                throw new BeanIOConfigurationException("Invalid annotation for method '" + ((Method)accessibleObject).getName() + "' on class '" + parent.getName() + "': " + ex.getMessage(), ex);
            }
            config.add(child);
        }
    }

    private static GroupConfig createGroup(TypeInfo info, Group group) {
        AnnotationParser.updateTypeInfo(info, group.type(), group.collection());
        GroupConfig gc = new GroupConfig();
        gc.setName(info.name);
        gc.setType(info.propertyName);
        gc.setCollection(info.collectionName);
        Integer minOccurs = AnnotationParser.toValue(group.minOccurs());
        Integer maxOccurs = AnnotationParser.toUnboundedValue(group.maxOccurs());
        if (maxOccurs == null && info.collectionName == null && info.bound) {
            maxOccurs = 1;
        }
        gc.setMinOccurs(minOccurs);
        gc.setMaxOccurs(maxOccurs);
        gc.setXmlType(group.xmlType().toValue());
        gc.setXmlName(AnnotationParser.toXmlValue(group.xmlName()));
        gc.setXmlNamespace(AnnotationParser.toXmlValue(group.xmlNamespace()));
        gc.setXmlPrefix(AnnotationParser.toXmlValue(group.xmlPrefix()));
        AnnotationParser.addAllChildren(gc, info.propertyType);
        return gc;
    }

    private static RecordConfig createRecord(TypeInfo info, Record record) {
        AnnotationParser.updateTypeInfo(info, record.type(), record.collection());
        RecordConfig rc = new RecordConfig();
        rc.setName(info.name);
        String target = AnnotationParser.toValue(record.value());
        if (target == null) {
            rc.setType(info.propertyName);
        } else {
            rc.setTarget(target);
        }
        rc.setCollection(info.collectionName);
        rc.setOrder(AnnotationParser.toValue(record.order()));
        Integer minOccurs = AnnotationParser.toValue(record.minOccurs());
        Integer maxOccurs = AnnotationParser.toUnboundedValue(record.maxOccurs());
        if (info.bound && maxOccurs == null && info.collectionName == null) {
            maxOccurs = 1;
        }
        rc.setMinOccurs(minOccurs);
        rc.setMaxOccurs(maxOccurs);
        rc.setMinLength(AnnotationParser.toValue(record.minLength()));
        rc.setMaxLength(AnnotationParser.toUnboundedValue(record.maxLength()));
        rc.setMinMatchLength(AnnotationParser.toValue(record.minRidLength()));
        rc.setMaxMatchLength(AnnotationParser.toUnboundedValue(record.maxRidLength()));
        rc.setXmlType(record.xmlType().toValue());
        rc.setXmlName(AnnotationParser.toXmlValue(record.xmlName()));
        rc.setXmlNamespace(AnnotationParser.toXmlValue(record.xmlNamespace()));
        rc.setXmlPrefix(AnnotationParser.toXmlValue(record.xmlPrefix()));
        Fields fields = info.propertyType.getAnnotation(Fields.class);
        if (fields != null) {
            for (Field field : fields.value()) {
                rc.add(AnnotationParser.createField(null, field));
            }
        }
        AnnotationParser.handleConstructor(rc, info.propertyType);
        AnnotationParser.addAllChildren(rc, info.propertyType);
        rc.sort(ORDINAL_COMPARATOR);
        return rc;
    }

    private static SegmentConfig createSegment(TypeInfo info, Segment sa, Fields fields) {
        AnnotationParser.updateTypeInfo(info, sa.type(), sa.collection());
        if (info.propertyType == String.class) {
            throw new IllegalArgumentException("type is undefined");
        }
        String target = AnnotationParser.toValue(sa.value());
        SegmentConfig sc = new SegmentConfig();
        sc.setName(info.name);
        sc.setLabel(AnnotationParser.toValue(sa.name()));
        if (target == null) {
            sc.setType(info.propertyName);
        } else {
            sc.setTarget(target);
        }
        sc.setCollection(info.collectionName);
        sc.setGetter(AnnotationParser.toValue(sa.getter()));
        if (sc.getGetter() == null) {
            sc.setGetter(info.getter);
        }
        sc.setSetter(AnnotationParser.toValue(sa.setter()));
        if (sc.getSetter() == null) {
            sc.setSetter(info.setter);
        }
        sc.setPosition(AnnotationParser.toValue(sa.at()));
        sc.setUntil(AnnotationParser.toValue(sa.until()));
        sc.setOrdinal(AnnotationParser.toValue(sa.ordinal()));
        sc.setMinOccurs(AnnotationParser.toValue(sa.minOccurs()));
        sc.setMaxOccurs(AnnotationParser.toUnboundedValue(sa.maxOccurs()));
        sc.setOccursRef(AnnotationParser.toValue(sa.occursRef()));
        sc.setKey(AnnotationParser.toValue(sa.key()));
        sc.setLazy(sa.lazy());
        sc.setXmlType(sa.xmlType().toValue());
        sc.setXmlName(AnnotationParser.toXmlValue(sa.xmlName()));
        sc.setXmlNamespace(AnnotationParser.toXmlValue(sa.xmlNamespace()));
        sc.setXmlPrefix(AnnotationParser.toXmlValue(sa.xmlPrefix()));
        sc.setNillable(sa.nillable());
        if (sc.getName() == null) {
            throw new IllegalArgumentException("name is undefined");
        }
        if (fields != null) {
            for (Field field : fields.value()) {
                sc.add(AnnotationParser.createField(null, field));
            }
        }
        if ((fields = info.propertyType.getAnnotation(Fields.class)) != null) {
            for (Field field : fields.value()) {
                sc.add(AnnotationParser.createField(null, field));
            }
        }
        AnnotationParser.handleConstructor(sc, info.propertyType);
        AnnotationParser.addAllChildren(sc, info.propertyType);
        return sc;
    }

    private static FieldConfig createField(TypeInfo info, Field fa) {
        FieldConfig fc = new FieldConfig();
        if (info != null) {
            AnnotationParser.updateTypeInfo(info, fa.type(), fa.collection());
            fc.setName(info.name);
            fc.setLabel(AnnotationParser.toValue(fa.name()));
            fc.setType(info.propertyName);
            fc.setCollection(info.collectionName);
            fc.setBound(true);
            fc.setGetter(AnnotationParser.toValue(fa.getter()));
            if (fc.getGetter() == null) {
                fc.setGetter(info.getter);
            }
            String setter = AnnotationParser.toValue(fa.setter());
            if (info.carg != null) {
                fc.setSetter("#" + info.carg);
                if (setter != null) {
                    throw new BeanIOConfigurationException("setter not allowed");
                }
            } else {
                fc.setSetter(setter);
                if (fc.getSetter() == null) {
                    fc.setSetter(info.setter);
                }
            }
        } else {
            fc.setName(AnnotationParser.toValue(fa.name()));
            fc.setLabel(fc.getName());
            fc.setBound(false);
        }
        if (fc.getName() == null) {
            throw new IllegalArgumentException("name is required");
        }
        fc.setLiteral(AnnotationParser.toValue(fa.literal()));
        fc.setPosition(AnnotationParser.toValue(fa.at()));
        fc.setUntil(AnnotationParser.toValue(fa.until()));
        fc.setOrdinal(AnnotationParser.toValue(fa.ordinal()));
        fc.setRegex(AnnotationParser.toValue(fa.regex()));
        fc.setFormat(AnnotationParser.toValue(fa.format()));
        fc.setRequired(fa.required());
        fc.setDefault(AnnotationParser.toValue(fa.defaultValue()));
        fc.setIdentifier(fa.rid());
        fc.setTrim(fa.trim());
        fc.setLazy(fa.lazy());
        fc.setMinLength(AnnotationParser.toValue(fa.minLength()));
        fc.setMaxLength(AnnotationParser.toUnboundedValue(fa.maxLength()));
        fc.setMinOccurs(AnnotationParser.toValue(fa.minOccurs()));
        fc.setMaxOccurs(AnnotationParser.toUnboundedValue(fa.maxOccurs()));
        fc.setOccursRef(AnnotationParser.toValue(fa.occursRef()));
        fc.setLength(AnnotationParser.toValue(fa.length()));
        if (fa.padding() >= 0 && fa.padding() <= 65535) {
            fc.setPadding(Character.valueOf((char)fa.padding()));
        }
        fc.setJustify(fa.align().toString().toLowerCase());
        fc.setKeepPadding(fa.keepPadding());
        fc.setLenientPadding(fa.lenientPadding());
        fc.setTypeHandler(AnnotationParser.toValue(fa.handlerName()));
        Class<?> handler = AnnotationParser.toValue(fa.handlerClass());
        if (handler != null && fc.getTypeHandler() == null) {
            fc.setTypeHandler(fa.handlerClass().getName());
        }
        fc.setXmlType(fa.xmlType().toValue());
        fc.setXmlName(AnnotationParser.toXmlValue(fa.xmlName()));
        fc.setXmlNamespace(AnnotationParser.toXmlValue(fa.xmlNamespace()));
        fc.setXmlPrefix(AnnotationParser.toXmlValue(fa.xmlPrefix()));
        fc.setNillable(fa.nillable());
        return fc;
    }

    private static void updateTypeInfo(TypeInfo info, Class<?> annotatedType, Class<?> annotatedCollection) {
        annotatedType = AnnotationParser.toValue(annotatedType);
        String propertyName = null;
        String collectionName = null;
        Class<?> propertyType = info.type;
        if (propertyType.isArray()) {
            if (annotatedType != null) {
                propertyType = annotatedType;
            } else if ((propertyType = propertyType.getComponentType()).isPrimitive()) {
                propertyType = TypeUtil.toWrapperClass(propertyType);
            }
            collectionName = "array";
        } else if (Map.class.isAssignableFrom(propertyType)) {
            Class<?> collectionType = AnnotationParser.toValue(annotatedCollection);
            if (collectionType == null) {
                collectionType = propertyType;
                propertyType = null;
            }
            if (annotatedType != null) {
                propertyType = annotatedType;
            } else {
                ParameterizedType pt;
                if (info.genericType instanceof ParameterizedType && (pt = (ParameterizedType)info.genericType).getActualTypeArguments().length > 1) {
                    propertyType = (Class<?>)pt.getActualTypeArguments()[1];
                }
                if (propertyType == null) {
                    propertyType = String.class;
                }
            }
            collectionName = collectionType.getName();
        } else if (Collection.class.isAssignableFrom(propertyType)) {
            Class<?> collectionType = AnnotationParser.toValue(annotatedCollection);
            if (collectionType == null) {
                collectionType = propertyType;
                propertyType = null;
            }
            if (annotatedType != null) {
                propertyType = annotatedType;
            } else {
                ParameterizedType pt;
                if (info.genericType instanceof ParameterizedType && (pt = (ParameterizedType)info.genericType).getActualTypeArguments().length > 0) {
                    propertyType = (Class)pt.getActualTypeArguments()[0];
                }
                if (propertyType == null) {
                    propertyType = String.class;
                }
            }
            collectionName = collectionType.getName();
        } else if (annotatedType != null) {
            propertyType = annotatedType;
        } else if (propertyType.isPrimitive()) {
            propertyType = TypeUtil.toWrapperClass(propertyType);
        }
        if (propertyName == null) {
            propertyName = propertyType.getName();
        }
        info.propertyType = propertyType;
        info.propertyName = propertyName;
        info.collectionName = collectionName;
    }

    private static Class<?> toValue(Class<?> type) {
        return Void.class == type ? null : type;
    }

    private static Integer toValue(int n) {
        return n == Integer.MIN_VALUE ? null : Integer.valueOf(n);
    }

    private static Integer toUnboundedValue(int n) {
        Integer val = AnnotationParser.toValue(n);
        if (val == null) {
            return null;
        }
        if (val.compareTo(new Integer(0)) < 0) {
            return Integer.MAX_VALUE;
        }
        return val;
    }

    private static String toValue(String s) {
        return "".equals(s) ? null : s;
    }

    private static String toXmlValue(String s) {
        return "{undefined}".equals(s) ? null : s;
    }

    private static class TypeInfo {
        boolean bound;
        Integer carg;
        String name;
        Class<?> type;
        Type genericType;
        String propertyName;
        String collectionName;
        Class<?> propertyType;
        String getter;
        String setter;

        private TypeInfo() {
        }
    }
}

