/*
 * Decompiled with CFR 0.152.
 */
package org.beanio.internal.parser;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import org.beanio.BeanIOException;
import org.beanio.BeanReaderException;
import org.beanio.internal.parser.Component;
import org.beanio.internal.parser.ParserLocal;
import org.beanio.internal.parser.ParsingContext;
import org.beanio.internal.parser.Property;
import org.beanio.internal.parser.PropertyAccessor;
import org.beanio.internal.parser.PropertyComponent;
import org.beanio.internal.parser.Value;
import org.beanio.internal.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bean
extends PropertyComponent
implements Property {
    private ParserLocal<Object> bean = new ParserLocal<Object>(){

        @Override
        public Object createDefaultValue() {
            return Bean.this.isRequired() ? null : Value.MISSING;
        }
    };
    private Constructor<?> constructor;
    private ParserLocal<Object[]> constructorArgs = new ParserLocal<Object[]>(){

        @Override
        public Object[] createDefaultValue() {
            return Bean.this.constructor != null ? new Object[Bean.this.constructor.getParameterTypes().length] : null;
        }
    };
    private boolean lazy;

    @Override
    public void clearValue(ParsingContext context) {
        for (Component child : this.getChildren()) {
            ((Property)((Object)child)).clearValue(context);
        }
        this.bean.set(context, this.isRequired() ? null : Value.MISSING);
    }

    @Override
    public boolean defines(Object bean) {
        if (this.getType() == null) {
            return false;
        }
        if (bean == null) {
            return this.isMatchNull();
        }
        if (!this.getType().isAssignableFrom(bean.getClass())) {
            return false;
        }
        if (!this.isIdentifier()) {
            return true;
        }
        for (Component child : this.getChildren()) {
            Object value;
            Property property = (Property)((Object)child);
            if (!property.isIdentifier() || property.defines(value = property.getAccessor().getValue(bean))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object createValue(ParsingContext context) {
        Object b = null;
        boolean hasProperties = false;
        if (this.constructor != null) {
            boolean create = false;
            Object[] cargs = this.constructorArgs.get(context);
            for (Component child : this.getChildren()) {
                Property property = (Property)((Object)child);
                PropertyAccessor accessor = property.getAccessor();
                if (accessor == null) {
                    throw new IllegalStateException("Accessor not set for property value '" + child.getName() + "'");
                }
                if (!accessor.isConstructorArgument()) continue;
                Object value = property.getValue(context);
                if (value == Value.INVALID) {
                    return Value.INVALID;
                }
                if (value == Value.MISSING) {
                    value = createMissingBeans ? property.createValue(context) : null;
                } else {
                    hasProperties = true;
                    create = create || !this.lazy || StringUtil.hasValue(value);
                }
                cargs[accessor.getConstructorArgumentIndex()] = value;
            }
            if (create) {
                b = this.newInstance(context);
            }
        }
        for (Component child : this.getChildren()) {
            Property property = (Property)((Object)child);
            if (property.getAccessor().isConstructorArgument()) continue;
            Object value = property.getValue(context);
            if (createMissingBeans && value == Value.MISSING) {
                value = property.createValue(context);
            }
            if (value == Value.INVALID) {
                this.bean.set(context, b);
                return Value.INVALID;
            }
            if (value == Value.MISSING) continue;
            hasProperties = true;
            if (b == null) {
                if (this.lazy) {
                    if (!StringUtil.hasValue(value)) continue;
                    b = this.newInstance(context);
                    this.backfill(context, b, child);
                } else {
                    b = this.newInstance(context);
                }
            }
            try {
                if (value == null && property.getType().isPrimitive()) continue;
                property.getAccessor().setValue(b, value);
            }
            catch (Exception ex) {
                throw new BeanIOException("Failed to set property '" + property.getName() + "' on bean '" + this.getName() + "'", ex);
            }
        }
        if (b == null) {
            b = this.isRequired() || createMissingBeans ? this.newInstance(context) : (hasProperties ? null : Value.MISSING);
        }
        this.bean.set(context, b);
        return b;
    }

    private void backfill(ParsingContext context, Object bean, Component stop) {
        for (Component child : this.getChildren()) {
            Object value;
            if (stop == child) {
                return;
            }
            Property property = (Property)((Object)child);
            if (property.getAccessor().isConstructorArgument() || (value = property.getValue(context)) == Value.MISSING) continue;
            try {
                property.getAccessor().setValue(bean, value);
            }
            catch (Exception ex) {
                throw new BeanIOException("Failed to set property '" + property.getName() + "' on bean '" + this.getName() + "'", ex);
            }
        }
    }

    @Override
    public Object getValue(ParsingContext context) {
        return this.bean.get(context);
    }

    @Override
    public void setValue(ParsingContext context, Object value) {
        if (value == null) {
            this.clearValue(context);
            return;
        }
        Object b = value;
        Object defaultValue = null;
        for (Component child : this.getChildren()) {
            Property property = (Property)((Object)child);
            Object propertyValue = defaultValue;
            if (b != null) {
                propertyValue = property.getAccessor().getValue(b);
            }
            property.setValue(context, propertyValue);
        }
        this.bean.set(context, b);
    }

    protected Object newInstance(ParsingContext context) {
        Class<?> beanClass = this.getType();
        if (beanClass == null) {
            return null;
        }
        try {
            if (this.constructor == null) {
                return beanClass.newInstance();
            }
            return this.constructor.newInstance(this.constructorArgs.get(context));
        }
        catch (Exception e) {
            throw new BeanReaderException("Failed to instantiate class '" + beanClass.getName() + "'", e);
        }
    }

    @Override
    protected boolean isSupportedChild(Component child) {
        return child instanceof Property;
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
    }

    @Override
    public int type() {
        return this.isMap() ? 3 : 1;
    }

    protected boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    public void registerLocals(Set<ParserLocal<?>> locals) {
        if (locals.add(this.bean)) {
            locals.add(this.constructorArgs);
            super.registerLocals(locals);
        }
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }
}

